/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.util;

import io.jans.configapi.configuration.ConfigurationFactory;
import io.jans.model.SimpleProperty;
import io.jans.model.ldap.GluuLdapConfiguration;
import io.jans.orm.ldap.operation.impl.LdapConnectionProvider;
import io.jans.util.properties.FileConfiguration;
import io.jans.util.security.PropertiesDecrypter;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@ApplicationScoped
public class ConnectionStatus {
    @Inject
    Logger logger;
    @Inject
    ConfigurationFactory configurationFactory;

    public boolean isUp(GluuLdapConfiguration ldapConfiguration) {
        this.logger.info(" LDAP Connection Status parameters - ldapConfiguration:{}, ldapConfiguration.getBindDN():{}, ldapConfiguration.getBindPassword()):{}, ldapConfiguration.isUseSSL():{} ", new Object[]{ldapConfiguration, ldapConfiguration.getBindDN(), ldapConfiguration.getBindPassword(), ldapConfiguration.isUseSSL()});
        Properties properties = System.getProperties();
        properties.setProperty("bindDN", ldapConfiguration.getBindDN());
        properties.setProperty("bindPassword", ldapConfiguration.getBindPassword());
        properties.setProperty("servers", ConnectionStatus.buildServersString(ConnectionStatus.getServers(ldapConfiguration)));
        properties.setProperty("useSSL", Boolean.toString(ldapConfiguration.isUseSSL()));
        Properties ldapDecryptedProperties = PropertiesDecrypter.decryptProperties((Properties)properties, (String)this.configurationFactory.getCryptoConfigurationSalt());
        this.logger.trace("Attempting to create LDAP connection with properties: {}", (Object)ldapDecryptedProperties);
        LdapConnectionProvider connectionProvider = new LdapConnectionProvider(PropertiesDecrypter.decryptProperties((Properties)properties, (String)this.configurationFactory.getCryptoConfigurationSalt()));
        this.logger.trace("connectionProvider: {}", (Object)connectionProvider);
        connectionProvider.create(ldapDecryptedProperties);
        this.logger.info("Connection status connectionProvider.isConnected(): {}", (Object)connectionProvider.isConnected());
        if (connectionProvider.isConnected()) {
            this.logger.trace("Connect to LDAP");
            connectionProvider.closeConnectionPool();
            return true;
        }
        return false;
    }

    @NotNull
    private FileConfiguration loadFileConfiguration() {
        try {
            return new FileConfiguration(ConfigurationFactory.getAppPropertiesFile());
        }
        catch (Exception ex) {
            this.logger.error("Failed to load configuration.", (Throwable)ex);
            return new FileConfiguration("jans-ldap.properties");
        }
    }

    private static List<String> getServers(GluuLdapConfiguration ldapConfiguration) {
        ArrayList<String> servers = new ArrayList<String>();
        for (SimpleProperty server : ldapConfiguration.getServers()) {
            servers.add(server.getValue());
        }
        return servers;
    }

    private static String buildServersString(List<String> servers) {
        if (servers == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String server : servers) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(server);
        }
        return sb.toString();
    }
}

