/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.util;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class TtlCache<K, V> {
    private final Map<K, CacheEntry<V>> cache = new ConcurrentHashMap<K, CacheEntry<V>>();
    private final Queue<K> insertionOrder = new ConcurrentLinkedQueue<K>();
    private final int maxSize;

    public TtlCache(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize must be > 0");
        }
        this.maxSize = maxSize;
    }

    public void put(K key, V value, long ttlMillis) {
        this.evictIfNeeded();
        CacheEntry<V> entry = new CacheEntry<V>(value, ttlMillis);
        CacheEntry<V> previous = this.cache.put(key, entry);
        if (previous == null) {
            this.insertionOrder.offer(key);
        }
    }

    public V get(K key) {
        CacheEntry<V> entry = this.cache.get(key);
        if (entry == null) {
            return null;
        }
        if (entry.isExpired()) {
            this.cache.remove(key, entry);
            return null;
        }
        return entry.value;
    }

    public void remove(K key) {
        this.cache.remove(key);
    }

    private void evictIfNeeded() {
        K oldestKey;
        this.cache.forEach((key, entry) -> {
            if (entry.isExpired()) {
                this.cache.remove(key, entry);
            }
        });
        while (this.cache.size() >= this.maxSize && (oldestKey = this.insertionOrder.poll()) != null) {
            CacheEntry<V> entry2 = this.cache.get(oldestKey);
            if (entry2 == null || !entry2.isExpired()) continue;
            this.cache.remove(oldestKey, entry2);
        }
    }

    private static class CacheEntry<V> {
        private final V value;
        private final long expiryTime;

        CacheEntry(V value, long ttlMillis) {
            this.value = value;
            this.expiryTime = System.currentTimeMillis() + ttlMillis;
        }

        boolean isExpired() {
            return System.currentTimeMillis() > this.expiryTime;
        }
    }
}

