/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.core.protect;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import io.jans.configapi.core.protect.Condition;
import io.jans.configapi.core.protect.Scope;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RsResource
implements Serializable {
    @JsonProperty(value="path")
    String path;
    @JsonProperty(value="conditions")
    List<Condition> conditions;
    @JsonProperty(value="iat")
    private Integer iat;
    @JsonProperty(value="exp")
    private Integer exp;
    private Map<String, Condition> httpMethodToCondition = null;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    public List<Scope> scopes(String httpMethod) {
        return this.getConditionMap().get(httpMethod).getScopes();
    }

    public Integer getIat() {
        return this.iat;
    }

    public void setIat(Integer iat) {
        this.iat = iat;
    }

    public Integer getExp() {
        return this.exp;
    }

    public void setExp(Integer exp) {
        this.exp = exp;
    }

    public Map<String, Condition> getConditionMap() {
        if (this.httpMethodToCondition == null) {
            this.initMap();
        }
        return this.httpMethodToCondition;
    }

    private void initMap() {
        this.httpMethodToCondition = Maps.newHashMap();
        if (this.conditions != null) {
            for (Condition condition : this.conditions) {
                if (condition.getHttpMethods() == null) continue;
                for (String httpMethod : condition.getHttpMethods()) {
                    this.httpMethodToCondition.put(httpMethod, condition);
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RsResource");
        sb.append("{path='").append(this.path).append('\'');
        sb.append(", conditions=").append(this.conditions);
        sb.append(", httpMethodToCondition=").append(this.httpMethodToCondition);
        sb.append(", iat=").append(this.iat);
        sb.append(", exp=").append(this.exp);
        sb.append('}');
        return sb.toString();
    }
}

