/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.core.test.listener;

import io.jans.configapi.core.test.listener.PersistenceType;
import io.jans.util.security.SecurityProviderUtility;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.testng.IAlterSuiteListener;
import org.testng.xml.XmlSuite;

public class AlterSuiteListener
implements IAlterSuiteListener {
    static PersistenceType persistenceType;
    private static final String FILE_PREFIX = "file:";
    private static final Charset DEFAULT_CHARSET;
    private static final String NEW_LINE;
    private Logger logger = LogManager.getLogger(this.getClass());

    public void alter(List<XmlSuite> suites) {
        try {
            SecurityProviderUtility.installBCProvider();
            this.logger.info("\n\n Parsing XML suite");
            XmlSuite suite = suites.get(0);
            String propertiesFile = suite.getParameter("propertiesFile");
            Properties prop = new Properties();
            prop.load(Files.newBufferedReader(Paths.get(propertiesFile, new String[0]), DEFAULT_CHARSET));
            persistenceType = PersistenceType.fromString(prop.getProperty("persistenceType"));
            this.logger.info("Using persistence type = {}", (Object)persistenceType);
            HashMap parameters = new HashMap();
            prop.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> parameters.put(key.toString(), this.decodeFileValue(value.toString()))));
            suite.setParameters(parameters);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private String decodeFileValue(String value) {
        this.logger.debug("\n\n decodeFileValue");
        String decoded = value;
        if (value.startsWith(FILE_PREFIX)) {
            value = value.substring(FILE_PREFIX.length());
            try (BufferedReader bfr = Files.newBufferedReader(Paths.get(value, new String[0]), DEFAULT_CHARSET);){
                decoded = bfr.lines().reduce("", (partial, next) -> partial + NEW_LINE + next);
                if (decoded.length() == 0) {
                    this.logger.warn("Key '{}' is empty", (Object)value);
                }
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                decoded = null;
            }
        }
        this.logger.debug("\n\n decodeFileValue - decoded:{}", (Object)decoded);
        return decoded;
    }

    static {
        DEFAULT_CHARSET = StandardCharsets.UTF_8;
        NEW_LINE = System.getProperty("line.separator");
    }
}

