/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.core.test;

import io.jans.as.model.common.GrantType;
import io.jans.as.model.util.Util;
import io.jans.configapi.core.test.service.HttpService;
import io.jans.configapi.core.test.service.ResteasyService;
import io.jans.configapi.core.test.service.TokenService;
import jakarta.ws.rs.core.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.testng.ITestContext;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;

public class BaseTest {
    private static final String FILE_PREFIX = "file:";
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final String NEW_LINE = System.getProperty("line.separator");
    protected static final String CONTENT_TYPE = "Content-Type";
    protected static final String AUTHORIZATION = "Authorization";
    protected static final String AUTHORIZATION_TYPE = "Bearer";
    protected Logger log = LogManager.getLogger(this.getClass());
    protected Base64 base64;
    protected static Map<String, String> propertiesMap = null;
    protected ResteasyService resteasyService = new ResteasyService();
    protected HttpService httpService = new HttpService();
    protected TokenService tokenService = new TokenService();
    protected String accessToken;

    @BeforeSuite
    public void initTestSuite(ITestContext context) {
        String propertiesFile = context.getCurrentXmlTest().getParameter("propertiesFile");
        this.log.info("Invoked initTestSuite propertiesFile '{}'", (Object)propertiesFile);
        propertiesMap = context.getSuite().getXmlSuite().getParameters();
        this.log.info("End initTestSuite propertiesMap: {}", propertiesMap);
    }

    @BeforeMethod
    public void getAccessToken() {
        this.log.info("getAccessToken - propertiesMap:{}", propertiesMap);
        String tokenUrl = propertiesMap.get("token.endpoint");
        String strGrantType = propertiesMap.get("token.grant.type");
        String clientId = propertiesMap.get("test.client.id");
        String clientSecret = propertiesMap.get("test.client.secret");
        String scopes = propertiesMap.get("test.scopes");
        GrantType grantType = GrantType.fromString((String)strGrantType);
        this.accessToken = this.getToken(tokenUrl, clientId, clientSecret, grantType, scopes);
        this.log.info("accessToken:{}", (Object)this.accessToken);
    }

    public String getAccessTokenForGivenScope(String scopes) {
        this.log.info("getAccessToken - propertiesMap:{}", propertiesMap);
        String tokenUrl = propertiesMap.get("token.endpoint");
        String strGrantType = propertiesMap.get("token.grant.type");
        String clientId = propertiesMap.get("test.client.id");
        String clientSecret = propertiesMap.get("test.client.secret");
        GrantType grantType = GrantType.fromString((String)strGrantType);
        String token = this.getToken(tokenUrl, clientId, clientSecret, grantType, scopes);
        this.log.info("token:{}", (Object)token);
        return token;
    }

    protected String getToken(String tokenUrl, String clientId, String clientSecret, GrantType grantType, String scopes) {
        return this.getTokenService().getToken(tokenUrl, clientId, clientSecret, grantType, scopes);
    }

    protected String getIssuer() {
        return propertiesMap.get("test.issuer");
    }

    protected HttpService getHttpService() {
        return this.httpService;
    }

    protected ResteasyService getResteasyService() {
        return this.resteasyService;
    }

    protected TokenService getTokenService() {
        return this.tokenService;
    }

    protected String getCredentials(String clientId, String clientSecret) throws UnsupportedEncodingException {
        return URLEncoder.encode(clientId, "UTF-8") + ":" + URLEncoder.encode(clientSecret, "UTF-8");
    }

    protected String getEncodedCredentials() {
        try {
            String clientId = propertiesMap.get("test.client.id");
            String clientSecret = propertiesMap.get("test.client.secret");
            if (StringUtils.isNotBlank((CharSequence)clientId) && StringUtils.isNotBlank((CharSequence)clientSecret)) {
                return Base64.encodeBase64String((byte[])Util.getBytes((String)this.getCredentials(clientId, clientSecret)));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected String decodeFileValue(String value) {
        this.log.info("decodeFileValue");
        String decoded = value;
        if (value.startsWith(FILE_PREFIX)) {
            value = value.substring(FILE_PREFIX.length());
            try (BufferedReader bfr = Files.newBufferedReader(Paths.get(value, new String[0]), DEFAULT_CHARSET);){
                decoded = bfr.lines().reduce("", (partial, next) -> partial + NEW_LINE + next);
                if (decoded.length() == 0) {
                    this.log.warn("Key '{}' is empty", (Object)value);
                }
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                decoded = null;
            }
        }
        this.log.info("decodeFileValue - decoded:{}", (Object)decoded);
        return decoded;
    }

    protected boolean isServiceDeployed(String serviceName) {
        this.log.info("*** Check if  service is deployed - serviceName:{} :{}", (Object)serviceName, (Object)" *** \n\n\n");
        boolean isDeployed = false;
        try {
            Class.forName(serviceName);
            isDeployed = true;
            this.log.info("*** service:{} is deployed", (Object)serviceName);
        }
        catch (ClassNotFoundException ex) {
            this.log.info("*** service:{} is NOT deployed", (Object)serviceName);
            isDeployed = false;
            return isDeployed;
        }
        return isDeployed;
    }

    protected boolean isEndpointAvailable(String url, String accessToken) {
        this.log.info("*** Check if endpoint available - url:{}, accessToken:{}", url, (Object)accessToken);
        boolean isEndpointAvailable = false;
        try {
            url = this.getIssuer() + (String)url;
            Response response = this.getResteasyService().executeGet((String)url, accessToken);
            this.log.error("*** \n\n\n Check endpoint url:{}, response:{} {}", url, (Object)response, (Object)"\n\n\n");
            if (response != null) {
                this.log.error("*** \n\n\n Response for endpoint url:{}, response.getStatus():{} {}", url, (Object)response.getStatus(), (Object)"\n\n\n");
                isEndpointAvailable = response.getStatus() != Response.Status.NOT_FOUND.getStatusCode();
            }
        }
        catch (Exception ex) {
            this.log.info("Endpoint:{} is NOT available", url);
            ex.printStackTrace();
            isEndpointAvailable = false;
            return isEndpointAvailable;
        }
        this.log.info("*** \n\n\n Endpoint:{} available:{} {}", url, (Object)isEndpointAvailable, (Object)"\n\n\n");
        return isEndpointAvailable;
    }

    protected Response executeGet(String url, String clientId, String clientSecret, String authType, String authCode, Map<String, String> parameters, ContentType contentType) {
        this.log.info("Data for executing GET request -  url:{}, clientId:{}, clientSecret:{} , authType:{}, authCode:{} , parameters:{}, contentType:{}", (Object)url, (Object)clientId, (Object)clientSecret, (Object)authType, (Object)authCode, parameters, (Object)contentType);
        return this.getResteasyService().executeGet(url, clientId, clientSecret, authType, authCode, parameters, contentType);
    }
}

