/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.core.util;

import io.jans.as.model.json.JsonApplier;
import io.jans.model.FieldFilterData;
import io.jans.model.FilterOperator;
import io.jans.model.attribute.AttributeDataType;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.exception.MappingException;
import io.jans.orm.reflect.property.Getter;
import io.jans.orm.reflect.property.Setter;
import io.jans.orm.reflect.util.ReflectHelper;
import io.jans.orm.search.filter.Filter;
import io.jans.util.StringHelper;
import io.jans.util.exception.InvalidAttributeException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Named;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Named(value="dataUtil")
public class DataUtil {
    private static final Logger logger = LoggerFactory.getLogger(DataUtil.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String DATE_TIME_FRACTION_OF_SECOND_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";

    public static Class<?> getPropertType(String className, String name) throws MappingException {
        logger.debug("className:{} , name:{} ", (Object)className, (Object)name);
        return ReflectHelper.reflectedPropertyClass((String)className, (String)name);
    }

    public static Getter getGetterMethod(Class<?> clazz, String name) throws MappingException {
        logger.debug("Get Getter fromclazz:{} , name:{} ", clazz, (Object)name);
        return ReflectHelper.getGetter(clazz, (String)name);
    }

    public static Setter getSetterMethod(Class<?> clazz, String name) throws MappingException {
        logger.debug("Get Setter from clazz:{} for name:{} ", clazz, (Object)name);
        return ReflectHelper.getSetter(clazz, (String)name);
    }

    public static Object getValue(Object object, String property) throws MappingException {
        logger.debug("Get value from object:{} for property:{} ", object, (Object)property);
        return ReflectHelper.getValue((Object)object, (String)property);
    }

    public static Method getSetter(String fieldName, Class<?> clazz) throws IntrospectionException {
        PropertyDescriptor[] props;
        for (PropertyDescriptor p : props = Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
            if (!p.getName().equals(fieldName)) continue;
            return p.getWriteMethod();
        }
        return null;
    }

    public static Object invokeMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        logger.debug("Invoke clazz:{} on methodName:{} with name:{} ", new Object[]{clazz, methodName, parameterTypes});
        Method m = clazz.getDeclaredMethod(methodName, parameterTypes);
        Object obj = m.invoke(null, (Object[])parameterTypes);
        logger.debug("methodName:{} returned obj:{} ", (Object)methodName, obj);
        return obj;
    }

    public Object invokeReflectionGetter(Object obj, String variableName) {
        try {
            PropertyDescriptor pd = new PropertyDescriptor(variableName, obj.getClass());
            Method getter = pd.getReadMethod();
            if (getter != null) {
                return getter.invoke(obj, new Object[0]);
            }
            logger.error("Getter Method not found for class:{} property:{}", (Object)obj.getClass().getName(), (Object)variableName);
        }
        catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            logger.error(String.format("Getter Method ERROR for class: %s property: %s", obj.getClass().getName(), variableName), (Throwable)e);
        }
        return null;
    }

    public static void invokeReflectionSetter(Object obj, String propertyName, Object variableValue) {
        try {
            PropertyDescriptor pd = new PropertyDescriptor(propertyName, obj.getClass());
            Method method = pd.getWriteMethod();
            if (method != null) {
                method.invoke(obj, variableValue);
            } else {
                logger.error("Setter Method not found for class:{} property:{}", (Object)obj.getClass().getName(), (Object)propertyName);
            }
        }
        catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            logger.error("Setter Method invocation ERROR for class:{} property:{}", new Object[]{obj.getClass().getName(), propertyName, e});
        }
    }

    public static boolean containsField(List<Field> allFields, String attribute) {
        logger.debug("allFields:{},  attribute:{}, allFields.contains(attribute):{} ", new Object[]{allFields, attribute, allFields.stream().anyMatch(f -> f.getName().equals(attribute))});
        return allFields.stream().anyMatch(f -> f.getName().equals(attribute));
    }

    public boolean isStringField(Map<String, String> objectPropertyMap, String attribute) {
        logger.debug("Check if field is string objectPropertyMap:{}, attribute:{} ", objectPropertyMap, (Object)attribute);
        if (objectPropertyMap == null || StringUtils.isBlank((CharSequence)attribute)) {
            return false;
        }
        logger.debug("attribute:{} , datatype:{}", (Object)attribute, (Object)objectPropertyMap.get(attribute));
        return "java.lang.String".equalsIgnoreCase(objectPropertyMap.get(attribute));
    }

    public static List<Field> getAllFields(Class<?> type) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        DataUtil.getAllFields(allFields, type);
        logger.debug("Fields:{} of type:{}  ", allFields, type);
        return allFields;
    }

    public static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        logger.debug("Getting fields type:{} - fields:{} ", type, fields);
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            DataUtil.getAllFields(fields, type.getSuperclass());
        }
        logger.debug("Final fields:{} of type:{} ", fields, type);
        return fields;
    }

    public static Map<String, String> getFieldTypeMap(Class<?> clazz) {
        logger.debug("clazz:{} ", clazz);
        HashMap<String, String> propertyTypeMap = new HashMap<String, String>();
        if (clazz == null) {
            return propertyTypeMap;
        }
        List<Field> fields = DataUtil.getAllFields(clazz);
        logger.debug("AllFields:{} ", fields);
        for (Field field : fields) {
            logger.debug("field:{} , field.getAnnotatedType():{}, field.getAnnotations():{} , field.getType().getAnnotations():{}, field.getType().getCanonicalName():{} , field.getType().getClass():{} , field.getType().getClasses():{} , field.getType().getComponentType():{}", new Object[]{field, field.getAnnotatedType(), field.getAnnotations(), field.getType().getAnnotations(), field.getType().getCanonicalName(), field.getType().getClass(), field.getType().getClasses(), field.getType().getComponentType()});
            propertyTypeMap.put(field.getName(), field.getType().getSimpleName());
        }
        logger.debug("Final propertyTypeMap{} ", propertyTypeMap);
        return propertyTypeMap;
    }

    public static Object invokeGetterMethod(Object obj, String variableName) {
        return JsonApplier.getInstance().invokeReflectionGetter(obj, variableName);
    }

    public static boolean isKeyPresentInMap(String key, Map<String, String> map) {
        logger.debug("Check key:{} is present in map:{}", (Object)key, map);
        if (StringHelper.isEmpty((String)key) || map == null || map.isEmpty()) {
            return false;
        }
        logger.debug(" key:{} present in map:{} ?:{}", new Object[]{key, map, map.keySet().contains(key)});
        return map.keySet().contains(key);
    }

    public static boolean isAttributeInExclusion(String className, String attribute, Map<String, List<String>> exclusionMap) {
        logger.debug("Check if object:{} attribute:{} is in exclusionMap:{}", new Object[]{className, attribute, exclusionMap});
        if (StringHelper.isEmpty((String)className) || StringHelper.isEmpty((String)attribute) || exclusionMap == null || exclusionMap.isEmpty()) {
            return false;
        }
        logger.debug("Map contains key exclusionMap.keySet().contains(className):{}", (Object)exclusionMap.keySet().contains(className));
        if (exclusionMap.keySet().contains(className)) {
            if (exclusionMap.get(className) != null) {
                return false;
            }
            if (exclusionMap.get(className).contains(attribute)) {
                return true;
            }
        }
        return false;
    }

    public static Map<String, String> getFieldDataType(Class<?> clazz, List<String> fieldList) {
        logger.info("Get FieldDataType - clazz:{}, fieldList:{}", clazz, fieldList);
        Map<String, String> fieldTypeMap = null;
        if (clazz == null || fieldList == null || fieldList.isEmpty()) {
            return fieldTypeMap;
        }
        fieldTypeMap = DataUtil.getFieldTypeMap(clazz);
        if (fieldTypeMap.isEmpty()) {
            return fieldTypeMap;
        }
        fieldTypeMap.keySet().retainAll(fieldList);
        logger.info("Final - fieldList:{} of fieldTypeMap:{}  ", fieldList, fieldTypeMap);
        return fieldTypeMap;
    }

    public static Map<String, String> getFieldType(Class<?> clazz, List<FieldFilterData> fieldFilterData) {
        logger.info("Get field clazz:{}, fieldFilterData:{}", clazz, fieldFilterData);
        Map<String, String> fieldTypeMap = null;
        if (clazz == null || fieldFilterData == null || fieldFilterData.isEmpty()) {
            return fieldTypeMap;
        }
        ArrayList<String> fieldList = new ArrayList<String>();
        for (FieldFilterData entry : fieldFilterData) {
            fieldList.add(entry.getField());
        }
        return DataUtil.getFieldDataType(clazz, fieldList);
    }

    public static Date formatStrDate(String dateString, String datePattern) {
        logger.debug("Format String Date - dateString:{}: datePattern:{}", (Object)dateString, (Object)datePattern);
        Date date = null;
        try {
            if (StringUtils.isBlank((CharSequence)dateString)) {
                return date;
            }
            if (StringUtils.isBlank((CharSequence)datePattern)) {
                datePattern = dateString.contains(":") ? "yyyy-MM-dd HH:mm:ss Z" : DATE_FORMAT;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern);
            logger.debug("datePattern:{}, dateFormat:{} ", (Object)datePattern, (Object)dateFormat);
            date = dateFormat.parse(dateString);
            logger.debug("Returning dateFormat:{}, date:{} ", (Object)dateFormat, (Object)date);
        }
        catch (Exception ex) {
            logger.error("Error while formatting String Date - dateString{" + dateString + "}", (Throwable)ex);
            return date;
        }
        return date;
    }

    public static List<Filter> createFilter(List<FieldFilterData> fieldFilterData, String primaryKey, PersistenceEntryManager persistenceEntryManager) {
        logger.info("Create ORM Filter for fieldFilterData:{}, primaryKey:{}, persistenceEntryManager:{}", new Object[]{fieldFilterData, primaryKey, persistenceEntryManager});
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (fieldFilterData == null || fieldFilterData.isEmpty()) {
            return filters;
        }
        for (FieldFilterData entry : fieldFilterData) {
            logger.info("FieldFilterData entry:{}", (Object)entry);
            String dataType = AttributeDataType.STRING.getValue();
            if (StringUtils.isNotBlank((CharSequence)entry.getType())) {
                dataType = entry.getType();
            }
            logger.info("entry.getField():{}, dataType:{},  AttributeDataType.STRING.getValue():{}, AttributeDataType.STRING.getValue():{}, AttributeDataType.DATE.getDisplayName():{}", new Object[]{entry.getField(), dataType, AttributeDataType.STRING.getValue(), AttributeDataType.STRING.getValue(), AttributeDataType.DATE.getDisplayName()});
            Filter dataFilter = null;
            dataFilter = AttributeDataType.STRING.getValue().equalsIgnoreCase(dataType) ? Filter.createEqualityFilter((String)entry.getField(), (Object)entry.getValue()) : (AttributeDataType.BOOLEAN.getValue().equalsIgnoreCase(dataType) ? Filter.createEqualityFilter((String)entry.getField(), (Object)DataUtil.getBooleanValue(entry.getValue())) : (AttributeDataType.DATE.getDisplayName().equalsIgnoreCase(dataType) ? DataUtil.createDateFilter(entry, primaryKey, persistenceEntryManager) : ("int".equalsIgnoreCase(dataType) || "integer".equalsIgnoreCase(dataType) ? DataUtil.createIntegerFilter(entry) : Filter.createEqualityFilter((String)entry.getField(), (Object)entry.getValue()))));
            filters.add(dataFilter);
            logger.info("dataFilter:{}", (Object)dataFilter);
        }
        logger.info("Final Filters for  fieldFilterData - filters:{}", filters);
        return filters;
    }

    private static boolean getBooleanValue(String strValue) {
        logger.info("Get Boolean Value for strValue:{}", (Object)strValue);
        boolean value = false;
        if (StringUtils.isBlank((CharSequence)strValue) || !strValue.toLowerCase().matches("true|false")) {
            return value;
        }
        return Boolean.parseBoolean(strValue);
    }

    public static String encodeDate(Date date, String primaryKey, PersistenceEntryManager persistenceEntryManager) {
        logger.info("Encode String Date - date:{}, primaryKey:{}, persistenceEntryManager:{}", new Object[]{date, primaryKey, persistenceEntryManager});
        String dateValue = null;
        if (date == null || StringUtils.isBlank((CharSequence)primaryKey) || persistenceEntryManager == null) {
            return dateValue;
        }
        dateValue = persistenceEntryManager.encodeTime(primaryKey, date);
        logger.info(" persistenceEntryManager.decodeTime - date:{}, dateValue:{}", (Object)date, (Object)dateValue);
        return dateValue;
    }

    public static Date decodeStringDate(String dateString, String primaryKey, PersistenceEntryManager persistenceEntryManager) {
        logger.info("Decode String Date - dateString:{}, primaryKey:{}, persistenceEntryManager:{}", new Object[]{dateString, primaryKey, persistenceEntryManager});
        Date dateValue = null;
        if (StringUtils.isBlank((CharSequence)dateString) || StringUtils.isBlank((CharSequence)primaryKey) || persistenceEntryManager == null) {
            return dateValue;
        }
        dateValue = persistenceEntryManager.decodeTime(primaryKey, dateString);
        logger.info(" persistenceEntryManager.decodeTime - dateString:{}, dateValue:{}", (Object)dateString, (Object)dateValue);
        return dateValue;
    }

    private static Filter createDateFilter(FieldFilterData fieldFilterData, String primaryKey, PersistenceEntryManager persistenceEntryManager) {
        logger.info("Create Date Filter for fieldFilterData:{}, primaryKey:{}, persistenceEntryManager:{}", new Object[]{fieldFilterData, primaryKey, persistenceEntryManager});
        Filter dateFilter = null;
        if (fieldFilterData == null) {
            return dateFilter;
        }
        String strDateField = fieldFilterData.getField();
        String strDateValue = fieldFilterData.getValue();
        LocalDateTime dateValue = DataUtil.getIso8601Date(strDateValue, null);
        logger.debug(" strDateField:{}, fieldFilterData.getValue():{}, dateValue:{}", new Object[]{strDateField, fieldFilterData.getValue(), dateValue});
        logger.info(" Create Filter for  strDateField:{}, dateValue:{}", (Object)strDateField, (Object)dateValue);
        if (FilterOperator.EQUALITY.getSign().equalsIgnoreCase(fieldFilterData.getOperator())) {
            if (StringUtils.isNotBlank((CharSequence)strDateValue) && strDateValue.length() == 10) {
                LocalDateTime endOfDay = DataUtil.getEndOfDay(dateValue);
                logger.trace(" Only Date of format YYYY-MM-DD -  strDateField:{}, strDateValue:{}, dateValue:{}, endOfDay:{}", new Object[]{strDateField, strDateValue, dateValue, endOfDay});
                dateFilter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createGreaterOrEqualFilter((String)strDateField, (Object)dateValue), Filter.createLessOrEqualFilter((String)strDateField, (Object)endOfDay)});
            } else {
                logger.trace(" DateTime format strDateField:{}, strDateValue:{}, dateValue:{}", new Object[]{strDateField, strDateValue, dateValue});
                dateFilter = Filter.createEqualityFilter((String)strDateField, (Object)dateValue);
            }
        } else if (FilterOperator.GREATER.getSign().equalsIgnoreCase(fieldFilterData.getOperator()) || FilterOperator.GREATER_OR_EQUAL.getSign().equalsIgnoreCase(fieldFilterData.getOperator())) {
            dateFilter = Filter.createGreaterOrEqualFilter((String)strDateField, (Object)dateValue);
        } else if (FilterOperator.LESS.getSign().equalsIgnoreCase(fieldFilterData.getOperator()) || FilterOperator.LESS_OR_EQUAL.getSign().equalsIgnoreCase(fieldFilterData.getOperator())) {
            dateFilter = Filter.createLessOrEqualFilter((String)strDateField, (Object)dateValue);
        }
        logger.info("Final Date Filter for fieldFilterData:{}, dateFilter:{}", (Object)fieldFilterData, (Object)dateFilter);
        return dateFilter;
    }

    private static Filter createIntegerFilter(FieldFilterData fieldFilterData) {
        logger.info("Create Integer Filter for fieldFilterData:{}", (Object)fieldFilterData);
        Filter dataFilter = null;
        if (fieldFilterData == null) {
            return dataFilter;
        }
        String dataValue = fieldFilterData.getValue();
        Integer intValue = null;
        if (StringUtils.isNotBlank((CharSequence)fieldFilterData.getValue())) {
            try {
                intValue = Integer.parseInt(fieldFilterData.getValue());
            }
            catch (Exception ex) {
                logger.info("Though Data type is numeric but value is not numeric{" + fieldFilterData.getValue() + "}", (Throwable)ex);
            }
        }
        logger.info("Create Integer Filter for intValue:{}", intValue);
        if (FilterOperator.EQUALITY.getSign().equalsIgnoreCase(fieldFilterData.getOperator())) {
            dataFilter = Filter.createEqualityFilter((String)fieldFilterData.getField(), (Object)dataValue);
        } else if (FilterOperator.GREATER.getSign().equalsIgnoreCase(fieldFilterData.getOperator()) || FilterOperator.GREATER_OR_EQUAL.getSign().equalsIgnoreCase(fieldFilterData.getOperator())) {
            dataFilter = Filter.createGreaterOrEqualFilter((String)fieldFilterData.getField(), (Object)dataValue);
        } else if (FilterOperator.LESS.getSign().equalsIgnoreCase(fieldFilterData.getOperator()) || FilterOperator.GREATER_OR_EQUAL.getSign().equalsIgnoreCase(fieldFilterData.getOperator())) {
            dataFilter = Filter.createLessOrEqualFilter((String)fieldFilterData.getField(), (Object)dataValue);
        }
        logger.info("Final Date Filter for fieldFilterData:{}, dataValue:{}", (Object)fieldFilterData, (Object)dataValue);
        return dataFilter;
    }

    public static LocalDateTime getIso8601Date(String dateString, String pattern) {
        logger.info(" getIso8601Date for dateString:{}, pattern:{}", (Object)dateString, (Object)pattern);
        String formatPattern = null;
        DateTimeFormatter formatter = null;
        LocalDateTime localDateTime = null;
        try {
            if (StringUtils.isBlank((CharSequence)pattern)) {
                formatPattern = DataUtil.getDateFormatPattern(dateString);
            }
            logger.info("getIso8601Date for dateString:{}, formatPattern:{}", (Object)dateString, (Object)formatPattern);
            if (StringUtils.isBlank((CharSequence)formatPattern)) {
                throw new InvalidAttributeException("Date Format incorrect - Please use {'yyyy-MM-dd','yyyy-MM-dd HH:mm:ss','yyyy-MM-dd HH:mm:ss.SSS'}");
            }
            formatter = DateTimeFormatter.ofPattern(formatPattern);
            if (formatter != null && DATE_FORMAT.equalsIgnoreCase(formatPattern)) {
                LocalDate localDate = LocalDate.parse(dateString, formatter);
                logger.debug("Only DateFormat for localDate:{}, formatter:{}", (Object)localDate, (Object)formatter);
                localDateTime = LocalDateTime.of(localDate.getYear(), localDate.getMonth(), localDate.getDayOfMonth(), 0, 0, 0);
            } else {
                logger.debug("DateTime format for dateString:{}, formatter:{}", (Object)dateString, (Object)formatter);
                localDateTime = LocalDateTime.parse(dateString, formatter);
            }
            logger.info("getIso8601Date for dateString:{}, formatter:{}", (Object)dateString, (Object)formatter);
        }
        catch (Exception ex) {
            logger.error(" Error while parsing dateString:{}, format:{}", new Object[]{dateString, formatter, ex});
        }
        return localDateTime;
    }

    private static LocalDateTime getEndOfDay(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return localDateTime;
        }
        return localDateTime.toLocalDate().atTime(LocalTime.MAX);
    }

    private static String getDateFormatPattern(String dateString) {
        logger.info("Get Date Format for dateString:{}", (Object)dateString);
        String formatPattern = null;
        if (StringUtils.isBlank((CharSequence)dateString)) {
            return formatPattern;
        }
        logger.info("Get Date Format for dateString:{}, dateString.length():{}, dateString.contains(T):{}, dateString.contains(Z):{}", new Object[]{dateString, dateString.length(), dateString.contains("T"), dateString.contains("Z")});
        if (dateString.contains("T") && dateString.indexOf("Z") <= 0) {
            if (dateString.length() == 19) {
                formatPattern = "yyyy-MM-dd'T'HH:mm:ss";
            } else if (dateString.length() == 23) {
                formatPattern = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            } else if (dateString.length() > 23) {
                formatPattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
            }
        } else if (dateString.contains("T") && dateString.contains("Z")) {
            formatPattern = dateString.length() == 20 ? "yyyy-MM-dd'T'HH:mm:ssZ" : "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
        } else if (dateString.length() == 10) {
            formatPattern = DATE_FORMAT;
        } else if (dateString.length() == 19) {
            formatPattern = DATE_TIME_FORMAT;
        } else if (dateString.length() == 23) {
            formatPattern = DATE_TIME_FRACTION_OF_SECOND_FORMAT;
        }
        logger.info("Final Date Format for dateString:{}, formatPattern:{}", (Object)dateString, (Object)formatPattern);
        return formatPattern;
    }
}

