/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.core.model;

import io.jans.orm.annotation.AttributeEnum;
import java.util.HashMap;
import java.util.Map;

public enum ValidationStatus implements AttributeEnum
{
    PENDING("In Progress", "In Progress"),
    SUCCESS("Success", "Success"),
    SCHEDULED("Scheduled", "Scheduled"),
    FAILED("Failed", "Failed");

    private String value;
    private String displayName;
    private static Map<String, ValidationStatus> mapByValues;

    private ValidationStatus(String value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static ValidationStatus getByValue(String value) {
        return mapByValues.get(value);
    }

    public Enum<? extends AttributeEnum> resolveByValue(String value) {
        return ValidationStatus.getByValue(value);
    }

    public String toString() {
        return this.value;
    }

    static {
        mapByValues = new HashMap<String, ValidationStatus>();
        for (ValidationStatus enumType : ValidationStatus.values()) {
            mapByValues.put(enumType.getValue(), enumType);
        }
    }
}

