/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.core.rest;

import io.jans.configapi.core.interceptor.RequestAuditInterceptor;
import io.jans.configapi.core.interceptor.RequestInterceptor;
import io.jans.configapi.core.model.ApiError;
import io.jans.configapi.core.util.Util;
import io.jans.model.FilterOperator;
import io.jans.model.SearchRequest;
import io.jans.orm.model.SortOrder;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestAuditInterceptor
@RequestInterceptor
public class BaseResource {
    @Inject
    Util util;
    @Context
    UriInfo uriInfo;
    @Context
    private HttpServletRequest httpRequest;
    @Context
    private HttpHeaders httpHeaders;
    private static Logger log = LoggerFactory.getLogger(BaseResource.class);
    private static final String MISSING_ATTRIBUTE_CODE = "OCA001";
    private static final String MISSING_ATTRIBUTE_MESSAGE = "A required attribute is missing.";
    private static final String TOKEN_DELIMITER = ",";
    private static final String FIELD_VALUE_SEPARATOR = "=";
    private static final List<String> FIELD_VALUE_SEPARATOR_ARR = FilterOperator.getAllOperatorSign();

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public HttpServletRequest getHttpRequest() {
        return this.httpRequest;
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public static <T> void checkResourceNotNull(T resource, String objectName) {
        if (resource == null) {
            throw new NotFoundException(BaseResource.getNotFoundError(objectName));
        }
    }

    public static void checkNotNull(String attribute, String attributeName) {
        if (StringUtils.isBlank((CharSequence)attribute)) {
            throw new BadRequestException(BaseResource.getMissingAttributeError(attributeName));
        }
    }

    public static void checkNotNull(String[] attributes, String attributeName) {
        if (attributes == null || attributes.length <= 0) {
            throw new BadRequestException(BaseResource.getMissingAttributeError(attributeName));
        }
    }

    public static void checkNotNull(Map<String, String> attributeMap) {
        if (attributeMap.isEmpty()) {
            return;
        }
        Map<String, String> map = attributeMap.entrySet().stream().filter(k -> k.getValue() == null || StringUtils.isNotEmpty((CharSequence)((CharSequence)k.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        log.debug(" map:{}", map);
        if (!map.isEmpty()) {
            throw new BadRequestException(BaseResource.getMissingAttributeError(map.keySet().toString()));
        }
    }

    public static void throwMissingAttributeError(String attributeName) {
        if (StringUtils.isNotEmpty((CharSequence)attributeName)) {
            throw new BadRequestException(BaseResource.getMissingAttributeError(attributeName));
        }
    }

    public static <T> void checkNotEmpty(List<T> list, String attributeName) {
        if (list == null || list.isEmpty()) {
            throw new BadRequestException(BaseResource.getMissingAttributeError(attributeName));
        }
    }

    public static void checkNotEmpty(String attribute, String attributeName) {
        if (StringUtils.isEmpty((CharSequence)attribute)) {
            throw new BadRequestException(BaseResource.getMissingAttributeError(attributeName));
        }
    }

    public static void throwBadRequestException(String msg) {
        throw new BadRequestException(BaseResource.getBadRequestException(msg));
    }

    public static void throwBadRequestException(String msg, String description) {
        throw new BadRequestException(BaseResource.getBadRequestException(msg, description));
    }

    public static void throwBadRequestException(Object obj) {
        throw new BadRequestException(BaseResource.getBadRequestException(obj));
    }

    public static void throwInternalServerException(String msg) {
        throw new InternalServerErrorException(BaseResource.getInternalServerException(msg));
    }

    public static void throwInternalServerException(String msg, String description) {
        throw new InternalServerErrorException(BaseResource.getInternalServerException(msg, description));
    }

    public static void throwInternalServerException(String msg, Throwable throwable) {
        if ((throwable = BaseResource.findRootError(throwable)) != null) {
            throw new InternalServerErrorException(BaseResource.getInternalServerException(msg, throwable.getMessage()));
        }
    }

    public static void throwInternalServerException(Throwable throwable) {
        if ((throwable = BaseResource.findRootError(throwable)) != null) {
            throw new InternalServerErrorException(BaseResource.getInternalServerException(throwable.getMessage()));
        }
    }

    public static void throwNotFoundException(String msg) {
        throw new NotFoundException(BaseResource.getNotFoundError(msg));
    }

    public static void throwNotFoundException(String msg, String description) {
        throw new NotFoundException(BaseResource.getNotFoundError(msg, description));
    }

    protected static Response getMissingAttributeError(String attributeName) {
        ApiError error = new ApiError.ErrorBuilder().withCode(MISSING_ATTRIBUTE_CODE).withMessage(MISSING_ATTRIBUTE_MESSAGE).andDescription("The attribute " + attributeName + " is required for this operation").build();
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build();
    }

    protected static Response getNotFoundError(String objectName) {
        ApiError error = new ApiError.ErrorBuilder().withCode(String.valueOf(Response.Status.NOT_FOUND.getStatusCode())).withMessage("The requested " + objectName + " doesn't exist").build();
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build();
    }

    protected static Response getNotFoundError(String msg, String description) {
        ApiError error = new ApiError.ErrorBuilder().withCode(String.valueOf(Response.Status.NOT_FOUND.getStatusCode())).withMessage(msg).andDescription(description).build();
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build();
    }

    protected static Response getNotAcceptableException(String msg) {
        ApiError error = new ApiError.ErrorBuilder().withCode(String.valueOf(Response.Status.NOT_ACCEPTABLE.getStatusCode())).withMessage(msg).build();
        return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)error).build();
    }

    protected static Response getBadRequestException(String msg) {
        ApiError error = new ApiError.ErrorBuilder().withCode(String.valueOf(Response.Status.BAD_REQUEST.getStatusCode())).withMessage(msg).build();
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build();
    }

    protected static Response getBadRequestException(String msg, String description) {
        ApiError error = new ApiError.ErrorBuilder().withCode(String.valueOf(Response.Status.BAD_REQUEST.getStatusCode())).withMessage(msg).andDescription(description).build();
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build();
    }

    protected static Response getBadRequestException(Object obj) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(obj).build();
    }

    protected static Response getInternalServerException(String msg) {
        ApiError error = new ApiError.ErrorBuilder().withCode(String.valueOf(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode())).withMessage(msg).build();
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build();
    }

    protected static Response getInternalServerException(String msg, String description) {
        ApiError error = new ApiError.ErrorBuilder().withCode(String.valueOf(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode())).withMessage(msg).andDescription(description).build();
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build();
    }

    protected SearchRequest createSearchRequest(String schemas, String filter, String sortBy, String sortOrder, Integer startIndex, Integer count, String attrsList, String excludedAttrsList, int maximumRecCount, String fieldValuePair, Class<?> entityClass) {
        if (log.isDebugEnabled()) {
            log.debug("Search Request params:: - schemas:{}, filter:{}, sortBy:{}, sortOrder:{}, startIndex:{}, count:{}, attrsList:{}, excludedAttrsList:{}, maximumRecCount:{}, fieldValuePair:{}, entityClass:{}", new Object[]{io.jans.as.model.util.Util.escapeLog((Object)schemas), io.jans.as.model.util.Util.escapeLog((Object)filter), io.jans.as.model.util.Util.escapeLog((Object)sortBy), io.jans.as.model.util.Util.escapeLog((Object)sortOrder), io.jans.as.model.util.Util.escapeLog((Object)startIndex), io.jans.as.model.util.Util.escapeLog((Object)count), io.jans.as.model.util.Util.escapeLog((Object)attrsList), io.jans.as.model.util.Util.escapeLog((Object)excludedAttrsList), io.jans.as.model.util.Util.escapeLog((Object)maximumRecCount), io.jans.as.model.util.Util.escapeLog((Object)fieldValuePair), io.jans.as.model.util.Util.escapeLog(entityClass)});
        }
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setEntityClass(entityClass);
        BaseResource.checkNotEmpty(schemas, "Schema");
        int maxCount = maximumRecCount;
        log.trace(" count:{}, maxCount:{}", (Object)count, (Object)maxCount);
        if (count > maxCount) {
            BaseResource.throwBadRequestException("Maximum number of results per page is " + maxCount);
        }
        count = count == null ? maxCount : count;
        log.trace(" count:{} ", (Object)count);
        if (count < 0) {
            count = 0;
        }
        if (StringUtils.isEmpty((CharSequence)sortOrder) || !sortOrder.equals(SortOrder.DESCENDING.getValue())) {
            sortOrder = SortOrder.ASCENDING.getValue();
        }
        log.debug(" util.getTokens(filter,TOKEN_DELIMITER):{} , util.getFieldValueMap(searchRequest, fieldValuePair, TOKEN_DELIMITER, FIELD_VALUE_SEPARATOR)):{}, FIELD_VALUE_SEPARATOR_ARR:{}", new Object[]{this.util.getTokens(filter, TOKEN_DELIMITER), this.util.getFieldValueMap(entityClass, fieldValuePair, TOKEN_DELIMITER, FIELD_VALUE_SEPARATOR), FIELD_VALUE_SEPARATOR_ARR});
        searchRequest.setSchemas(schemas);
        searchRequest.setAttributes(attrsList);
        searchRequest.setExcludedAttributes(excludedAttrsList);
        searchRequest.setFilter(filter);
        searchRequest.setSortBy(sortBy);
        searchRequest.setSortOrder(sortOrder);
        searchRequest.setStartIndex(startIndex);
        searchRequest.setCount(count);
        searchRequest.setMaxCount(maximumRecCount);
        searchRequest.setFilterAssertionValue(this.util.getTokens(filter, TOKEN_DELIMITER));
        searchRequest.setFieldValueMap(this.util.getFieldValueMap(entityClass, fieldValuePair, TOKEN_DELIMITER, FIELD_VALUE_SEPARATOR));
        searchRequest.setFieldFilterData(this.util.getFieldValueList(entityClass, fieldValuePair, TOKEN_DELIMITER, FIELD_VALUE_SEPARATOR_ARR));
        return searchRequest;
    }

    public static Throwable findRootError(Throwable throwable) {
        Throwable rootCause;
        if (throwable == null) {
            return throwable;
        }
        for (rootCause = throwable; rootCause.getCause() != null && rootCause.getCause() != rootCause; rootCause = rootCause.getCause()) {
        }
        return rootCause;
    }
}

