/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.core.service;

import io.jans.as.common.model.registration.Client;
import io.jans.orm.PersistenceEntryManager;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import org.slf4j.Logger;

@ApplicationScoped
@Named(value="cltSrv")
public class ClientService
implements Serializable {
    private static final long serialVersionUID = 7912416439116338984L;
    @Inject
    private transient PersistenceEntryManager persistenceEntryManager;
    @Inject
    private transient Logger logger;

    public boolean contains(String clientDn) {
        return this.persistenceEntryManager.contains(clientDn, Client.class);
    }

    public Client getClientByInum(String inum) {
        Client result = null;
        try {
            result = (Client)this.persistenceEntryManager.find(Client.class, (Object)this.getDnForClient(inum));
        }
        catch (Exception ex) {
            this.logger.error("Failed to load client entry", (Throwable)ex);
        }
        return result;
    }

    public Client getClientByDn(String dn) {
        try {
            return (Client)this.persistenceEntryManager.find(Client.class, (Object)dn);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    public String getDnForClient(String inum) {
        String orgDn = this.getDnForOrganization(null);
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=clients,%s", orgDn);
        }
        return String.format("inum=%s,ou=clients,%s", inum, orgDn);
    }

    public String getDnForOrganization(String baseDn) {
        if (baseDn == null) {
            baseDn = "o=jans";
        }
        return baseDn;
    }
}

