/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.core.test.listener;

import com.google.common.base.Throwables;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.Reporter;

public class ApiUnitTestListener
implements ITestListener {
    public void onTestStart(ITestResult result) {
        Reporter.log((String)("Test STARTED: " + this.getTestInfo(result)), (boolean)true);
    }

    public void onTestSuccess(ITestResult result) {
        Reporter.log((String)("Test SUCCESS: " + this.getTestInfo(result)), (boolean)true);
        Reporter.log((String)"", (boolean)true);
    }

    public void onTestFailure(ITestResult result) {
        Reporter.log((String)("Test FAILED: " + this.getTestInfo(result)), (boolean)true);
        this.testFailed(result);
    }

    public void onTestSkipped(ITestResult result) {
        Reporter.log((String)("Test SKIPPED: " + this.getTestInfo(result)), (boolean)true);
        Reporter.log((String)"", (boolean)true);
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        Reporter.log((String)("Test FAILED with Success Percentage: " + this.getTestInfo(result)), (boolean)true);
        this.testFailed(result);
    }

    public void onStart(ITestContext context) {
        Reporter.log((String)"Test onStart ", (boolean)true);
    }

    public void onFinish(ITestContext context) {
        Reporter.log((String)"Test onFinish ", (boolean)true);
    }

    private void testFailed(ITestResult result) {
        Throwable throwable;
        Object[] parameters = result.getParameters();
        if (parameters != null) {
            Reporter.log((String)"Test Parameters: ", (boolean)true);
            for (Object parameter : parameters) {
                Reporter.log((String)("parameter = " + parameter), (boolean)true);
            }
        }
        if ((throwable = result.getThrowable()) != null) {
            Reporter.log((String)"", (boolean)true);
            Reporter.log((String)"Exception: ", (boolean)true);
            Reporter.log((String)Throwables.getStackTraceAsString((Throwable)result.getThrowable()), (boolean)true);
            Reporter.log((String)"", (boolean)true);
        }
    }

    private String getTestInfo(ITestResult result) {
        return result.getInstanceName() + "." + result.getName();
    }
}

