/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.core.test.listener;

import io.jans.configapi.core.test.listener.AlterSuiteListener;
import io.jans.configapi.core.test.listener.PersistenceType;
import io.jans.configapi.core.test.listener.SkipTest;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.testng.IAnnotationTransformer;
import org.testng.annotations.ITestAnnotation;

public class SkipTestsListener
implements IAnnotationTransformer {
    private Logger logger = LogManager.getLogger(this.getClass());

    public void transform(ITestAnnotation annotation, Class testClass, Constructor testConstructor, Method testMethod) {
        if (testMethod != null) {
            SkipTest skipper = testMethod.getAnnotation(SkipTest.class);
            if (skipper == null) {
                skipper = testMethod.getDeclaringClass().getAnnotation(SkipTest.class);
            }
            if (skipper != null) {
                boolean disable = Stream.of(skipper.databases()).map(PersistenceType::fromString).anyMatch(AlterSuiteListener.persistenceType::equals);
                if (disable) {
                    this.logger.warn("Disabling test method {}", (Object)testMethod.getName());
                    annotation.setEnabled(false);
                }
            }
        }
    }
}

