/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.core.test.service;

import io.jans.model.net.HttpServiceResponse;
import io.jans.util.StringHelper;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpService
implements Serializable {
    private static final long serialVersionUID = -2398422090669045605L;
    protected transient Logger log = LogManager.getLogger(this.getClass());
    private static final String CON_STATS_STR = "Connection manager stats: {}";
    private transient Base64 base64;
    private transient PoolingHttpClientConnectionManager connectionManager;

    @PostConstruct
    public void init() {
        this.connectionManager = new PoolingHttpClientConnectionManager();
        this.connectionManager.setMaxTotal(200);
        this.connectionManager.setDefaultMaxPerRoute(50);
        this.base64 = new Base64();
    }

    public CloseableHttpClient getHttpsClientTrustAll() throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        this.log.trace(CON_STATS_STR, (Object)this.connectionManager.getTotalStats());
        TrustStrategy acceptingTrustStrategy = (cert, authType) -> true;
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, acceptingTrustStrategy).build();
        SSLConnectionSocketFactory sslConSocFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConSocFactory).setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).setConnectionManager((HttpClientConnectionManager)this.connectionManager).build();
    }

    public CloseableHttpClient getHttpsClient() {
        return this.getHttpsClient(RequestConfig.custom().build());
    }

    public CloseableHttpClient getHttpsClient(RequestConfig requestConfig) {
        this.log.trace(CON_STATS_STR, (Object)this.connectionManager.getTotalStats());
        return HttpClients.custom().setDefaultRequestConfig(RequestConfig.copy((RequestConfig)requestConfig).setCookieSpec("standard").build()).setConnectionManager((HttpClientConnectionManager)this.connectionManager).build();
    }

    public CloseableHttpClient getHttpsClient(HttpRoutePlanner routerPlanner) {
        this.log.trace(CON_STATS_STR, (Object)this.connectionManager.getTotalStats());
        return this.getHttpsClient(RequestConfig.custom().build(), routerPlanner);
    }

    public CloseableHttpClient getHttpsClient(RequestConfig requestConfig, HttpRoutePlanner routerPlanner) {
        this.log.trace(CON_STATS_STR, (Object)this.connectionManager.getTotalStats());
        return HttpClients.custom().setDefaultRequestConfig(RequestConfig.copy((RequestConfig)requestConfig).setCookieSpec("standard").build()).setConnectionManager((HttpClientConnectionManager)this.connectionManager).setRoutePlanner(routerPlanner).build();
    }

    public CloseableHttpClient getHttpsClient(String trustStorePath, String trustStorePassword) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        this.log.trace(CON_STATS_STR, (Object)this.connectionManager.getTotalStats());
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(new File(trustStorePath), trustStorePassword.toCharArray()).build();
        SSLConnectionSocketFactory sslConSocFactory = new SSLConnectionSocketFactory(sslContext);
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConSocFactory).setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).setConnectionManager((HttpClientConnectionManager)this.connectionManager).build();
    }

    public CloseableHttpClient getHttpsClient(String trustStorePath, String trustStorePassword, String keyStorePath, String keyStorePassword) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, UnrecoverableKeyException {
        this.log.trace(CON_STATS_STR, (Object)this.connectionManager.getTotalStats());
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(new File(trustStorePath), trustStorePassword.toCharArray()).loadKeyMaterial(new File(keyStorePath), keyStorePassword.toCharArray(), keyStorePassword.toCharArray()).build();
        SSLConnectionSocketFactory sslConSocFactory = new SSLConnectionSocketFactory(sslContext);
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConSocFactory).setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).setConnectionManager((HttpClientConnectionManager)this.connectionManager).build();
    }

    public HttpServiceResponse executePost(HttpClient httpClient, String uri, String authCode, Map<String, String> headers, String postData, ContentType contentType, String authType) {
        HttpPost httpPost = new HttpPost(uri);
        authType = StringHelper.isEmpty((String)authType) ? "Basic " : (String)authType + " ";
        if (StringHelper.isNotEmpty((String)authCode)) {
            httpPost.setHeader("Authorization", (String)authType + authCode);
        }
        if (contentType == null) {
            contentType = ContentType.APPLICATION_JSON;
        }
        if (headers != null) {
            for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
                httpPost.setHeader(headerEntry.getKey(), headerEntry.getValue());
            }
        }
        StringEntity stringEntity = new StringEntity(postData, contentType);
        httpPost.setEntity((HttpEntity)stringEntity);
        try {
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            return new HttpServiceResponse((HttpRequestBase)httpPost, httpResponse);
        }
        catch (IOException ex) {
            this.log.error("Failed to execute post request", (Throwable)ex);
            return null;
        }
    }

    public HttpServiceResponse executePost(HttpClient httpClient, String uri, String authCode, Map<String, String> headers, String postData) {
        return this.executePost(httpClient, uri, authCode, headers, postData, null, null);
    }

    public HttpServiceResponse executePost(HttpClient httpClient, String uri, String authCode, String postData, ContentType contentType) {
        return this.executePost(httpClient, uri, authCode, null, postData, contentType, null);
    }

    public HttpServiceResponse executePost(String uri, String authCode, String postData, ContentType contentType, String authType) {
        return this.executePost((HttpClient)this.getHttpsClient(), uri, authCode, null, postData, contentType, authType);
    }

    public String encodeBase64(String value) {
        return new String(this.base64.encode(value.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public String encodeUrl(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    public HttpServiceResponse executeGet(HttpClient httpClient, String requestUri, Map<String, String> headers, Map<String, String> parameters) {
        HttpGet httpGet = new HttpGet(requestUri);
        if (headers != null) {
            for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
                httpGet.setHeader(headerEntry.getKey(), headerEntry.getValue());
            }
        }
        if (parameters != null && !parameters.isEmpty()) {
            StringBuilder query = new StringBuilder("");
            for (String key : parameters.keySet()) {
                String value = parameters.get(key);
                if (value == null || value.length() <= 0) continue;
                String delim = "&" + URLEncoder.encode(key, StandardCharsets.UTF_8) + "=";
                query.append(delim.substring(1));
                query.append(URLEncoder.encode(value, StandardCharsets.UTF_8));
            }
            httpGet = new HttpGet(requestUri + query.toString());
        }
        try {
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            return new HttpServiceResponse((HttpRequestBase)httpGet, httpResponse);
        }
        catch (IOException ex) {
            this.log.error("Failed to execute get request", (Throwable)ex);
            return null;
        }
    }

    public HttpServiceResponse executeGet(String requestUri, Map<String, String> headers, Map<String, String> data) {
        CloseableHttpClient httpClient = this.getHttpsClient();
        return this.executeGet((HttpClient)httpClient, requestUri, headers, data);
    }

    public HttpServiceResponse executeGet(String requestUri, Map<String, String> headers) {
        CloseableHttpClient httpClient = this.getHttpsClient();
        return this.executeGet((HttpClient)httpClient, requestUri, headers, null);
    }

    public HttpServiceResponse executeGet(HttpClient httpClient, String requestUri) {
        return this.executeGet(httpClient, requestUri, null, null);
    }

    public byte[] getResponseContent(HttpResponse httpResponse) throws IOException {
        if (httpResponse == null || !this.isResponseStastusCodeOk(httpResponse)) {
            return null;
        }
        HttpEntity entity = httpResponse.getEntity();
        byte[] responseBytes = new byte[]{};
        if (entity != null) {
            responseBytes = EntityUtils.toByteArray((HttpEntity)entity);
        }
        if (entity != null) {
            EntityUtils.consume((HttpEntity)entity);
        }
        return responseBytes;
    }

    public void consume(HttpResponse httpResponse) throws IOException {
        if (httpResponse == null || !this.isResponseStastusCodeOk(httpResponse)) {
            return;
        }
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            EntityUtils.consume((HttpEntity)entity);
        }
    }

    public String convertEntityToString(byte[] responseBytes) {
        if (responseBytes == null) {
            return null;
        }
        return new String(responseBytes);
    }

    public String convertEntityToString(byte[] responseBytes, Charset charset) {
        if (responseBytes == null) {
            return null;
        }
        return new String(responseBytes, charset);
    }

    public String convertEntityToString(byte[] responseBytes, String charsetName) throws UnsupportedEncodingException {
        if (responseBytes == null) {
            return null;
        }
        return new String(responseBytes, charsetName);
    }

    public boolean isResponseStastusCodeOk(HttpResponse httpResponse) {
        int responseStastusCode = httpResponse.getStatusLine().getStatusCode();
        return responseStastusCode == 200 || responseStastusCode == 201 || responseStastusCode == 202 || responseStastusCode == 203 || responseStastusCode == 204 || responseStastusCode == 205 || responseStastusCode == 206 || responseStastusCode == 207;
    }

    public boolean isResponseStatusCodeOk(HttpResponse httpResponse) {
        return this.isResponseStastusCodeOk(httpResponse);
    }

    public boolean isContentTypeXml(HttpResponse httpResponse) {
        Header contentType = httpResponse.getEntity().getContentType();
        if (contentType == null) {
            return false;
        }
        String contentTypeValue = contentType.getValue();
        return StringHelper.equals((String)contentTypeValue, (String)ContentType.APPLICATION_XML.getMimeType()) || StringHelper.equals((String)contentTypeValue, (String)ContentType.TEXT_XML.getMimeType());
    }

    public String constructServerUrl(HttpServletRequest request) {
        int serverPort = request.getServerPort();
        String redirectUrl = serverPort == 80 || serverPort == 443 ? String.format("%s://%s%s", request.getScheme(), request.getServerName(), request.getContextPath()) : String.format("%s://%s:%s%s", request.getScheme(), request.getServerName(), request.getServerPort(), request.getContextPath());
        return redirectUrl.toLowerCase();
    }

    public HttpRoutePlanner buildDefaultRoutePlanner(String hostname, int port, String scheme) {
        HttpHost proxyHost = new HttpHost(hostname, port, scheme);
        return new DefaultProxyRoutePlanner(proxyHost);
    }

    public HttpRoutePlanner buildDefaultRoutePlanner(String proxy) {
        return this.buildDefaultRoutePlanner(proxy, -1, null);
    }
}

