/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.core.test.service;

import io.jans.util.StringHelper;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResteasyService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String AUTHORIZATION = "Authorization";
    protected transient Logger logger = LogManager.getLogger(this.getClass());

    public Invocation.Builder getClientBuilder(String url) {
        return ClientBuilder.newClient().target(url).request();
    }

    public Response executeGet(String url, Map<String, String> headers, Map<String, String> parameters) {
        this.logger.error("\n\n\n *** Execut GET - url:{}, headers:{}, parameters:{}", (Object)url, headers, parameters);
        StringBuilder query = null;
        if (parameters != null && !parameters.isEmpty()) {
            query = new StringBuilder("");
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                String string = (String)entry.getValue();
                if (string == null || string.length() <= 0) continue;
                String delim = "&" + URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8) + "=";
                query.append(delim.substring(1));
                query.append(URLEncoder.encode(string, StandardCharsets.UTF_8));
            }
        }
        Invocation.Builder request = this.getClientBuilder(url + query);
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry entry : headers.entrySet()) {
                request.header((String)entry.getKey(), entry.getValue());
            }
        }
        Response response = request.get();
        this.logger.error(" response:{}", (Object)response);
        return response;
    }

    public Response executeGet(String url, String accessToken) {
        this.logger.error("\n\n\n *** Execut GET - url:{}, accessToken:{}", (Object)url, (Object)accessToken);
        Invocation.Builder request = this.getClientBuilder(url);
        if (StringUtils.isNotBlank((CharSequence)accessToken)) {
            request.header(AUTHORIZATION, (Object)("Bearer " + accessToken));
        }
        Response response = request.get();
        this.logger.error("\n\n\n response:{}", (Object)response);
        return response;
    }

    public Response executeGet(String url, String clientId, String clientSecret, String authType, String authCode, Map<String, String> parameters, ContentType contentType) {
        this.logger.info("Data for executing GET request -  url:{}, clientId:{}, clientSecret:{} , authType:{}, authCode:{} , parameters:{}, contentType:{}", (Object)url, (Object)clientId, (Object)clientSecret, (Object)authType, (Object)authCode, parameters, (Object)contentType);
        StringBuilder query = null;
        if (parameters != null && !parameters.isEmpty()) {
            query = new StringBuilder("");
            int i = 0;
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (value == null || value.length() <= 0) continue;
                String delim = i == 0 ? "?" : "&";
                query.append(delim + URLEncoder.encode(key, StandardCharsets.UTF_8) + "=");
                query.append(URLEncoder.encode(value, StandardCharsets.UTF_8));
                ++i;
            }
        }
        Invocation.Builder request = this.getClientBuilder(url + query);
        if (contentType == null) {
            contentType = ContentType.APPLICATION_JSON;
        }
        request.header(CONTENT_TYPE, (Object)contentType);
        if (StringHelper.isNotEmpty((String)authCode)) {
            request.header(AUTHORIZATION, (Object)(authType + authCode));
        }
        Response response = request.get();
        this.logger.info(" response:{}", (Object)response);
        return response;
    }
}

