/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.core.test.service;

import io.jans.as.client.TokenRequest;
import io.jans.as.client.TokenResponse;
import io.jans.as.model.common.GrantType;
import io.jans.configapi.core.test.service.ResteasyService;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TokenService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Logger log = LogManager.getLogger(this.getClass());
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String AUTHORIZATION = "Authorization";

    public String getToken(String tokenUrl, String clientId, String clientSecret, GrantType grantType, String scopes) {
        this.log.info("Request for token tokenUrl:{}, clientId:{}, grantType:{}, scopes:{}", (Object)tokenUrl, (Object)clientId, (Object)grantType, (Object)scopes);
        String accessToken = null;
        TokenResponse tokenResponse = this.requestAccessToken(tokenUrl, clientId, clientSecret, grantType, scopes);
        if (tokenResponse != null) {
            accessToken = tokenResponse.getAccessToken();
            this.log.trace("accessToken:{}, ", (Object)accessToken);
        }
        return accessToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenResponse requestAccessToken(String tokenUrl, String clientId, String clientSecret, GrantType grantType, String scope) {
        this.log.info("Request for access token tokenUrl:{}, clientId:{},scope:{}", (Object)tokenUrl, (Object)clientId, (Object)scope);
        try (Response response = null;){
            if (grantType == null) {
                grantType = GrantType.CLIENT_CREDENTIALS;
            }
            TokenRequest tokenRequest = new TokenRequest(grantType);
            tokenRequest.setScope(scope);
            tokenRequest.setAuthUsername(clientId);
            tokenRequest.setAuthPassword(clientSecret);
            Invocation.Builder request = new ResteasyService().getClientBuilder(tokenUrl);
            request.header(AUTHORIZATION, (Object)("Basic " + tokenRequest.getEncodedCredentials()));
            request.header(CONTENT_TYPE, (Object)"application/x-www-form-urlencoded");
            MultivaluedHashMap multivaluedHashMap = new MultivaluedHashMap(tokenRequest.getParameters());
            response = request.post(Entity.form((MultivaluedMap)multivaluedHashMap));
            this.log.trace("Response for Access Token -  response:{}", (Object)response);
            if (response.getStatus() == 200) {
                String entity = (String)response.readEntity(String.class);
                TokenResponse tokenResponse = new TokenResponse();
                tokenResponse.setEntity(entity);
                tokenResponse.injectDataFromJson(entity);
                TokenResponse tokenResponse2 = tokenResponse;
                return tokenResponse2;
            }
        }
        return null;
    }
}

