/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.core.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

public enum ProtectionScopeType {
    SCOPE("scope"),
    GROUP("group"),
    SUPER("super");

    private final String scopeName;

    private ProtectionScopeType(String scopeName) {
        this.scopeName = scopeName;
    }

    String getValue() {
        return this.toString().toLowerCase();
    }

    @JsonCreator
    public static ProtectionScopeType fromString(String scopeType) {
        if (StringUtils.isNotBlank((CharSequence)scopeType)) {
            for (ProtectionScopeType type : ProtectionScopeType.values()) {
                if (!scopeType.equalsIgnoreCase(type.getValue())) continue;
                return type;
            }
        }
        return null;
    }

    @JsonValue
    public String toString() {
        return this.scopeName;
    }

    public String getScopeName() {
        return this.scopeName;
    }
}

