/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.core.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jackson {
    private static final Logger LOG = LoggerFactory.getLogger(Jackson.class);

    private Jackson() {
    }

    public static JsonNode asJsonNode(String objAsString) throws JsonProcessingException {
        return JacksonUtils.newMapper().readTree(objAsString);
    }

    public static String getElement(String jsonString, String fieldName) throws JsonProcessingException {
        JsonNode jsonNode = JacksonUtils.newMapper().readTree(jsonString);
        return jsonNode.get(fieldName).textValue();
    }

    public static <T> T applyPatch(String patchAsString, T obj) throws JsonPatchException, IOException {
        LOG.debug("Patch details - patchAsString:{}, obj:{}", (Object)patchAsString, obj);
        JsonPatch jsonPatch = JsonPatch.fromJson((JsonNode)Jackson.asJsonNode(patchAsString));
        return Jackson.applyPatch(jsonPatch, obj);
    }

    public static boolean isFieldPresent(String patchAsString, String fieldName) {
        LOG.debug("Check if FieldPresent patchAsString:{} contains fieldName:{}", (Object)patchAsString, (Object)fieldName);
        boolean isPresent = false;
        if (patchAsString == null || fieldName == null) {
            LOG.warn("isFieldPresent called with null parameter - patchAsString: {}, fieldName: {}", (Object)patchAsString, (Object)fieldName);
            return isPresent;
        }
        try {
            JsonNode jsonNode = Jackson.asJsonNode(patchAsString);
            LOG.debug("patchAsString jsonNode:{}", (Object)jsonNode);
            ArrayList<String> keys = new ArrayList<String>();
            if (jsonNode.isArray()) {
                for (JsonNode operationNode : jsonNode) {
                    JsonNode pathNode = operationNode.get("path");
                    if (pathNode == null || !pathNode.isTextual()) continue;
                    keys.add(pathNode.asText());
                }
                LOG.debug(" FieldPresent keys:{}", keys);
                isPresent = keys.contains("/" + fieldName);
                LOG.debug(" FieldPresent contains fieldName:{}?:{}", (Object)fieldName, (Object)isPresent);
            }
        }
        catch (Exception e) {
            LOG.error("Error processing JSON Patch string for field '{}'", (Object)fieldName, (Object)e);
        }
        return isPresent;
    }

    public static JsonPatch getJsonPatch(String patchAsString) throws JsonPatchException, IOException {
        LOG.debug("Patch details - patchAsString:{}", (Object)patchAsString);
        return JsonPatch.fromJson((JsonNode)Jackson.asJsonNode(patchAsString));
    }

    public static <T> T applyJsonPatch(JsonPatch jsonPatch, T obj) throws JsonPatchException, IOException {
        LOG.debug("Patch details - jsonPatch:{}, obj:{}", (Object)jsonPatch, obj);
        return Jackson.applyPatch(jsonPatch, obj);
    }

    public static <T> T applyPatch(JsonPatch jsonPatch, T obj) throws JsonPatchException, JsonProcessingException {
        Preconditions.checkNotNull((Object)jsonPatch);
        Preconditions.checkNotNull(obj);
        ObjectMapper objectMapper = JacksonUtils.newMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode patched = jsonPatch.apply((JsonNode)objectMapper.convertValue(obj, JsonNode.class));
        return (T)objectMapper.treeToValue((TreeNode)patched, obj.getClass());
    }

    public static <T> T read(InputStream inputStream, T obj) throws IOException {
        Preconditions.checkNotNull((Object)inputStream);
        return (T)JacksonUtils.newMapper().readValue(inputStream, obj.getClass());
    }

    public static <T> T getObject(String jsonString, T obj) throws IOException {
        ObjectMapper objectMapper = JacksonUtils.newMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return (T)objectMapper.readValue(jsonString, obj.getClass());
    }

    public static ObjectMapper createJsonMapper() {
        return JacksonMapperHolder.MAPPER;
    }

    public static <T> String getJsonString(T obj) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString(obj);
    }

    public static String asJson(Object obj) throws IOException {
        ObjectMapper mapper = Jackson.createJsonMapper().configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        return mapper.writeValueAsString(obj);
    }

    public static String asPrettyJson(Object obj) throws IOException {
        ObjectMapper mapper = Jackson.createJsonMapper().configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
    }

    public static JSONObject createJSONObject(Map<String, Object> map) throws JSONException {
        if (map == null || map.size() == 0) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            jsonObject.put(entry.getKey(), entry.getValue());
        }
        return jsonObject;
    }

    public static boolean isValidJson(String json) {
        try {
            new JSONObject(json);
        }
        catch (JSONException e) {
            return false;
        }
        return true;
    }

    public static boolean isValidJson(Object obj) {
        try {
            new JSONObject(obj);
        }
        catch (JSONException e) {
            return false;
        }
        return true;
    }

    public static JSONObject convertObjectToJsonObject(Object obj) throws JsonProcessingException {
        ObjectMapper objectMapper = Jackson.createJsonMapper().configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        String jsonString = objectMapper.writeValueAsString(obj);
        return new JSONObject(jsonString);
    }

    private static class JacksonMapperHolder {
        private static final ObjectMapper MAPPER = JacksonMapperHolder.jsonMapper();

        private JacksonMapperHolder() {
        }

        public static ObjectMapper jsonMapper() {
            JacksonAnnotationIntrospector jackson = new JacksonAnnotationIntrospector();
            ObjectMapper mapper = new ObjectMapper();
            DeserializationConfig deserializationConfig = (DeserializationConfig)mapper.getDeserializationConfig().with((AnnotationIntrospector)jackson);
            SerializationConfig serializationConfig = (SerializationConfig)mapper.getSerializationConfig().with((AnnotationIntrospector)jackson);
            if (deserializationConfig == null || serializationConfig != null) {
                // empty if block
            }
            return mapper;
        }
    }
}

