/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.core.util;

import io.jans.configapi.core.service.ConfService;
import io.jans.configapi.core.util.DataUtil;
import io.jans.model.FieldFilterData;
import io.jans.orm.annotation.AttributeName;
import io.jans.orm.annotation.AttributesList;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class Util {
    private static final Class<?>[] LDAP_ENTRY_PROPERTY_ANNOTATIONS = new Class[]{AttributeName.class, AttributesList.class};
    @Inject
    Logger log;
    @Inject
    ConfService confService;

    public static String escapeLog(Object param) {
        if (param == null) {
            return "";
        }
        return param.toString().replaceAll("[\n\r\t]", "_");
    }

    public List<String> getTokens(String str, String tokenizer) {
        if (this.log.isInfoEnabled()) {
            this.log.info(" String to get tokens - str:{}, tokenizer:{}", (Object)Util.escapeLog(str), (Object)Util.escapeLog(tokenizer));
        }
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)str)) {
            list.add("");
            return list;
        }
        this.log.trace("str.contains(tokenizer):{}", (Object)str.contains(tokenizer));
        if (!str.contains(tokenizer)) {
            list.add(str);
            this.log.trace(" Not tokenized string - list:{}", list);
            return list;
        }
        this.log.info("final tokenized list:{}", Collections.list(new StringTokenizer(str, tokenizer)).stream().map(token -> (String)token).collect(Collectors.toList()));
        return Collections.list(new StringTokenizer(str, tokenizer)).stream().map(token -> (String)token).collect(Collectors.toList());
    }

    public Map<String, String> getFieldValueMap(Class<?> entityClass, String str, String tokenizer, String fieldValueSeparator) {
        if (this.log.isInfoEnabled()) {
            this.log.info(" Field Value to get map - entityClass:{}, str:{}, tokenizer:{} fieldValueSeparator:{}", new Object[]{Util.escapeLog(entityClass), Util.escapeLog(str), Util.escapeLog(tokenizer), Util.escapeLog(fieldValueSeparator)});
        }
        Map<String, String> fieldValueMap = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)str) || !str.contains(fieldValueSeparator)) {
            return fieldValueMap;
        }
        this.log.trace("getTokens(str, tokenizer):{}", this.getTokens(str, tokenizer));
        List<String> fieldValueList = this.getTokens(str, tokenizer);
        this.log.debug("fieldValueList:{}", fieldValueList);
        if (fieldValueList == null || fieldValueList.isEmpty()) {
            return fieldValueMap;
        }
        for (String data : fieldValueList) {
            String[] result = data.split(fieldValueSeparator);
            this.log.debug("fieldValueSeparator:{}, result:{}", (Object)fieldValueSeparator, (Object)result);
            if (result == null || result.length <= 0) continue;
            String fieldName = result[0];
            String value = null;
            if (result.length > 1) {
                value = result[1];
            }
            this.log.info("fieldName:{},value:{}", (Object)fieldName, (Object)value);
            fieldValueMap.put(fieldName, value);
        }
        this.log.info("fieldValueMap:{}", fieldValueMap);
        fieldValueMap = this.getAttributeData(entityClass, fieldValueMap);
        return fieldValueMap;
    }

    public List<FieldFilterData> getFieldValueList(Class<?> entityClass, String str, String tokenizer, List<String> fieldValueSeparator) {
        if (this.log.isInfoEnabled()) {
            this.log.info(" Get FieldValueList - entityClass:{}, str:{}, tokenizer:{} fieldValueSeparator:{}", new Object[]{Util.escapeLog(entityClass), Util.escapeLog(str), Util.escapeLog(tokenizer), Util.escapeLog(fieldValueSeparator)});
        }
        ArrayList<FieldFilterData> fieldFilterDataList = new ArrayList<FieldFilterData>();
        if (StringUtils.isBlank((CharSequence)str)) {
            return fieldFilterDataList;
        }
        List<String> fieldValueList = this.getTokens(str, tokenizer);
        this.log.debug("After tokenizing fieldValueList:{}", fieldValueList);
        if (fieldValueList == null || fieldValueList.isEmpty()) {
            return fieldFilterDataList;
        }
        Map<String, List<Annotation>> propertiesAnnotations = this.getPropertiesAnnotations(entityClass);
        Map<String, String> fieldTypeMap = DataUtil.getFieldTypeMap(entityClass);
        for (String data : fieldValueList) {
            if (!StringUtils.isNotBlank((CharSequence)data)) continue;
            FieldFilterData fieldFilterData = this.getFieldFilterData(propertiesAnnotations, fieldTypeMap, data, fieldValueSeparator);
            fieldFilterDataList.add(fieldFilterData);
        }
        this.log.info("Returning fieldFilterDataList:{}", fieldFilterDataList);
        return fieldFilterDataList;
    }

    private FieldFilterData getFieldFilterData(Map<String, List<Annotation>> propertiesAnnotations, Map<String, String> fieldTypeMap, String dataStr, List<String> fieldValueSeparator) {
        this.log.info("Get FieldFilterData - dataStr:{} , fieldValueSeparator:{}", (Object)dataStr, fieldValueSeparator);
        FieldFilterData fieldFilterData = null;
        if (StringUtils.isBlank((CharSequence)dataStr) || fieldValueSeparator == null || fieldValueSeparator.isEmpty()) {
            return fieldFilterData;
        }
        for (String separator : fieldValueSeparator) {
            if (dataStr.contains(separator)) {
                String[] result = dataStr.split(separator);
                this.log.debug("separator:{}, result:{}", (Object)separator, (Object)result);
                if (result != null && result.length > 0) {
                    String fieldName = result[0];
                    String value = null;
                    if (result.length > 1) {
                        value = result[1];
                    }
                    String dbFieldName = this.getFieldDBName(fieldName, propertiesAnnotations.get(fieldName));
                    String fieldType = this.getFieldDataType(fieldName, fieldTypeMap);
                    this.log.debug("fieldName:{}, dbFieldName:{}, fieldType:{}, value:{}, separator:{}", new Object[]{fieldName, dbFieldName, fieldType, value, separator});
                    fieldFilterData = new FieldFilterData(dbFieldName, separator, value, fieldType);
                }
            }
            this.log.info("Final fieldFilterData:{}", fieldFilterData);
        }
        return fieldFilterData;
    }

    private String getFieldDataType(String fieldName, Map<String, String> fieldTypeMap) {
        this.log.info("Get data type for fieldName:{}, fieldTypeMap:{}", (Object)fieldName, fieldTypeMap);
        String fieldType = "String";
        if (StringUtils.isBlank((CharSequence)fieldName) || fieldTypeMap == null || fieldTypeMap.isEmpty()) {
            return fieldType;
        }
        return fieldTypeMap.get(fieldName);
    }

    private Map<String, String> getAttributeData(Class<?> entityClass, Map<String, String> fieldValueMap) {
        if (this.log.isInfoEnabled()) {
            this.log.info("AttributeData details to be fetched for entityClass:{} with fieldValueMap:{} ", (Object)Util.escapeLog(entityClass), (Object)Util.escapeLog(fieldValueMap));
        }
        if (entityClass == null || fieldValueMap == null || fieldValueMap.isEmpty()) {
            return fieldValueMap;
        }
        Map<String, List<Annotation>> propertiesAnnotations = this.confService.getPropertiesAnnotations(entityClass, LDAP_ENTRY_PROPERTY_ANNOTATIONS);
        this.log.debug("Properties annotations fetched for theClass:{} are propertiesAnnotations:{}", entityClass, propertiesAnnotations);
        if (propertiesAnnotations == null || propertiesAnnotations.isEmpty()) {
            return fieldValueMap;
        }
        HashMap<String, String> updatedFieldValueMap = new HashMap<String, String>();
        if (!fieldValueMap.isEmpty()) {
            for (Map.Entry<String, String> entry : fieldValueMap.entrySet()) {
                this.log.debug("entry.getKey():{}, entry.getValue():{}", (Object)entry.getKey(), (Object)entry.getValue());
                String dbFieldName = this.getFieldDBName(entry.getKey(), propertiesAnnotations.get(entry.getKey()));
                if (StringUtils.isNotBlank((CharSequence)dbFieldName)) {
                    updatedFieldValueMap.put(dbFieldName, entry.getValue());
                    continue;
                }
                updatedFieldValueMap.put(entry.getKey(), entry.getValue());
            }
        }
        this.log.info("Returning updatedFieldValueMap:{} ", updatedFieldValueMap);
        return updatedFieldValueMap;
    }

    private String getFieldDBName(String fieldName, List<Annotation> annotations) {
        this.log.info("DB field to be fetched for fieldName:{} are annotations:{}", (Object)fieldName, annotations);
        if (StringUtils.isBlank((CharSequence)fieldName) || annotations == null || annotations.isEmpty()) {
            return fieldName;
        }
        for (Annotation annotation : annotations) {
            try {
                AttributeName attributeName = (AttributeName)annotation;
                if (attributeName == null || !StringUtils.isNotBlank((CharSequence)attributeName.name())) continue;
                fieldName = attributeName.name();
            }
            catch (Exception ex) {
                this.log.error("Error while fetching DB fieldName for fieldName:{} is :{}", (Object)fieldName, (Object)ex);
            }
        }
        this.log.info("Final DB field fieldName:{} ", (Object)fieldName);
        return fieldName;
    }

    private Map<String, List<Annotation>> getPropertiesAnnotations(Class<?> entityClass) {
        this.log.info("Get propertiesAnnotations for entityClass:{}", entityClass);
        Map<String, List<Annotation>> propertiesAnnotations = null;
        if (entityClass == null) {
            return propertiesAnnotations;
        }
        propertiesAnnotations = this.confService.getPropertiesAnnotations(entityClass, LDAP_ENTRY_PROPERTY_ANNOTATIONS);
        this.log.debug("Properties annotations fetched for theClass:{} are propertiesAnnotations:{}", entityClass, propertiesAnnotations);
        return propertiesAnnotations;
    }
}

