/*
 * Decompiled with CFR 0.152.
 */
package io.jans.ca.plugin.adminui.service.webhook;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.jans.ca.plugin.adminui.model.auth.GenericResponse;
import io.jans.ca.plugin.adminui.model.exception.ApplicationException;
import io.jans.ca.plugin.adminui.model.webhook.AuiFeature;
import io.jans.ca.plugin.adminui.model.webhook.ShortCodeRequest;
import io.jans.ca.plugin.adminui.model.webhook.WebhookEntry;
import io.jans.ca.plugin.adminui.service.webhook.WebhookCallable;
import io.jans.ca.plugin.adminui.utils.CommonUtils;
import io.jans.ca.plugin.adminui.utils.ErrorResponse;
import io.jans.configapi.configuration.ConfigurationFactory;
import io.jans.model.SearchRequest;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.model.PagedResult;
import io.jans.orm.model.SortOrder;
import io.jans.orm.search.filter.Filter;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.Valid;
import jakarta.ws.rs.core.Response;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.python.google.common.collect.Sets;
import org.slf4j.Logger;

@Singleton
public class WebhookService {
    @Inject
    Logger log;
    @Inject
    private PersistenceEntryManager entryManager;
    @Inject
    ConfigurationFactory configurationFactory;
    public static final String AUI_FEATURE_ID = "auiFeatureId";

    public List<AuiFeature> getAllAuiFeatures() throws ApplicationException {
        try {
            Filter filter = Filter.createPresenceFilter((String)AUI_FEATURE_ID);
            return this.entryManager.findEntries("ou=auiFeatures,ou=admin-ui,o=jans", AuiFeature.class, filter);
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.FETCH_DATA_ERROR.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.FETCH_DATA_ERROR.getDescription());
        }
    }

    public List<AuiFeature> getAllAuiFeaturesByWebhookId(String webhookId) throws ApplicationException {
        try {
            List<AuiFeature> features = this.getAllAuiFeatures();
            return features.stream().filter(feature -> feature.getWebhookIdsMapped() != null).filter(feature -> feature.getWebhookIdsMapped().contains(webhookId)).collect(Collectors.toList());
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.FETCH_DATA_ERROR.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.FETCH_DATA_ERROR.getDescription());
        }
    }

    public PagedResult<WebhookEntry> searchWebhooks(SearchRequest searchRequest) throws ApplicationException {
        try {
            Filter searchFilter = null;
            ArrayList<Filter> filters = new ArrayList<Filter>();
            if (searchRequest.getFilterAssertionValue() != null && !searchRequest.getFilterAssertionValue().isEmpty()) {
                for (String assertionValue : searchRequest.getFilterAssertionValue()) {
                    String[] targetArray = new String[]{assertionValue};
                    Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
                    Filter webhookIdFilter = Filter.createSubstringFilter((String)"inum", null, (String[])targetArray, null);
                    Filter urlFilter = Filter.createSubstringFilter((String)"url", null, (String[])targetArray, null);
                    filters.add(Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, webhookIdFilter, urlFilter}));
                }
                searchFilter = Filter.createORFilter(filters);
            }
            this.log.debug("Webhook searchFilter:{}", searchFilter);
            return this.entryManager.findPagedEntries("ou=auiWebhooks,ou=admin-ui,o=jans", WebhookEntry.class, searchFilter, null, searchRequest.getSortBy(), SortOrder.getByValue((String)searchRequest.getSortOrder()), searchRequest.getStartIndex().intValue(), searchRequest.getCount().intValue(), searchRequest.getMaxCount());
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.WEBHOOK_SEARCH_ERROR.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.WEBHOOK_SEARCH_ERROR.getDescription());
        }
    }

    public List<WebhookEntry> getWebhookByIds(Set<String> ids) {
        try {
            Filter searchFilter = null;
            ArrayList<Filter> filters = new ArrayList<Filter>();
            for (String id : ids) {
                Filter filter = Filter.createSubstringFilter((String)"inum", null, (String[])new String[]{id}, null);
                filters.add(filter);
            }
            searchFilter = Filter.createORFilter(filters);
            this.log.debug("Webhooks searchFilter:{}", (Object)searchFilter);
            return this.entryManager.findEntries("ou=auiWebhooks,ou=admin-ui,o=jans", WebhookEntry.class, searchFilter);
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.WEBHOOK_SEARCH_ERROR.getDescription(), (Throwable)e);
            return Lists.newArrayList();
        }
    }

    public List<WebhookEntry> getWebhooksByFeatureId(String featureId) {
        try {
            Filter filter = Filter.createSubstringFilter((String)AUI_FEATURE_ID, null, (String[])new String[]{featureId}, null);
            List features = this.entryManager.findEntries("ou=auiFeatures,ou=admin-ui,o=jans", AuiFeature.class, filter);
            if (CollectionUtils.isEmpty((Collection)features)) {
                this.log.error(ErrorResponse.WEBHOOK_RECORD_NOT_EXIST.getDescription());
                throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.WEBHOOK_RECORD_NOT_EXIST.getDescription());
            }
            AuiFeature feature = (AuiFeature)features.get(0);
            List<String> webhooksIds = feature.getWebhookIdsMapped();
            if (CollectionUtils.isEmpty(webhooksIds)) {
                this.log.error(ErrorResponse.NO_WEBHOOK_FOUND.getDescription());
                throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.NO_WEBHOOK_FOUND.getDescription());
            }
            return this.getWebhookByIds(Sets.newHashSet(webhooksIds));
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.WEBHOOK_SEARCH_ERROR.getDescription(), (Throwable)e);
            return Lists.newArrayList();
        }
    }

    public List<AuiFeature> getAuiFeaturesByIds(Set<String> ids) {
        try {
            Filter searchFilter = null;
            ArrayList<Filter> filters = new ArrayList<Filter>();
            for (String id : ids) {
                Filter filter = Filter.createSubstringFilter((String)AUI_FEATURE_ID, null, (String[])new String[]{id}, null);
                filters.add(filter);
            }
            searchFilter = Filter.createORFilter(filters);
            this.log.debug("Features searchFilter:{}", (Object)searchFilter);
            return this.entryManager.findEntries("ou=auiFeatures,ou=admin-ui,o=jans", AuiFeature.class, searchFilter);
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.FETCH_DATA_ERROR.getDescription(), (Throwable)e);
            return Lists.newArrayList();
        }
    }

    public WebhookEntry addWebhook(@Valid WebhookEntry webhook) throws ApplicationException {
        try {
            this.validateWebhookEntry(webhook);
            String id = WebhookService.idFromName(webhook.getDisplayName() + webhook.getUrl() + webhook.getHttpMethod());
            webhook.setInum(id);
            webhook.setDn(WebhookService.dnOfWebhook(id, "ou=auiWebhooks,ou=admin-ui,o=jans"));
            this.entryManager.persist((Object)webhook);
            if (webhook.getAuiFeatureIds() != null) {
                List<AuiFeature> features = this.getAuiFeaturesByIds(webhook.getAuiFeatureIds());
                features.stream().forEach(feature -> {
                    feature.setWebhookIdsMapped(this.addNonExistingElements(id, feature.getWebhookIdsMapped()));
                    this.entryManager.merge(feature);
                });
            }
            return webhook;
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.WEBHOOK_SAVE_ERROR.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.WEBHOOK_SAVE_ERROR.getDescription());
        }
    }

    private List<String> addNonExistingElements(String element, List<String> collection) {
        if (collection == null) {
            collection = Lists.newArrayList();
        }
        HashSet tmpSet = Sets.newHashSet((Iterable)collection);
        tmpSet.add(element);
        return Lists.newArrayList((Iterable)tmpSet);
    }

    public void removeWebhook(WebhookEntry webhook) throws ApplicationException {
        try {
            if (Strings.isNullOrEmpty((String)webhook.getInum())) {
                this.log.error(ErrorResponse.WEBHOOK_ID_MISSING.getDescription());
                throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.WEBHOOK_ID_MISSING.getDescription());
            }
            List<AuiFeature> features = this.getAllAuiFeatures();
            features.stream().filter(feature -> feature.getWebhookIdsMapped() != null).filter(feature -> feature.getWebhookIdsMapped().contains(webhook.getInum())).forEach(feature -> {
                feature.getWebhookIdsMapped().remove(webhook.getInum());
                this.entryManager.merge(feature);
            });
            this.entryManager.remove((Object)webhook);
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.WEBHOOK_DELETE_ERROR.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.WEBHOOK_DELETE_ERROR.getDescription());
        }
    }

    public WebhookEntry updateWebhook(WebhookEntry webhook) throws ApplicationException {
        try {
            this.validateWebhookEntry(webhook);
            if (Strings.isNullOrEmpty((String)webhook.getInum())) {
                this.log.error(ErrorResponse.WEBHOOK_ID_MISSING.getDescription());
                throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.WEBHOOK_ID_MISSING.getDescription());
            }
            if (Strings.isNullOrEmpty((String)webhook.getDn())) {
                webhook.setDn(WebhookService.dnOfWebhook(webhook.getInum(), "ou=auiWebhooks,ou=admin-ui,o=jans"));
            }
            this.entryManager.merge((Object)webhook);
            List<AuiFeature> features = this.getAllAuiFeatures();
            features.stream().filter(feature -> feature.getWebhookIdsMapped() != null).filter(feature -> feature.getWebhookIdsMapped().contains(webhook.getInum())).forEach(feature -> {
                feature.getWebhookIdsMapped().remove(webhook.getInum());
                this.entryManager.merge(feature);
            });
            if (webhook.getAuiFeatureIds() != null) {
                features = this.getAuiFeaturesByIds(webhook.getAuiFeatureIds());
                features.stream().forEach(feature -> {
                    feature.setWebhookIdsMapped(this.addNonExistingElements(webhook.getInum(), feature.getWebhookIdsMapped()));
                    this.entryManager.merge(feature);
                });
            }
            return webhook;
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.WEBHOOK_UPDATE_ERROR.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.WEBHOOK_UPDATE_ERROR.getDescription());
        }
    }

    public void validateWebhookEntry(WebhookEntry webhookEntry) throws ApplicationException {
        if (webhookEntry == null) {
            this.log.error(ErrorResponse.WEBHOOK_ENTRY_EMPTY.getDescription());
            throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.WEBHOOK_ENTRY_EMPTY.getDescription());
        }
        if (Strings.isNullOrEmpty((String)webhookEntry.getDisplayName())) {
            this.log.error(ErrorResponse.WEBHOOK_NAME_EMPTY.getDescription());
            throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.WEBHOOK_NAME_EMPTY.getDescription());
        }
        if (Strings.isNullOrEmpty((String)webhookEntry.getUrl())) {
            this.log.error(ErrorResponse.WEBHOOK_URL_EMPTY.getDescription());
            throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.WEBHOOK_URL_EMPTY.getDescription());
        }
        if (Strings.isNullOrEmpty((String)webhookEntry.getHttpMethod())) {
            this.log.error(ErrorResponse.WEBHOOK_HTTP_METHOD_EMPTY.getDescription());
            throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.WEBHOOK_HTTP_METHOD_EMPTY.getDescription());
        }
        if (Lists.newArrayList((Object[])new String[]{"POST", "PUT", "PATCH"}).contains(webhookEntry.getHttpMethod())) {
            if (MapUtils.isEmpty(webhookEntry.getHttpRequestBody())) {
                this.log.error(ErrorResponse.WEBHOOK_REQUEST_BODY_EMPTY.getDescription());
                throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.WEBHOOK_REQUEST_BODY_EMPTY.getDescription());
            }
            if (webhookEntry.getHttpHeaders().stream().noneMatch(header -> header.getKey().equals("Content-Type"))) {
                this.log.error(ErrorResponse.WEBHOOK_CONTENT_TYPE_REQUIRED.getDescription());
                throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.WEBHOOK_CONTENT_TYPE_REQUIRED.getDescription());
            }
        }
    }

    public List<GenericResponse> triggerEnabledWebhooks(Set<String> webhookIds, List<ShortCodeRequest> shortCodes) throws ApplicationException {
        ExecutorService executor = Executors.newFixedThreadPool(10);
        ArrayList<GenericResponse> responseList = new ArrayList<GenericResponse>();
        ArrayList<WebhookCallable> callables = new ArrayList<WebhookCallable>();
        List<WebhookEntry> webhooks = this.getWebhookByIds(webhookIds);
        for (WebhookEntry webhookEntry : webhooks) {
            this.validateWebhookEntry(webhookEntry);
            ShortCodeRequest shortCodeObj = shortCodes.stream().filter(shortCode -> shortCode.getWebhookId().equals(webhook.getInum())).findAny().orElse(null);
            this.replaceShortCodeWithValues(webhookEntry, shortCodeObj);
            if (!webhookEntry.isJansEnabled()) continue;
            WebhookCallable callable = new WebhookCallable(webhookEntry, this.log);
            callables.add(callable);
        }
        for (Callable callable : callables) {
            Future future = executor.submit(callable);
            try {
                responseList.add((GenericResponse)future.get());
            }
            catch (InterruptedException | ExecutionException e) {
                this.log.error("Webhook execution interrupted!", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        executor.shutdown();
        return responseList;
    }

    private void replaceShortCodeWithValues(WebhookEntry webhook, ShortCodeRequest shortCodeObj) {
        if (shortCodeObj == null) {
            return;
        }
        if (CommonUtils.hasShortCode(webhook.getUrl())) {
            webhook.setUrl(CommonUtils.replacePlaceholders(webhook.getUrl(), shortCodeObj.getShortcodeValueMap()));
        }
        if (CommonUtils.hasShortCode(webhook.getHttpRequestBody()) && Lists.newArrayList((Object[])new String[]{"POST", "PUT", "PATCH"}).contains(webhook.getHttpMethod())) {
            webhook.setHttpRequestBody(CommonUtils.replacePlaceholders(webhook.getHttpRequestBody(), shortCodeObj.getShortcodeValueMap()));
        }
    }

    private static String idFromName(String name) {
        return UUID.nameUUIDFromBytes(name.getBytes(StandardCharsets.UTF_8)).toString();
    }

    private static String dnOfWebhook(String id, String baseDn) {
        return String.format("inum=%s,%s", id, baseDn);
    }

    public int getRecordMaxCount() {
        this.log.trace(" MaxCount details - ApiAppConfiguration.MaxCount():{}, DEFAULT_MAX_COUNT:{} ", (Object)this.configurationFactory.getApiAppConfiguration().getMaxCount(), (Object)200);
        return this.configurationFactory.getApiAppConfiguration().getMaxCount() > 0 ? this.configurationFactory.getApiAppConfiguration().getMaxCount() : 200;
    }
}

