/*
 * Decompiled with CFR 0.152.
 */
package io.jans.ca.plugin.adminui.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import io.jans.ca.plugin.adminui.model.auth.GenericResponse;
import jakarta.inject.Inject;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

public class CommonUtils {
    @Inject
    Logger log;
    public static final DateTimeFormatter LS_DATE_FORMAT = DateTimeFormatter.ofPattern("E, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);

    public static String joinAndUrlEncode(Collection<String> list) throws UnsupportedEncodingException {
        if (list == null || list.isEmpty()) {
            return "";
        }
        return CommonUtils.encode(Joiner.on((String)" ").join(list));
    }

    public static String encode(String str) throws UnsupportedEncodingException {
        return URLEncoder.encode(str, "UTF-8");
    }

    public static String getFormattedDate() {
        ZonedDateTime currentDateTime = ZonedDateTime.now();
        ZonedDateTime gmtTime = currentDateTime.withZoneSameInstant(ZoneId.of("GMT"));
        DateTimeFormatter currentTimeFormatter = LS_DATE_FORMAT;
        return gmtTime.format(currentTimeFormatter);
    }

    public static RSAPrivateKey loadPrivateKey(String privateKeyPEM) throws Exception {
        byte[] encoded = Base64.decodeBase64((String)privateKeyPEM);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
        return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
    }

    public static String decode(String toDecode) throws UnsupportedEncodingException {
        return URLDecoder.decode(toDecode, StandardCharsets.UTF_8.name());
    }

    public static GenericResponse createGenericResponse(boolean result, int responseCode, String responseMessage) {
        return CommonUtils.createGenericResponse(result, responseCode, responseMessage, null);
    }

    public static GenericResponse createGenericResponse(boolean result, int responseCode, String responseMessage, JsonNode node) {
        GenericResponse genericResponse = new GenericResponse();
        genericResponse.setResponseCode(responseCode);
        genericResponse.setResponseMessage(responseMessage);
        genericResponse.setSuccess(result);
        genericResponse.setResponseObject(node);
        return genericResponse;
    }

    public static boolean hasShortCode(Map<String, ?> map) {
        String pattern = "\\$\\{(\\w+)}";
        Pattern placeholderPattern = Pattern.compile(pattern);
        for (Object value : map.values()) {
            Matcher matcher = placeholderPattern.matcher(value.toString());
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasShortCode(String input) {
        String pattern = "\\$\\{(\\w+)}";
        Pattern placeholderPattern = Pattern.compile(pattern);
        Matcher matcher = placeholderPattern.matcher(input);
        return matcher.find();
    }

    public static Map<String, Object> replacePlaceholders(Map<String, Object> map, Map<String, Object> placeholderValues) {
        Pattern placeholderPattern = Pattern.compile("\\$\\{(\\w+)\\}");
        HashMap<String, Object> replacedMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String value;
            String replacedValue = value = entry.getValue().toString();
            Matcher matcher = placeholderPattern.matcher(value);
            while (matcher.find()) {
                String placeholderKey = matcher.group(1);
                Object replacement = placeholderValues.get(placeholderKey);
                if (replacement == null) continue;
                replacedValue = replacedValue.replace(matcher.group(0), replacement.toString());
            }
            replacedMap.put(entry.getKey(), replacedValue);
        }
        return replacedMap;
    }

    public static String replacePlaceholders(String url, Map<String, Object> placeholderValues) {
        Pattern placeholderPattern = Pattern.compile("\\$\\{(\\w+)\\}");
        Matcher matcher = placeholderPattern.matcher(url);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String placeholderKey = matcher.group(1);
            Object replacement = placeholderValues.get(placeholderKey);
            if (replacement == null) continue;
            matcher.appendReplacement(sb, replacement.toString());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static Map<String, Object> jsonStringToMap(String jsonString) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        return (Map)objectMapper.readValue(jsonString, Map.class);
    }

    public static String mapToJsonString(Map<String, Object> mapObj) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper.writeValueAsString(mapObj);
    }

    public static boolean isValidJson(String json) {
        try {
            new JSONObject(json);
        }
        catch (JSONException e) {
            return false;
        }
        return true;
    }

    public static String convertIsoToDateString(String isoDateTime) {
        Instant instant = Instant.parse(isoDateTime);
        LocalDate localDate = instant.atZone(ZoneId.systemDefault()).toLocalDate();
        return localDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    public static LocalDate convertStringToLocalDate(String dateString) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        return LocalDate.parse(dateString, formatter);
    }

    public static String convertLocalDateToString(LocalDate date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        return date.format(formatter);
    }
}

