/*
 * Decompiled with CFR 0.152.
 */
package io.jans.ca.plugin.adminui.service.config;

import com.google.api.client.util.Strings;
import com.google.common.collect.Maps;
import io.jans.as.client.TokenRequest;
import io.jans.as.client.TokenResponse;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.config.adminui.AdminConf;
import io.jans.as.model.config.adminui.LicenseConfig;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.ca.plugin.adminui.model.adminui.CedarlingLogType;
import io.jans.ca.plugin.adminui.model.config.AUIConfiguration;
import io.jans.ca.plugin.adminui.model.config.LicenseConfiguration;
import io.jans.ca.plugin.adminui.service.BaseService;
import io.jans.ca.plugin.adminui.utils.ErrorResponse;
import io.jans.configapi.service.auth.ConfigurationService;
import io.jans.orm.PersistenceEntryManager;
import io.jans.service.EncryptionService;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Singleton
public class AUIConfigurationService
extends BaseService {
    private Map<String, AUIConfiguration> appConfigurationMap;
    @Inject
    Logger logger;
    @Inject
    private PersistenceEntryManager entryManager;
    @Inject
    EncryptionService encryptionService;
    @Inject
    ConfigurationService configurationService;

    public AUIConfiguration getAUIConfiguration() throws Exception {
        return this.getAUIConfiguration(null);
    }

    public AUIConfiguration getAUIConfiguration(String appType) throws Exception {
        this.logger.info("Inside method to read the configuration from the persistence and stores it in a map.");
        try {
            if (Strings.isNullOrEmpty((String)appType)) {
                appType = "admin-ui";
            }
            if (this.appConfigurationMap == null) {
                this.appConfigurationMap = Maps.newHashMap();
            }
            AUIConfiguration auiConfiguration = null;
            if (this.appConfigurationMap.get(appType) == null) {
                AdminConf appConf = null;
                this.logger.debug("Admin UI configuration is not stored in cache map.");
                if (appType.equals("admin-ui")) {
                    this.logger.debug("Reading Admin UI configuration from persistence.");
                    appConf = (AdminConf)this.entryManager.find(AdminConf.class, (Object)"ou=admin-ui,ou=configuration,o=jans");
                } else if (appType.equals("ads")) {
                    appConf = (AdminConf)this.entryManager.find(AdminConf.class, (Object)"ou=agama-developer-studio,ou=configuration,o=jans");
                }
                auiConfiguration = this.addPropertiesToAUIConfiguration(appType, appConf);
                if (!appType.equals("ads")) {
                    auiConfiguration.setLicenseConfiguration(this.addPropertiesToLicenseConfiguration(appConf));
                    this.appConfigurationMap.put(appType, auiConfiguration);
                }
            }
            return this.appConfigurationMap.get(appType);
        }
        catch (Exception e) {
            this.logger.error(ErrorResponse.ERROR_READING_CONFIG.getDescription());
            throw e;
        }
    }

    public void setAuiConfiguration(AUIConfiguration auiConfiguration) {
        if (!Strings.isNullOrEmpty((String)auiConfiguration.getAppType())) {
            this.appConfigurationMap.put(auiConfiguration.getAppType(), auiConfiguration);
        }
    }

    private AUIConfiguration addPropertiesToAUIConfiguration(String appType, AdminConf appConf) {
        AUIConfiguration auiConfig = new AUIConfiguration();
        AppConfiguration appConfiguration = this.configurationService.find();
        auiConfig.setAppType(appType);
        auiConfig.setAuiWebServerHost(appConf.getMainSettings().getOidcConfig().getAuiWebClient().getOpHost());
        auiConfig.setAuiWebServerClientId(appConf.getMainSettings().getOidcConfig().getAuiWebClient().getClientId());
        auiConfig.setAuiWebServerClientSecret(appConf.getMainSettings().getOidcConfig().getAuiWebClient().getClientSecret());
        auiConfig.setAuiWebServerScope(StringUtils.join((Iterable)appConf.getMainSettings().getOidcConfig().getAuiWebClient().getScopes(), (String)"+"));
        auiConfig.setAuiWebServerRedirectUrl(appConf.getMainSettings().getOidcConfig().getAuiWebClient().getRedirectUri());
        auiConfig.setAuiWebServerFrontChannelLogoutUrl(appConf.getMainSettings().getOidcConfig().getAuiWebClient().getFrontchannelLogoutUri());
        auiConfig.setAuiWebServerPostLogoutRedirectUri(appConf.getMainSettings().getOidcConfig().getAuiWebClient().getPostLogoutUri());
        auiConfig.setAuiWebServerAuthzBaseUrl(appConfiguration.getAuthorizationEndpoint());
        auiConfig.setAuiWebServerTokenEndpoint(appConfiguration.getTokenEndpoint());
        auiConfig.setAuiWebServerIntrospectionEndpoint(appConfiguration.getIntrospectionEndpoint());
        auiConfig.setAuiWebServerUserInfoEndpoint(appConfiguration.getUserInfoEndpoint());
        auiConfig.setAuiWebServerEndSessionEndpoint(appConfiguration.getEndSessionEndpoint());
        auiConfig.setAuiWebServerAcrValues(StringUtils.join((Iterable)appConf.getMainSettings().getOidcConfig().getAuiWebClient().getAcrValues(), (String)"+"));
        auiConfig.setAuiBackendApiServerClientId(appConf.getMainSettings().getOidcConfig().getAuiBackendApiClient().getClientId());
        auiConfig.setAuiBackendApiServerClientSecret(appConf.getMainSettings().getOidcConfig().getAuiBackendApiClient().getClientSecret());
        auiConfig.setAuiBackendApiServerScope(StringUtils.join((Iterable)appConf.getMainSettings().getOidcConfig().getAuiBackendApiClient().getScopes(), (String)"+"));
        auiConfig.setAuiBackendApiServerTokenEndpoint(appConf.getMainSettings().getOidcConfig().getAuiBackendApiClient().getTokenEndpoint());
        auiConfig.setAuiBackendApiServerIntrospectionEndpoint(appConf.getMainSettings().getOidcConfig().getAuiBackendApiClient().getIntrospectionEndpoint());
        auiConfig.setSessionTimeoutInMins(appConf.getMainSettings().getUiConfig().getSessionTimeoutInMins());
        auiConfig.setAllowSmtpKeystoreEdit(appConf.getMainSettings().getUiConfig().getAllowSmtpKeystoreEdit());
        auiConfig.setAdditionalParameters(appConf.getMainSettings().getOidcConfig().getAuiWebClient().getAdditionalParameters());
        auiConfig.setCedarlingLogType(CedarlingLogType.fromString(appConf.getMainSettings().getUiConfig().getCedarlingLogType()));
        return auiConfig;
    }

    private LicenseConfiguration addPropertiesToLicenseConfiguration(AdminConf appConf) {
        this.logger.debug("Inside method to add Properties to license configuration.");
        LicenseConfiguration licenseConfiguration = new LicenseConfiguration();
        try {
            LicenseConfig licenseConfig = appConf.getMainSettings().getLicenseConfig();
            if (licenseConfig != null) {
                licenseConfiguration.setHardwareId(licenseConfig.getLicenseHardwareKey());
                licenseConfiguration.setLicenseKey(licenseConfig.getLicenseKey());
                licenseConfiguration.setScanApiHostname(licenseConfig.getScanLicenseApiHostname());
                licenseConfiguration.setScanAuthServerHostname(licenseConfig.getOidcClient().getOpHost());
                licenseConfiguration.setScanApiClientId(licenseConfig.getOidcClient().getClientId());
                licenseConfiguration.setScanApiClientSecret(licenseConfig.getOidcClient().getClientSecret());
                licenseConfiguration.setLicenseValidUpto(licenseConfig.getLicenseValidUpto());
                licenseConfiguration.setLicenseDetailsLastUpdatedOn(licenseConfig.getLicenseDetailsLastUpdatedOn());
                licenseConfiguration.setIntervalForSyncLicenseDetailsInDays(licenseConfig.getIntervalForSyncLicenseDetailsInDays());
                licenseConfiguration.setProductCode(licenseConfig.getProductCode());
                licenseConfiguration.setProductName(licenseConfig.getProductName());
                licenseConfiguration.setLicenseType(licenseConfig.getLicenseType());
                licenseConfiguration.setCustomerFirstName(licenseConfig.getCustomerFirstName());
                licenseConfiguration.setCustomerLastName(licenseConfig.getCustomerLastName());
                licenseConfiguration.setCustomerEmail(licenseConfig.getCustomerEmail());
                licenseConfiguration.setCompanyName(licenseConfig.getCompanyName());
                licenseConfiguration.setLicenseActive(licenseConfig.getLicenseActive());
                licenseConfiguration.setLicenseExpired(licenseConfig.getLicenseExpired());
                licenseConfiguration.setIntervalForSyncLicenseDetailsInDays(licenseConfig.getIntervalForSyncLicenseDetailsInDays());
                licenseConfiguration.setLicenseMAUThreshold(licenseConfig.getLicenseMAUThreshold());
            }
            return licenseConfiguration;
        }
        catch (Exception e) {
            this.logger.error(ErrorResponse.ERROR_IN_LICENSE_CONFIGURATION_VALIDATION.getDescription());
            return null;
        }
    }

    private TokenResponse generateToken(String opHost, String clientId, String clientSecret) {
        try {
            TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
            tokenRequest.setAuthUsername(clientId);
            tokenRequest.setAuthPassword(clientSecret);
            tokenRequest.setGrantType(GrantType.CLIENT_CREDENTIALS);
            tokenRequest.setScope("https://jans.io/oauth/jans-auth-server/config/adminui/license.readonly");
            this.logger.info("Trying to get access token from auth server: {}", (Object)opHost);
            String scanLicenseApiHostname = new StringBuffer().append(StringUtils.removeEnd((String)opHost, (String)"/")).append("/jans-auth/restv1/token").toString();
            TokenResponse tokenResponse = null;
            tokenResponse = this.getToken(tokenRequest, scanLicenseApiHostname);
            return tokenResponse;
        }
        catch (Exception e) {
            this.logger.error(ErrorResponse.TOKEN_GENERATION_ERROR.getDescription());
            return null;
        }
    }
}

