/*
 * Decompiled with CFR 0.152.
 */
package io.jans.ca.plugin.adminui.model.webhook;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Lists;
import io.jans.as.model.config.adminui.KeyValuePair;
import io.jans.ca.plugin.adminui.utils.CommonUtils;
import io.jans.orm.annotation.AttributeName;
import io.jans.orm.annotation.DataEntry;
import io.jans.orm.annotation.JsonObject;
import io.jans.orm.annotation.ObjectClass;
import io.jans.orm.model.base.Entry;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.MapUtils;

@DataEntry(sortBy={"inum"})
@ObjectClass(value="auiWebhooks")
public class WebhookEntry
extends Entry
implements Serializable {
    @AttributeName(ignoreDuringUpdate=true)
    private String inum;
    @NotNull
    @AttributeName(name="displayName")
    @Pattern(regexp="^[a-zA-Z0-9_\\-\\:\\/\\.]+$", message="Name should contain only letters, digits and underscores")
    @Size(min=2, max=60, message="Length of the Name should be between 1 and 30")
    private @NotNull @Pattern(regexp="^[a-zA-Z0-9_\\-\\:\\/\\.]+$", message="Name should contain only letters, digits and underscores") @Size(min=2, max=60, message="Length of the Name should be between 1 and 30") String displayName;
    @AttributeName(name="description")
    private String description;
    @NotNull
    @AttributeName(name="url")
    private String url;
    @JsonObject
    private transient Map<String, Object> httpRequestBody;
    @AttributeName(name="httpRequestBody")
    private String httpRequestBodyString;
    @AttributeName(name="httpMethod")
    private String httpMethod;
    @AttributeName(name="jansEnabled")
    private boolean jansEnabled;
    @JsonObject
    @AttributeName(name="httpHeaders")
    private List<KeyValuePair> httpHeaders = new ArrayList<KeyValuePair>();
    private Set<String> auiFeatureIds;

    public WebhookEntry() {
    }

    public WebhookEntry(WebhookEntry webhookEntry) {
        this.inum = webhookEntry.getInum();
        this.displayName = webhookEntry.getDisplayName();
        this.description = webhookEntry.getDescription();
        this.url = webhookEntry.getUrl();
        this.httpRequestBody = webhookEntry.getHttpRequestBody();
        if (Lists.newArrayList((Object[])new String[]{"POST", "PUT", "PATCH"}).contains(webhookEntry.getHttpMethod())) {
            try {
                if (!MapUtils.isEmpty(webhookEntry.getHttpRequestBody())) {
                    this.httpRequestBodyString = CommonUtils.mapToJsonString(webhookEntry.getHttpRequestBody());
                }
                if (CommonUtils.isValidJson(webhookEntry.getHttpRequestBodyString())) {
                    this.httpRequestBody = CommonUtils.jsonStringToMap(webhookEntry.getHttpRequestBodyString());
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        this.httpMethod = webhookEntry.getHttpMethod();
        this.jansEnabled = webhookEntry.isJansEnabled();
        this.httpHeaders = webhookEntry.getHttpHeaders();
        this.auiFeatureIds = webhookEntry.getAuiFeatureIds();
    }

    public String getHttpRequestBodyString() {
        return this.httpRequestBodyString;
    }

    public void setHttpRequestBodyString(String httpRequestBodyString) {
        this.httpRequestBodyString = httpRequestBodyString;
        try {
            if (CommonUtils.isValidJson(httpRequestBodyString)) {
                this.httpRequestBody = CommonUtils.jsonStringToMap(httpRequestBodyString);
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public String getInum() {
        return this.inum;
    }

    public void setInum(String inum) {
        this.inum = inum;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public boolean isJansEnabled() {
        return this.jansEnabled;
    }

    public void setJansEnabled(boolean jansEnabled) {
        this.jansEnabled = jansEnabled;
    }

    public List<KeyValuePair> getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(List<KeyValuePair> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public void addHttpHeader(String key, String value) {
        KeyValuePair header = new KeyValuePair(key, value);
        this.httpHeaders.add(header);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, Object> getHttpRequestBody() {
        if (this.httpRequestBody == null) {
            this.httpRequestBody = new HashMap<String, Object>();
        }
        return this.httpRequestBody;
    }

    public void setHttpRequestBody(Map<String, Object> httpRequestBody) {
        this.httpRequestBody = httpRequestBody;
        try {
            if (!MapUtils.isEmpty(httpRequestBody)) {
                this.httpRequestBodyString = CommonUtils.mapToJsonString(httpRequestBody);
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public Set<String> getAuiFeatureIds() {
        return this.auiFeatureIds;
    }

    public void setAuiFeatureIds(Set<String> auiFeatureIds) {
        this.auiFeatureIds = auiFeatureIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebhookEntry that = (WebhookEntry)o;
        return this.displayName.equals(that.displayName) && this.url.equals(that.url) && this.httpMethod.equals(that.httpMethod);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.displayName, this.url, this.httpMethod);
    }

    public String toString() {
        return "WebhookEntry{, inum='" + this.inum + "', displayName='" + this.displayName + "', url='" + this.url + "', httpMethod='" + this.httpMethod + "', jansEnabled=" + this.jansEnabled + ", httpHeaders='" + this.httpHeaders + "'}";
    }
}

