/*
 * Decompiled with CFR 0.152.
 */
package io.jans.ca.plugin.adminui.rest.auth;

import io.jans.ca.plugin.adminui.model.auth.ApiTokenRequest;
import io.jans.ca.plugin.adminui.model.auth.TokenResponse;
import io.jans.ca.plugin.adminui.model.exception.ApplicationException;
import io.jans.ca.plugin.adminui.service.auth.OAuth2Service;
import io.jans.ca.plugin.adminui.service.config.AUIConfigurationService;
import io.jans.ca.plugin.adminui.utils.CommonUtils;
import io.jans.ca.plugin.adminui.utils.ErrorResponse;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;

@Hidden
@Path(value="/app")
public class OAuth2Resource {
    static final String OAUTH2_CONFIG = "/{appType}/oauth2/config";
    static final String OAUTH2_API_PROTECTION_TOKEN = "/{appType}/oauth2/api-protection-token";
    public static final String SCOPE_OPENID = "openid";
    @Inject
    Logger log;
    @Inject
    AUIConfigurationService auiConfigurationService;
    @Inject
    OAuth2Service oAuth2Service;

    @POST
    @Path(value="/{appType}/oauth2/api-protection-token")
    @Produces(value={"application/json"})
    public Response getApiProtectionToken(@Valid @NotNull ApiTokenRequest apiTokenRequest, @PathParam(value="appType") String appType) {
        try {
            this.log.info("Api protection token request to Auth Server.");
            TokenResponse tokenResponse = this.oAuth2Service.getApiProtectionToken(apiTokenRequest, appType);
            this.log.info("Api protection token received from Auth Server.");
            return Response.ok((Object)tokenResponse).build();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.GET_API_PROTECTION_TOKEN_ERROR.getDescription(), (Throwable)e);
            return Response.status((int)e.getErrorCode()).entity((Object)CommonUtils.createGenericResponse(false, e.getErrorCode(), e.getMessage())).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.GET_API_PROTECTION_TOKEN_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, 500, ErrorResponse.GET_API_PROTECTION_TOKEN_ERROR.getDescription())).build();
        }
    }
}

