/*
 * Decompiled with CFR 0.152.
 */
package io.jans.ca.plugin.adminui.service.auth;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import io.jans.as.client.TokenRequest;
import io.jans.as.client.TokenResponse;
import io.jans.as.model.common.GrantType;
import io.jans.ca.plugin.adminui.model.auth.ApiTokenRequest;
import io.jans.ca.plugin.adminui.model.config.AUIConfiguration;
import io.jans.ca.plugin.adminui.model.exception.ApplicationException;
import io.jans.ca.plugin.adminui.service.BaseService;
import io.jans.ca.plugin.adminui.service.config.AUIConfigurationService;
import io.jans.ca.plugin.adminui.utils.CommonUtils;
import io.jans.ca.plugin.adminui.utils.ErrorResponse;
import io.jans.service.EncryptionService;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.Response;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;

@Singleton
public class OAuth2Service
extends BaseService {
    @Inject
    Logger log;
    @Inject
    AUIConfigurationService auiConfigurationService;
    @Inject
    EncryptionService encryptionService;

    public io.jans.ca.plugin.adminui.model.auth.TokenResponse getApiProtectionToken(ApiTokenRequest apiTokenRequest, String appType) throws ApplicationException {
        try {
            this.log.debug("Getting api-protection token");
            AUIConfiguration auiConfiguration = this.auiConfigurationService.getAUIConfiguration(appType);
            TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
            tokenRequest.setAuthUsername(auiConfiguration.getAuiBackendApiServerClientId());
            tokenRequest.setAuthPassword(this.encryptionService.decrypt(auiConfiguration.getAuiBackendApiServerClientSecret()));
            tokenRequest.setGrantType(GrantType.CLIENT_CREDENTIALS);
            tokenRequest.setRedirectUri(auiConfiguration.getAuiBackendApiServerRedirectUrl());
            TokenResponse tokenResponse = null;
            if (apiTokenRequest == null) {
                tokenRequest.setScope(OAuth2Service.scopeAsString(Arrays.asList("openid")));
                tokenResponse = this.getToken(tokenRequest, auiConfiguration.getAuiBackendApiServerTokenEndpoint());
            } else {
                if (Strings.isNullOrEmpty((String)apiTokenRequest.getUjwt())) {
                    this.log.warn(ErrorResponse.USER_INFO_JWT_BLANK.getDescription());
                    tokenRequest.setScope(OAuth2Service.scopeAsString(Arrays.asList("openid")));
                }
                tokenResponse = this.getToken(tokenRequest, auiConfiguration.getAuiBackendApiServerTokenEndpoint(), apiTokenRequest.getUjwt(), apiTokenRequest.getPermissionTag());
            }
            Optional<Map<String, Object>> introspectionResponse = this.introspectToken(tokenResponse.getAccessToken(), auiConfiguration.getAuiBackendApiServerIntrospectionEndpoint());
            io.jans.ca.plugin.adminui.model.auth.TokenResponse tokenResp = new io.jans.ca.plugin.adminui.model.auth.TokenResponse();
            tokenResp.setAccessToken(tokenResponse.getAccessToken());
            tokenResp.setIdToken(tokenResponse.getIdToken());
            tokenResp.setRefreshToken(tokenResponse.getRefreshToken());
            if (!introspectionResponse.isPresent()) {
                return tokenResp;
            }
            String SCOPE = "scope";
            Map<String, Object> claims = introspectionResponse.get();
            if (claims.get("scope") != null) {
                if (claims.get("scope") instanceof List) {
                    tokenResp.setScopes((List)claims.get("scope"));
                }
                if (claims.get("scope") instanceof String) {
                    tokenResp.setScopes(Arrays.asList(((String)claims.get("scope")).split(" ")));
                }
            }
            if (claims.get("iat") != null) {
                tokenResp.setIat(Long.valueOf(claims.get("iat").toString()));
            }
            if (claims.get("exp") != null) {
                tokenResp.setExp(Long.valueOf(claims.get("exp").toString()));
            }
            if (claims.get("iss") != null) {
                tokenResp.setIssuer(claims.get("iss").toString());
            }
            return tokenResp;
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.GET_API_PROTECTION_TOKEN_ERROR.getDescription());
            throw e;
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.GET_API_PROTECTION_TOKEN_ERROR.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.GET_API_PROTECTION_TOKEN_ERROR.getDescription());
        }
    }

    private static String scopeAsString(List<String> scopes) throws UnsupportedEncodingException {
        HashSet scope = Sets.newHashSet();
        scope.addAll(scopes);
        return CommonUtils.joinAndUrlEncode(scope);
    }
}

