/*
 * Decompiled with CFR 0.152.
 */
package io.jans.ca.plugin.adminui.rest;

import io.jans.ca.plugin.adminui.rest.adminui.AdminUIResource;
import io.jans.ca.plugin.adminui.rest.adminui.AdminUISecurityResource;
import io.jans.ca.plugin.adminui.rest.auth.OAuth2Resource;
import io.jans.ca.plugin.adminui.rest.license.LicenseResource;
import io.jans.ca.plugin.adminui.rest.logging.AuditLoggerResource;
import io.jans.ca.plugin.adminui.rest.webhook.WebhookResource;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.info.Contact;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.info.License;
import io.swagger.v3.oas.annotations.security.OAuthFlow;
import io.swagger.v3.oas.annotations.security.OAuthFlows;
import io.swagger.v3.oas.annotations.security.OAuthScope;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.core.Application;
import java.util.HashSet;
import java.util.Set;

@ApplicationPath(value="/")
@OpenAPIDefinition(info=@Info(title="Jans Config API - Admin-UI", version="1.0.0", contact=@Contact(name="Gluu Support", url="https://support.gluu.org", email="xxx@gluu.org"), license=@License(name="Apache 2.0", url="https://github.com/JanssenProject/jans/blob/main/LICENSE")), tags={@Tag(name="Admin UI - Role"), @Tag(name="Admin UI - Permission"), @Tag(name="Admin UI - Role-Permissions Mapping"), @Tag(name="Admin UI - License"), @Tag(name="Admin UI - Webhooks"), @Tag(name="Admin UI - Cedarling")}, servers={@Server(url="https://jans.io/", description="The Jans server")})
@SecurityScheme(name="oauth2", type=SecuritySchemeType.OAUTH2, flows=@OAuthFlows(clientCredentials=@OAuthFlow(tokenUrl="https://{op-hostname}/.../token", scopes={@OAuthScope(name="https://jans.io/oauth/jans-auth-server/config/adminui/user/role.read", description="View admin user role related information"), @OAuthScope(name="https://jans.io/oauth/jans-auth-server/config/adminui/user/role.write", description="Manage admin user role related information"), @OAuthScope(name="https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.read", description="View admin permission related information"), @OAuthScope(name="https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.write", description="Manage admin permission related information"), @OAuthScope(name="https://jans.io/oauth/jans-auth-server/config/adminui/user/rolePermissionMapping.readonly", description="View role-permission mapping related information"), @OAuthScope(name="https://jans.io/oauth/jans-auth-server/config/adminui/user/rolePermissionMapping.write", description="Manage role-permission mapping related information"), @OAuthScope(name="https://jans.io/oauth/jans-auth-server/config/adminui/license.readonly", description="View admin-ui license related information"), @OAuthScope(name="https://jans.io/oauth/jans-auth-server/config/adminui/license.write", description="Manage admin-ui license related information"), @OAuthScope(name="https://jans.io/oauth/jans-auth-server/config/adminui/security.readonly", description="View Admin UI security related information"), @OAuthScope(name="https://jans.io/oauth/jans-auth-server/config/adminui/security.write", description="Manage Admin UI security related information")})))
public class ApiApplication
extends Application {
    public Set<Class<?>> getClasses() {
        HashSet classes = new HashSet();
        classes.add(OAuth2Resource.class);
        classes.add(AuditLoggerResource.class);
        classes.add(LicenseResource.class);
        classes.add(AdminUIResource.class);
        classes.add(WebhookResource.class);
        classes.add(AdminUISecurityResource.class);
        return classes;
    }
}

