/*
 * Decompiled with CFR 0.152.
 */
package io.jans.ca.plugin.adminui.rest.webhook;

import io.jans.as.model.util.Util;
import io.jans.as.persistence.model.Scope;
import io.jans.ca.plugin.adminui.model.auth.GenericResponse;
import io.jans.ca.plugin.adminui.model.exception.ApplicationException;
import io.jans.ca.plugin.adminui.model.webhook.AuiFeature;
import io.jans.ca.plugin.adminui.model.webhook.ShortCodeRequest;
import io.jans.ca.plugin.adminui.model.webhook.WebhookEntry;
import io.jans.ca.plugin.adminui.service.webhook.WebhookService;
import io.jans.ca.plugin.adminui.utils.CommonUtils;
import io.jans.ca.plugin.adminui.utils.ErrorResponse;
import io.jans.configapi.core.rest.BaseResource;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.model.SearchRequest;
import io.jans.orm.model.PagedResult;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.python.google.common.collect.Sets;
import org.slf4j.Logger;

@Path(value="/admin-ui/webhook")
public class WebhookResource
extends BaseResource {
    public static final String SCOPE_WEBHOOK_READ = "https://jans.io/oauth/jans-auth-server/config/adminui/webhook.readonly";
    public static final String SCOPE_WEBHOOK_WRITE = "https://jans.io/oauth/jans-auth-server/config/adminui/webhook.write";
    public static final String SCOPE_WEBHOOK_DELETE = "https://jans.io/oauth/jans-auth-server/config/adminui/webhook.delete";
    public static final String WEBHOOK = "webhook";
    public static final String WEBHOOK_ID_PATH_VARIABLE = "/{webhookId}";
    public static final String FEATURE_ID_PATH_VARIABLE = "/{featureId}";
    public static final String TRIGGER_PATH = "/trigger";
    public static final String ADMIN_UI_FEATURES = "/features";
    @Inject
    Logger log;
    @Inject
    WebhookService webhookService;

    @Operation(summary="Gets list of Admin UI features", description="Gets list of Admin UI features", operationId="get-all-features", tags={"Admin UI - Webhooks"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/webhook.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=AuiFeature.class), examples={@ExampleObject(name="Response json example", value="example/webhook/get-all-features.json")})}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))})})
    @GET
    @Path(value="/features")
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/webhook.readonly"})
    @Produces(value={"application/json"})
    public Response getAllAdminUIFeatures() {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Fetching all Admin UI features");
            }
            List<AuiFeature> auiFeatures = this.webhookService.getAllAuiFeatures();
            return Response.ok(auiFeatures).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.FETCH_DATA_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.FETCH_DATA_ERROR.getDescription())).build();
        }
    }

    @Operation(summary="Gets list of Admin UI features mapped to webhookId", description="Gets list of Admin UI features mapped to webhookId", operationId="get-features-by-webhook-id", tags={"Admin UI - Webhooks"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/webhook.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=AuiFeature.class), examples={@ExampleObject(name="Response json example", value="example/webhook/get-features-by-webhook-id.json")})}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))})})
    @GET
    @Path(value="/features/{webhookId}")
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/webhook.readonly"})
    @Produces(value={"application/json"})
    public Response getAllAuiFeaturesByWebhookId(@Parameter(description="Webhook identifier") @PathParam(value="webhookId") @NotNull String webhookId) {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Fetching all Admin UI features by webhookId");
            }
            List<AuiFeature> auiFeatures = this.webhookService.getAllAuiFeaturesByWebhookId(webhookId);
            return Response.ok(auiFeatures).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.FETCH_DATA_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.FETCH_DATA_ERROR.getDescription())).build();
        }
    }

    @Operation(summary="Gets list of Admin UI Webhooks mapped to featureId", description="Gets list of Admin UI Webhooks mapped to featureId", operationId="get-webhooks-by-feature-id", tags={"Admin UI - Webhooks"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/webhook.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=WebhookEntry.class), examples={@ExampleObject(name="Response json example", value="example/webhook/get-webhook-by-feature-id.json")})}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))})})
    @GET
    @Path(value="/{featureId}")
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/webhook.readonly"})
    @Produces(value={"application/json"})
    public Response getAllWebhooksByFeatureId(@Parameter(description="Feature identifier") @PathParam(value="featureId") @NotNull String featureId) {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Fetching all Admin UI webhooks by featureId");
            }
            List<WebhookEntry> webhooks = this.webhookService.getWebhooksByFeatureId(featureId);
            return Response.ok(webhooks).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.FETCH_DATA_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.FETCH_DATA_ERROR.getDescription())).build();
        }
    }

    @Operation(summary="Gets list of webhooks", description="Gets list of webhooks", operationId="get-all-webhooks", tags={"Admin UI - Webhooks"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/webhook.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=PagedResult.class), examples={@ExampleObject(name="Response json example", value="example/webhook/get-all-webhooks.json")})}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))})})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/webhook.readonly"})
    @Produces(value={"application/json"})
    public Response getWebhooks(@Parameter(description="Search size - max size of the results to return") @DefaultValue(value="50") @QueryParam(value="limit") int limit, @Parameter(description="Search pattern") @DefaultValue(value="") @QueryParam(value="pattern") String pattern, @Parameter(description="The 1-based index of the first query result") @DefaultValue(value="0") @QueryParam(value="startIndex") int startIndex, @Parameter(description="Attribute whose value will be used to order the returned response") @DefaultValue(value="inum") @QueryParam(value="sortBy") String sortBy, @Parameter(description="Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\"") @DefaultValue(value="ascending") @QueryParam(value="sortOrder") String sortOrder, @Parameter(description="Field and value pair for seraching", examples={@ExampleObject(name="Field value example", value="scopeType=spontaneous,defaultScope=true")}) @DefaultValue(value="") @QueryParam(value="fieldValuePair") String fieldValuePair) {
        try {
            if (this.log.isInfoEnabled()) {
                this.log.info("User search param - limit:{}, pattern:{}, startIndex:{}, sortBy:{}, sortOrder:{}, fieldValuePair:{}", new Object[]{Util.escapeLog((Object)limit), Util.escapeLog((Object)pattern), Util.escapeLog((Object)startIndex), Util.escapeLog((Object)sortBy), Util.escapeLog((Object)sortOrder), Util.escapeLog((Object)fieldValuePair)});
            }
            SearchRequest searchReq = this.createSearchRequest("ou=auiWebhooks,ou=admin-ui,o=jans", pattern, sortBy, sortOrder, startIndex, limit, null, null, this.webhookService.getRecordMaxCount(), fieldValuePair, WebhookEntry.class);
            return Response.ok(this.doSearch(searchReq)).build();
        }
        catch (ApplicationException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return Response.status((int)e.getErrorCode()).entity((Object)CommonUtils.createGenericResponse(false, e.getErrorCode(), e.getMessage())).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.FETCH_DATA_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.FETCH_DATA_ERROR.getDescription())).build();
        }
    }

    @Operation(summary="Create Webhook", description="Create Webhook", operationId="post-webhook", tags={"Admin UI - Webhooks"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/webhook.write"})})
    @RequestBody(description="Webhook object", content={@Content(mediaType="application/json", schema=@Schema(implementation=WebhookEntry.class), examples={@ExampleObject(name="Request json example", value="example/webhook/post-webhook-request.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Created", content={@Content(mediaType="application/json", schema=@Schema(implementation=Scope.class), examples={@ExampleObject(name="Response json example", value="example/webhook/post-webhook-response.json")})}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))})})
    @POST
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/webhook.write"})
    @Produces(value={"application/json"})
    public Response addWebhook(@Valid WebhookEntry webhook) {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Webhook to be added - webhookEntry:{}", (Object)Util.escapeLog((Object)webhook.getDisplayName()));
            }
            WebhookEntry result = this.webhookService.addWebhook(webhook);
            this.log.debug("Id of newly added is {}", (Object)result.getInum());
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)result).build();
        }
        catch (ApplicationException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return Response.status((int)e.getErrorCode()).entity((Object)CommonUtils.createGenericResponse(false, e.getErrorCode(), e.getMessage())).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.WEBHOOK_SAVE_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.WEBHOOK_SAVE_ERROR.getDescription())).build();
        }
    }

    @Operation(summary="Update Webhook", description="Update Webhook", operationId="put-webhook", tags={"Admin UI - Webhooks"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/webhook.write"})})
    @RequestBody(description="Webhook object", content={@Content(mediaType="application/json", schema=@Schema(implementation=WebhookEntry.class), examples={@ExampleObject(name="Request json example", value="example/webhook/put-webhook.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=WebhookEntry.class), examples={@ExampleObject(name="Response json example", value="example/webhook/put-webhook.json")})}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))})})
    @PUT
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/webhook.write"})
    @Produces(value={"application/json"})
    public Response updateWebhook(@Valid WebhookEntry webhook) {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Webhook to be updated :{}", (Object)Util.escapeLog((Object)webhook.getInum()));
            }
            HashSet webhookIdSet = Sets.newHashSet();
            webhookIdSet.add(webhook.getInum());
            List<WebhookEntry> existingWebhooks = this.webhookService.getWebhookByIds(webhookIdSet);
            if (existingWebhooks == null) {
                this.log.error(ErrorResponse.WEBHOOK_RECORD_NOT_EXIST.getDescription());
                throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.WEBHOOK_RECORD_NOT_EXIST.getDescription());
            }
            if (!existingWebhooks.isEmpty()) {
                WebhookEntry existingWebhook = existingWebhooks.get(0);
                WebhookResource.checkResourceNotNull((Object)existingWebhook, (String)WEBHOOK);
                webhook.setInum(existingWebhook.getInum());
                webhook.setDn(existingWebhook.getDn());
            }
            webhook = this.webhookService.updateWebhook(webhook);
            this.log.debug("Updated webhook:{}", (Object)webhook.getInum());
            return Response.ok((Object)webhook).build();
        }
        catch (ApplicationException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return Response.status((int)e.getErrorCode()).entity((Object)CommonUtils.createGenericResponse(false, e.getErrorCode(), e.getMessage())).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.WEBHOOK_UPDATE_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.WEBHOOK_SAVE_ERROR.getDescription())).build();
        }
    }

    @Operation(summary="Delete Webhook", description="Delete Webhook", operationId="delete-Webhook-by-inum", tags={"Admin UI - Webhooks"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/webhook.delete"})})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))})})
    @DELETE
    @Path(value="/{webhookId}")
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/webhook.delete"})
    @Produces(value={"application/json"})
    public Response deleteWebhook(@Parameter(description="Webhook identifier") @PathParam(value="webhookId") @NotNull String webhookId) {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Webhook to be deleted - webhookId:{}", (Object)Util.escapeLog((Object)webhookId));
            }
            HashSet webhookIdSet = Sets.newHashSet();
            webhookIdSet.add(webhookId);
            List<WebhookEntry> result = this.webhookService.getWebhookByIds(webhookIdSet);
            if (result == null) {
                this.log.error(ErrorResponse.WEBHOOK_RECORD_NOT_EXIST.getDescription());
                throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.WEBHOOK_RECORD_NOT_EXIST.getDescription());
            }
            if (!result.isEmpty()) {
                WebhookEntry existingWebhook = result.get(0);
                WebhookResource.checkResourceNotNull((Object)existingWebhook, (String)WEBHOOK);
                this.webhookService.removeWebhook(existingWebhook);
            }
            this.log.debug("Webhook is deleted");
            return Response.noContent().build();
        }
        catch (ApplicationException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return Response.status((int)e.getErrorCode()).entity((Object)CommonUtils.createGenericResponse(false, e.getErrorCode(), e.getMessage())).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.WEBHOOK_DELETE_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.WEBHOOK_DELETE_ERROR.getDescription())).build();
        }
    }

    @Operation(summary="Trigger webhooks mapped to featureId", description="Trigger webhooks mapped to featureId", operationId="trigger-webhook", tags={"Admin UI - Webhooks"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/webhook.readonly"})})
    @RequestBody(description="Webhook object", content={@Content(mediaType="application/json", schema=@Schema(implementation=ShortCodeRequest.class), examples={@ExampleObject(name="Request json example", value="example/webhook/trigger-webooks-request.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=AuiFeature.class), examples={@ExampleObject(name="Response json example", value="example/webhook/trigger-webooks-response.json")})}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))})})
    @POST
    @Path(value="/trigger/{featureId}")
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/webhook.readonly"})
    @Produces(value={"application/json"})
    public Response triggerWebhook(@Parameter(description="Admin UI feature identifier") @PathParam(value="featureId") @NotNull String featureId, @Valid @NotNull List<ShortCodeRequest> shortCodes) {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Triggering all webhooks for Admin UI feature - featureId: {}", (Object)Util.escapeLog((Object)featureId));
            }
            HashSet featureIdSet = Sets.newHashSet();
            featureIdSet.add(featureId);
            List<AuiFeature> featureList = this.webhookService.getAuiFeaturesByIds(featureIdSet);
            if (CollectionUtils.isEmpty(featureList)) {
                this.log.error(ErrorResponse.WEBHOOK_RECORD_NOT_EXIST.getDescription());
                throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.WEBHOOK_RECORD_NOT_EXIST.getDescription());
            }
            AuiFeature featureObj = featureList.get(0);
            if (CollectionUtils.isEmpty(featureObj.getWebhookIdsMapped())) {
                this.log.error(ErrorResponse.NO_WEBHOOK_FOUND.getDescription());
                throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.NO_WEBHOOK_FOUND.getDescription());
            }
            List<GenericResponse> responseList = this.webhookService.triggerEnabledWebhooks(Sets.newHashSet(featureObj.getWebhookIdsMapped()), shortCodes);
            return Response.ok(responseList).build();
        }
        catch (ApplicationException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return Response.status((int)e.getErrorCode()).entity((Object)CommonUtils.createGenericResponse(false, e.getErrorCode(), e.getMessage())).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.FETCH_DATA_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.FETCH_DATA_ERROR.getDescription())).build();
        }
    }

    private PagedResult<WebhookEntry> doSearch(SearchRequest searchReq) throws ApplicationException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Webhook search params - searchReq:{} ", (Object)searchReq);
        }
        PagedResult<WebhookEntry> pagedResult = this.webhookService.searchWebhooks(searchReq);
        if (this.log.isTraceEnabled()) {
            this.log.trace("PagedResult  - pagedResult:{}", pagedResult);
        }
        if (pagedResult != null) {
            this.log.debug("Webhook fetched  - pagedResult.getTotalEntriesCount():{}, pagedResult.getEntriesCount():{}, pagedResult.getEntries():{}", new Object[]{pagedResult.getTotalEntriesCount(), pagedResult.getEntriesCount(), pagedResult.getEntries()});
        }
        this.log.debug("Webhook  - pagedResult:{}", pagedResult);
        return pagedResult;
    }
}

