/*
 * Decompiled with CFR 0.152.
 */
package io.jans.ca.plugin.adminui.service.webhook;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.jans.ca.plugin.adminui.model.auth.GenericResponse;
import io.jans.ca.plugin.adminui.model.exception.ApplicationException;
import io.jans.ca.plugin.adminui.model.webhook.WebhookEntry;
import io.jans.ca.plugin.adminui.utils.ClientFactory;
import io.jans.ca.plugin.adminui.utils.CommonUtils;
import io.jans.ca.plugin.adminui.utils.ErrorResponse;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;

public class WebhookCallable
implements Callable<GenericResponse> {
    private WebhookEntry webhook;
    Logger log;

    public WebhookCallable(WebhookEntry webhook, Logger log) {
        this.webhook = webhook;
        this.log = log;
    }

    @Override
    public GenericResponse call() throws ApplicationException {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode jsonNode = objectMapper.createObjectNode();
        try {
            this.log.debug("Webhook processing started. Id: {}. Name: {}, URL : {}, HttpMethod: {}", new Object[]{this.webhook.getInum(), this.webhook.getDisplayName(), this.webhook.getUrl(), this.webhook.getHttpMethod()});
            ClientFactory.instance();
            Invocation.Builder request = ClientFactory.getClientBuilder(this.webhook.getUrl());
            this.webhook.getHttpHeaders().stream().filter(Objects::nonNull).forEach(header -> request.header(header.getKey(), (Object)header.getValue()));
            Invocation invocation = this.checkHttpMethod(request);
            if (invocation == null) {
                this.log.error("Error in creating invocation object for rest call (Name: {}, Id: {})", (Object)this.webhook.getDisplayName(), (Object)this.webhook.getInum());
                return CommonUtils.createGenericResponse(false, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Error in creating invocation object for rest call (Name: " + this.webhook.getDisplayName() + ", Id: " + this.webhook.getInum() + ")");
            }
            Response response = invocation.invoke();
            this.log.debug("Webhook (Name: {}, Id: {}) response status code: {}", new Object[]{this.webhook.getDisplayName(), this.webhook.getInum(), response.getStatus()});
            jsonNode.put("webhookId", this.webhook.getInum());
            jsonNode.put("webhookName", this.webhook.getDisplayName());
            jsonNode.put("webhookMethod", this.webhook.getHttpMethod());
            if (Lists.newArrayList((Object[])new String[]{"POST", "PUT", "PATCH"}).contains(this.webhook.getHttpMethod())) {
                jsonNode.put("webhookRequestBody", this.webhook.getHttpRequestBody().toString());
            }
            if (response.getStatus() == Response.Status.OK.getStatusCode() || response.getStatus() == Response.Status.CREATED.getStatusCode() || response.getStatus() == Response.Status.ACCEPTED.getStatusCode()) {
                String responseData = (String)response.readEntity(String.class);
                this.log.debug("Webhook (Name: {}, Id: {}) responseData : {}", new Object[]{this.webhook.getDisplayName(), this.webhook.getInum(), responseData});
                return CommonUtils.createGenericResponse(true, response.getStatus(), responseData, (JsonNode)jsonNode);
            }
            String responseData = (String)response.readEntity(String.class);
            this.log.error("Webhook (Name: {}, Id: {}) responseData : {}", new Object[]{this.webhook.getDisplayName(), this.webhook.getInum(), responseData});
            return CommonUtils.createGenericResponse(false, response.getStatus(), responseData, (JsonNode)jsonNode);
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.WEBHOOK_TRIGGER_ERROR.getDescription(), (Throwable)e);
            jsonNode.put("webhookId", this.webhook.getInum());
            jsonNode.put("webhookName", this.webhook.getDisplayName());
            jsonNode.put("webhookMethod", this.webhook.getHttpMethod());
            if (Lists.newArrayList((Object[])new String[]{"POST", "PUT", "PATCH"}).contains(this.webhook.getHttpMethod())) {
                jsonNode.put("webhookRequestBody", this.webhook.getHttpRequestBody().toString());
            }
            return CommonUtils.createGenericResponse(false, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), e.getMessage(), (JsonNode)jsonNode);
        }
    }

    private Invocation checkHttpMethod(Invocation.Builder request) {
        Invocation invocation = null;
        switch (this.webhook.getHttpMethod().toUpperCase()) {
            case "GET": {
                invocation = request.buildGet();
                break;
            }
            case "DELETE": {
                invocation = request.buildDelete();
                break;
            }
            case "POST": 
            case "PUT": 
            case "PATCH": {
                if (MapUtils.isEmpty(this.webhook.getHttpRequestBody())) break;
                Map<String, Object> requestBody = this.setRequestBody(this.webhook);
                if (requestBody.isEmpty()) {
                    this.log.error("Webhook (Name: {}, Id: {}) . Error in parsing request-body or the request-body is empty.", (Object)this.webhook.getDisplayName(), (Object)this.webhook.getInum());
                }
                invocation = request.buildPost(Entity.entity(this.setRequestBody(this.webhook), (String)"application/json"));
                break;
            }
        }
        return invocation;
    }

    private Map<String, Object> setRequestBody(WebhookEntry webhook) {
        try {
            HashMap<String, Object> body = new HashMap<String, Object>();
            if (webhook.getHttpHeaders().stream().anyMatch(header -> header.getKey().equals("Content-Type"))) {
                Map<String, Object> reqBody = webhook.getHttpRequestBody();
                for (String key : reqBody.keySet()) {
                    body.put(key, reqBody.get(key));
                }
            }
            return body;
        }
        catch (Exception ex) {
            this.log.error("Error in parsing request-body.", (Throwable)ex);
            return Maps.newHashMap();
        }
    }
}

