/*
 * Decompiled with CFR 0.152.
 */
package io.jans.ca.plugin.adminui.rest.logging;

import io.jans.ca.plugin.adminui.utils.CommonUtils;
import io.jans.ca.plugin.adminui.utils.ErrorResponse;
import io.jans.configapi.core.rest.ProtectedApi;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import org.slf4j.Logger;

@Hidden
@Path(value="/admin-ui/logging")
public class AuditLoggerResource {
    public static final String AUDIT_LOGGING_WRITE_SCOPE = "https://jans.io/oauth/jans-auth-server/config/adminui/logging.write";
    static final String AUDIT = "/audit";
    @Inject
    Logger log;

    @POST
    @Path(value="/audit")
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/logging.write"})
    @Produces(value={"application/json"})
    public Response auditLogging(@Valid @NotNull Map<String, Object> loggingRequest) {
        try {
            this.log.info(loggingRequest.toString());
            return Response.ok((Object)"{'status': 'success'}").build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.AUDIT_LOGGING_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, 500, ErrorResponse.AUDIT_LOGGING_ERROR.getDescription())).build();
        }
    }
}

