/*
 * Decompiled with CFR 0.152.
 */
package io.jans.ca.plugin.adminui.service.license;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import io.jans.as.client.TokenRequest;
import io.jans.as.client.TokenResponse;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.config.adminui.AdminConf;
import io.jans.as.model.config.adminui.LicenseConfig;
import io.jans.as.model.config.adminui.OIDCClientSettings;
import io.jans.ca.plugin.adminui.model.auth.DCRResponse;
import io.jans.ca.plugin.adminui.model.auth.GenericResponse;
import io.jans.ca.plugin.adminui.model.auth.LicenseRequest;
import io.jans.ca.plugin.adminui.model.auth.LicenseResponse;
import io.jans.ca.plugin.adminui.model.auth.SSARequest;
import io.jans.ca.plugin.adminui.model.config.AUIConfiguration;
import io.jans.ca.plugin.adminui.model.config.LicenseConfiguration;
import io.jans.ca.plugin.adminui.service.BaseService;
import io.jans.ca.plugin.adminui.service.config.AUIConfigurationService;
import io.jans.ca.plugin.adminui.utils.ClientFactory;
import io.jans.ca.plugin.adminui.utils.CommonUtils;
import io.jans.ca.plugin.adminui.utils.ErrorResponse;
import io.jans.orm.PersistenceEntryManager;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Response;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Singleton
public class LicenseDetailsService
extends BaseService {
    @Inject
    Logger log;
    @Inject
    AUIConfigurationService auiConfigurationService;
    @Inject
    private PersistenceEntryManager entryManager;
    public static final String LICENSE_KEY = "licenseKey";
    public static final String HARDWARE_ID = "hardwareId";
    public static final String BEARER = "Bearer ";
    public static final String MESSAGE = "message";
    public static final String CODE = "code";
    public static final String LICENSE_ISACTIVE_ERROR_RESPONSE = "License isActive error response";
    public static final String LICENSE_RETRIEVE_ERROR_RESPONSE = "License retrieve error response";
    public static final String LICENSE_ACTIVATE_ERROR_RESPONSE = "License activate error response";
    public static final String LICENSE_APIS_404 = "The requested license apis not found. Response Code: 404";
    public static final String LICENSE_APIS_503 = "The requested license apis not available. Response Code: 503";
    public static final String TRIAL_GENERATE_ERROR_RESPONSE = "Generate Trial license error response";

    public GenericResponse validateLicenseConfiguration() {
        this.log.info("Inside validateLicenseConfiguration: the method to validate license configuration.");
        AdminConf appConf = (AdminConf)this.entryManager.find(AdminConf.class, (Object)"ou=admin-ui,ou=configuration,o=jans");
        LicenseConfig licenseConfiguration = appConf.getMainSettings().getLicenseConfig();
        if (licenseConfiguration == null || Strings.isNullOrEmpty((String)licenseConfiguration.getLicenseHardwareKey())) {
            this.log.error(ErrorResponse.LICENSE_CONFIG_ABSENT.getDescription());
            return CommonUtils.createGenericResponse(false, 500, ErrorResponse.LICENSE_CONFIG_ABSENT.getDescription());
        }
        if (Strings.isNullOrEmpty((String)licenseConfiguration.getOidcClient().getOpHost()) || Strings.isNullOrEmpty((String)licenseConfiguration.getOidcClient().getClientId()) || Strings.isNullOrEmpty((String)licenseConfiguration.getOidcClient().getClientSecret())) {
            this.log.error(ErrorResponse.LICENSE_OIDC_CLIENT_MISSING.getDescription());
            return CommonUtils.createGenericResponse(false, 500, ErrorResponse.LICENSE_OIDC_CLIENT_MISSING.getDescription());
        }
        if (Strings.isNullOrEmpty((String)licenseConfiguration.getSsa())) {
            this.log.error(ErrorResponse.LICENSE_SSA_MISSING.getDescription());
            return CommonUtils.createGenericResponse(false, 500, ErrorResponse.LICENSE_SSA_MISSING.getDescription());
        }
        if (Strings.isNullOrEmpty((String)licenseConfiguration.getLicenseKey())) {
            this.log.error(ErrorResponse.LICENSE_NOT_PRESENT.getDescription());
            return CommonUtils.createGenericResponse(false, 404, ErrorResponse.LICENSE_NOT_PRESENT.getDescription());
        }
        if (Strings.isNullOrEmpty((String)licenseConfiguration.getScanLicenseApiHostname())) {
            this.log.error(ErrorResponse.SCAN_HOSTNAME_MISSING.getDescription());
            return CommonUtils.createGenericResponse(false, 500, ErrorResponse.SCAN_HOSTNAME_MISSING.getDescription());
        }
        if (Strings.isNullOrEmpty((String)licenseConfiguration.getLicenseDetailsLastUpdatedOn())) {
            this.log.info(ErrorResponse.LICENSE_INFO_LAST_FETCHED_ON_ABSENT.getDescription());
            return this.syncLicenseOIDCClientDetails(licenseConfiguration);
        }
        long daysDiffOfLicenseDetailsLastUpdated = ChronoUnit.DAYS.between(CommonUtils.convertStringToLocalDate(licenseConfiguration.getLicenseDetailsLastUpdatedOn()), LocalDate.now());
        long intervalForSyncLicenseDetailsInDays = licenseConfiguration.getIntervalForSyncLicenseDetailsInDays() == null ? 30L : licenseConfiguration.getIntervalForSyncLicenseDetailsInDays();
        this.log.info("License details were last updated before {} days. The sync process will run after an interval of {} days.", (Object)daysDiffOfLicenseDetailsLastUpdated, (Object)intervalForSyncLicenseDetailsInDays);
        if (daysDiffOfLicenseDetailsLastUpdated > intervalForSyncLicenseDetailsInDays) {
            return this.syncLicenseOIDCClientDetails(licenseConfiguration);
        }
        if (!Strings.isNullOrEmpty((String)licenseConfiguration.getLicenseValidUpto())) {
            long daysDiffOfLicenseValidity = ChronoUnit.DAYS.between(LocalDate.now(), CommonUtils.convertStringToLocalDate(licenseConfiguration.getLicenseValidUpto()));
            this.log.info("License will expire after {} days", (Object)daysDiffOfLicenseValidity);
            if (daysDiffOfLicenseValidity < 0L) {
                return this.syncLicenseOIDCClientDetails(licenseConfiguration);
            }
        }
        return CommonUtils.createGenericResponse(true, 200, "No error in license configuration.");
    }

    private GenericResponse syncLicenseOIDCClientDetails(LicenseConfig licenseConfig) {
        this.log.info("Inside syncLicenseOIDCClientDetails: the method to sync OIDC client details used to access License API on Agama Lab.");
        this.log.info("Requesting for access token from {}", (Object)licenseConfig.getOidcClient().getOpHost());
        TokenResponse tokenResponse = this.generateToken(licenseConfig.getOidcClient().getOpHost(), licenseConfig.getOidcClient().getClientId(), licenseConfig.getOidcClient().getClientSecret());
        if (tokenResponse == null || Strings.isNullOrEmpty((String)tokenResponse.getAccessToken())) {
            this.log.info("Unable to get access token from {}", (Object)licenseConfig.getOidcClient().getOpHost());
            DCRResponse dcrResponse = this.executeDCR(licenseConfig.getSsa());
            if (dcrResponse == null) {
                return CommonUtils.createGenericResponse(false, 500, ErrorResponse.ERROR_IN_DCR.getDescription());
            }
            try {
                this.saveCreateClientInPersistence(licenseConfig.getSsa(), dcrResponse);
            }
            catch (Exception e) {
                return CommonUtils.createGenericResponse(false, 500, ErrorResponse.ERROR_IN_SAVING_LICENSE_CLIENT.getDescription());
            }
            this.log.info("Requesting again for access token from {}", (Object)licenseConfig.getOidcClient().getOpHost());
            tokenResponse = this.generateToken(licenseConfig.getOidcClient().getOpHost(), licenseConfig.getOidcClient().getClientId(), licenseConfig.getOidcClient().getClientSecret());
            if (tokenResponse == null) {
                this.log.info("Unable to get access token from {}", (Object)licenseConfig.getOidcClient().getOpHost());
                return CommonUtils.createGenericResponse(false, 500, ErrorResponse.TOKEN_GENERATION_ERROR.getDescription());
            }
        }
        return CommonUtils.createGenericResponse(true, 200, "No error in license configuration.");
    }

    public GenericResponse deleteLicenseConfiguration() throws Exception {
        this.log.info("Deleting Admin UI license configuration.");
        AdminConf appConf = (AdminConf)this.entryManager.find(AdminConf.class, (Object)"ou=admin-ui,ou=configuration,o=jans");
        appConf.getMainSettings().setLicenseConfig(new LicenseConfig());
        this.entryManager.merge((Object)appConf);
        AUIConfiguration auiConfiguration = this.auiConfigurationService.getAUIConfiguration();
        auiConfiguration.setLicenseConfiguration(new LicenseConfiguration());
        this.auiConfigurationService.setAuiConfiguration(auiConfiguration);
        return CommonUtils.createGenericResponse(true, 200, "Admin UI license configuration reset successfully.");
    }

    public GenericResponse checkLicense() {
        this.log.info("Inside checkLicense: the method to check if License details are valid.");
        try {
            AUIConfiguration auiConfiguration = this.auiConfigurationService.getAUIConfiguration();
            LicenseConfiguration licenseConfiguration = auiConfiguration.getLicenseConfiguration();
            if (licenseConfiguration == null || Strings.isNullOrEmpty((String)licenseConfiguration.getHardwareId())) {
                this.log.error(ErrorResponse.LICENSE_CONFIG_ABSENT.getDescription());
                return CommonUtils.createGenericResponse(false, 500, ErrorResponse.LICENSE_CONFIG_ABSENT.getDescription());
            }
            if (Strings.isNullOrEmpty((String)licenseConfiguration.getLicenseKey())) {
                this.log.info(ErrorResponse.LICENSE_NOT_PRESENT.getDescription());
                return CommonUtils.createGenericResponse(false, 404, ErrorResponse.LICENSE_NOT_PRESENT.getDescription());
            }
            if (Strings.isNullOrEmpty((String)licenseConfiguration.getScanApiHostname())) {
                this.log.error(ErrorResponse.SCAN_HOSTNAME_MISSING.getDescription());
                return CommonUtils.createGenericResponse(false, 500, ErrorResponse.SCAN_HOSTNAME_MISSING.getDescription());
            }
            if (Strings.isNullOrEmpty((String)licenseConfiguration.getLicenseValidUpto())) {
                this.log.info(ErrorResponse.LICENSE_EXPIRY_DATE_NOT_PRESENT.getDescription());
                return this.syncLicenseDetailsFromAgamaLab(auiConfiguration);
            }
            if (Strings.isNullOrEmpty((String)licenseConfiguration.getLicenseDetailsLastUpdatedOn())) {
                this.log.info(ErrorResponse.LICENSE_INFO_LAST_FETCHED_ON_ABSENT.getDescription());
                return this.syncLicenseDetailsFromAgamaLab(auiConfiguration);
            }
            long daysDiffOfLicenseDetailsLastUpdated = ChronoUnit.DAYS.between(CommonUtils.convertStringToLocalDate(licenseConfiguration.getLicenseDetailsLastUpdatedOn()), LocalDate.now());
            long intervalForSyncLicenseDetailsInDays = licenseConfiguration.getIntervalForSyncLicenseDetailsInDays() == null ? 30L : licenseConfiguration.getIntervalForSyncLicenseDetailsInDays();
            this.log.info("License details were last updated before {} days. The sync process will run after an interval of {} days.", (Object)daysDiffOfLicenseDetailsLastUpdated, (Object)intervalForSyncLicenseDetailsInDays);
            if (daysDiffOfLicenseDetailsLastUpdated > intervalForSyncLicenseDetailsInDays) {
                return this.syncLicenseDetailsFromAgamaLab(auiConfiguration);
            }
            long daysDiffOfLicenseValidity = ChronoUnit.DAYS.between(LocalDate.now(), CommonUtils.convertStringToLocalDate(licenseConfiguration.getLicenseValidUpto()));
            this.log.info("License will expire after {} days", (Object)daysDiffOfLicenseValidity);
            if (daysDiffOfLicenseValidity < 0L) {
                return this.syncLicenseDetailsFromAgamaLab(auiConfiguration);
            }
            if (licenseConfiguration.getLicenseMAUThreshold() == null) {
                this.log.error(ErrorResponse.MAU_IS_NULL.getDescription());
                return CommonUtils.createGenericResponse(false, 500, ErrorResponse.MAU_IS_NULL.getDescription());
            }
            ObjectMapper mapper = new ObjectMapper();
            JsonArray customAttributes = Json.createArrayBuilder().add(Json.createObjectBuilder().add("name", "mau_threshold").add("value", licenseConfiguration.getLicenseMAUThreshold().longValue())).build();
            return CommonUtils.createGenericResponse(true, 200, "Valid license present.", mapper.readTree(customAttributes.toString()));
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.CHECK_LICENSE_ERROR.getDescription(), (Throwable)e);
            return CommonUtils.createGenericResponse(false, 500, ErrorResponse.CHECK_LICENSE_ERROR.getDescription());
        }
    }

    private GenericResponse syncLicenseDetailsFromAgamaLab(AUIConfiguration auiConfiguration) {
        this.log.info("Inside syncLicenseDetailsFromAgamaLab: the method to sync license details from Agama lab");
        Response response = null;
        try {
            LicenseConfiguration licenseConfiguration = auiConfiguration.getLicenseConfiguration();
            String checkLicenseUrl = new StringBuffer().append(this.formatApiUrl(licenseConfiguration.getScanApiHostname(), "/isActive")).toString();
            TokenResponse tokenResponse = this.generateToken(licenseConfiguration.getScanAuthServerHostname(), licenseConfiguration.getScanApiClientId(), licenseConfiguration.getScanApiClientSecret());
            if (tokenResponse == null) {
                this.log.info(ErrorResponse.TOKEN_GENERATION_ERROR.getDescription());
                return CommonUtils.createGenericResponse(false, 500, ErrorResponse.TOKEN_GENERATION_ERROR.getDescription());
            }
            HashMap<String, String> body = new HashMap<String, String>();
            body.put(LICENSE_KEY, licenseConfiguration.getLicenseKey());
            body.put(HARDWARE_ID, licenseConfiguration.getHardwareId());
            ClientFactory.instance();
            Invocation.Builder request = ClientFactory.getClientBuilder(checkLicenseUrl);
            request.header("Authorization", (Object)(BEARER + tokenResponse.getAccessToken()));
            request.header("Content-Type", (Object)"application/json");
            response = request.post(Entity.entity(body, (String)"application/json"));
            this.log.info("license request status code: {}", (Object)response.getStatus());
            ObjectMapper mapper = new ObjectMapper();
            if (response.getStatus() == 200) {
                JsonObject entity = (JsonObject)response.readEntity(JsonObject.class);
                Optional<GenericResponse> genericResOptional = this.handleMissingFieldsInResponse(entity, ErrorResponse.LICENSE_DATA_MISSING.getDescription(), "license_active", "is_expired");
                if (genericResOptional.isPresent()) {
                    return genericResOptional.get();
                }
                if (!entity.getBoolean("license_active")) {
                    return CommonUtils.createGenericResponse(false, 404, ErrorResponse.LICENSE_NOT_PRESENT.getDescription());
                }
                if (entity.getBoolean("is_expired")) {
                    return CommonUtils.createGenericResponse(false, 500, ErrorResponse.LICENSE_IS_EXPIRED.getDescription());
                }
                this.setToLicenseConfiguration(entity, licenseConfiguration);
                AdminConf adminConf = (AdminConf)this.entryManager.find(AdminConf.class, (Object)"ou=admin-ui,ou=configuration,o=jans");
                adminConf.getMainSettings().getLicenseConfig().setLicenseKey(licenseConfiguration.getLicenseKey());
                adminConf.getMainSettings().getLicenseConfig().setLicenseExpired(licenseConfiguration.getLicenseExpired());
                adminConf.getMainSettings().getLicenseConfig().setLicenseActive(licenseConfiguration.getLicenseActive());
                adminConf.getMainSettings().getLicenseConfig().setLicenseType(licenseConfiguration.getLicenseType());
                adminConf.getMainSettings().getLicenseConfig().setLicenseDetailsLastUpdatedOn(licenseConfiguration.getLicenseDetailsLastUpdatedOn());
                adminConf.getMainSettings().getLicenseConfig().setLicenseValidUpto(licenseConfiguration.getLicenseValidUpto());
                adminConf.getMainSettings().getLicenseConfig().setProductName(licenseConfiguration.getProductName());
                adminConf.getMainSettings().getLicenseConfig().setProductCode(licenseConfiguration.getProductCode());
                adminConf.getMainSettings().getLicenseConfig().setCompanyName(licenseConfiguration.getCompanyName());
                adminConf.getMainSettings().getLicenseConfig().setCustomerEmail(licenseConfiguration.getCustomerEmail());
                adminConf.getMainSettings().getLicenseConfig().setCustomerFirstName(licenseConfiguration.getCustomerFirstName());
                adminConf.getMainSettings().getLicenseConfig().setCustomerLastName(licenseConfiguration.getCustomerLastName());
                adminConf.getMainSettings().getLicenseConfig().setLicenseMAUThreshold(licenseConfiguration.getLicenseMAUThreshold());
                if (adminConf.getMainSettings().getLicenseConfig().getIntervalForSyncLicenseDetailsInDays() == null) {
                    adminConf.getMainSettings().getLicenseConfig().setIntervalForSyncLicenseDetailsInDays(Long.valueOf(30L));
                }
                this.entryManager.merge((Object)adminConf);
                auiConfiguration.setLicenseConfiguration(licenseConfiguration);
                this.auiConfigurationService.setAuiConfiguration(auiConfiguration);
                return CommonUtils.createGenericResponse(true, 200, "Valid license present.", mapper.readTree(entity.getJsonArray("custom_fields").toString()));
            }
            String jsonData = (String)response.readEntity(String.class);
            JsonNode jsonNode = (JsonNode)mapper.readValue(jsonData, JsonNode.class);
            if (!Strings.isNullOrEmpty((String)jsonNode.get(MESSAGE).textValue())) {
                this.log.error("{}: {}", (Object)LICENSE_ISACTIVE_ERROR_RESPONSE, (Object)jsonData);
                return CommonUtils.createGenericResponse(false, jsonNode.get(CODE).intValue(), jsonNode.get(MESSAGE).textValue());
            }
            this.log.error("{}: {}", (Object)LICENSE_ISACTIVE_ERROR_RESPONSE, (Object)jsonData);
            return CommonUtils.createGenericResponse(false, 404, ErrorResponse.LICENSE_NOT_PRESENT.getDescription());
        }
        catch (Exception e) {
            Optional<GenericResponse> genericResOptional = this.handleLicenseApiNotAccessible(response);
            if (genericResOptional.isPresent()) {
                return genericResOptional.get();
            }
            this.log.error(ErrorResponse.CHECK_LICENSE_ERROR.getDescription(), (Throwable)e);
            return CommonUtils.createGenericResponse(false, 500, ErrorResponse.CHECK_LICENSE_ERROR.getDescription());
        }
    }

    public GenericResponse retrieveLicense() {
        Response response = null;
        try {
            AUIConfiguration auiConfiguration = this.auiConfigurationService.getAUIConfiguration();
            LicenseConfiguration licenseConfiguration = auiConfiguration.getLicenseConfiguration();
            if (licenseConfiguration == null || Strings.isNullOrEmpty((String)licenseConfiguration.getHardwareId())) {
                this.log.error(ErrorResponse.LICENSE_CONFIG_ABSENT.getDescription());
                return CommonUtils.createGenericResponse(false, 500, ErrorResponse.LICENSE_CONFIG_ABSENT.getDescription());
            }
            if (Strings.isNullOrEmpty((String)licenseConfiguration.getScanApiHostname())) {
                this.log.error(ErrorResponse.SCAN_HOSTNAME_MISSING.getDescription());
                return CommonUtils.createGenericResponse(false, 500, ErrorResponse.SCAN_HOSTNAME_MISSING.getDescription());
            }
            TokenResponse tokenResponse = this.generateToken(licenseConfiguration.getScanAuthServerHostname(), licenseConfiguration.getScanApiClientId(), licenseConfiguration.getScanApiClientSecret());
            if (tokenResponse == null) {
                this.log.info(ErrorResponse.TOKEN_GENERATION_ERROR.getDescription());
                return CommonUtils.createGenericResponse(false, 500, ErrorResponse.TOKEN_GENERATION_ERROR.getDescription());
            }
            String retriveLicenseUrl = new StringBuffer().append(this.formatApiUrl(licenseConfiguration.getScanApiHostname(), "/retrieve?org_id=") + licenseConfiguration.getHardwareId()).toString();
            ClientFactory.instance();
            Invocation.Builder request = ClientFactory.getClientBuilder(retriveLicenseUrl);
            request.header("Authorization", (Object)(BEARER + tokenResponse.getAccessToken()));
            response = request.get();
            this.log.info("license request status code: {}", (Object)response.getStatus());
            ObjectMapper mapper = new ObjectMapper();
            if (response.getStatus() == 200) {
                JsonObject entity = (JsonObject)response.readEntity(JsonObject.class);
                ObjectNode jsonNode = mapper.createObjectNode();
                Optional<GenericResponse> genericResOptional = this.handleMissingFieldsInResponse(entity, ErrorResponse.LICENSE_DATA_MISSING.getDescription(), LICENSE_KEY, "mauThreshold");
                if (genericResOptional.isPresent()) {
                    return genericResOptional.get();
                }
                jsonNode.put(LICENSE_KEY, entity.getString(LICENSE_KEY));
                jsonNode.put("mauThreshold", entity.getInt("mauThreshold"));
                return CommonUtils.createGenericResponse(true, 200, "Valid license present.", (JsonNode)jsonNode);
            }
            String jsonData = (String)response.readEntity(String.class);
            JsonNode jsonNode = (JsonNode)mapper.readValue(jsonData, JsonNode.class);
            if (response.getStatus() == 402) {
                this.log.error("Payment Required: 402");
                return CommonUtils.createGenericResponse(false, 402, "Payment Required. Subscribe Admin UI license on Agama Lab.");
            }
            if (!Strings.isNullOrEmpty((String)jsonNode.get(MESSAGE).textValue())) {
                this.log.error("{}: {}", (Object)LICENSE_RETRIEVE_ERROR_RESPONSE, (Object)jsonData);
                return CommonUtils.createGenericResponse(false, jsonNode.get(CODE).intValue(), jsonNode.get(MESSAGE).textValue());
            }
            this.log.error("{}: {}", (Object)LICENSE_RETRIEVE_ERROR_RESPONSE, (Object)jsonData);
            return CommonUtils.createGenericResponse(false, 500, ErrorResponse.RETRIEVE_LICENSE_ERROR.getDescription());
        }
        catch (Exception e) {
            Optional<GenericResponse> genericResOptional = this.handleLicenseApiNotAccessible(response);
            if (genericResOptional.isPresent()) {
                return genericResOptional.get();
            }
            this.log.error(ErrorResponse.CHECK_LICENSE_ERROR.getDescription(), (Throwable)e);
            return CommonUtils.createGenericResponse(false, 500, ErrorResponse.RETRIEVE_LICENSE_ERROR.getDescription());
        }
    }

    public GenericResponse activateLicense(LicenseRequest licenseRequest) {
        GenericResponse licenseApiResponse = this.checkLicense();
        if (licenseApiResponse.isSuccess()) {
            return CommonUtils.createGenericResponse(true, 200, ErrorResponse.LICENSE_ALREADY_ACTIVE.getDescription());
        }
        Response response = null;
        try {
            AUIConfiguration auiConfiguration = this.auiConfigurationService.getAUIConfiguration();
            LicenseConfiguration licenseConfiguration = auiConfiguration.getLicenseConfiguration();
            this.log.debug("Trying to activate License.");
            String activateLicenseUrl = new StringBuffer().append(this.formatApiUrl(licenseConfiguration.getScanApiHostname(), "/activate")).toString();
            TokenResponse tokenResponse = this.generateToken(licenseConfiguration.getScanAuthServerHostname(), licenseConfiguration.getScanApiClientId(), licenseConfiguration.getScanApiClientSecret());
            if (tokenResponse == null) {
                this.log.info(ErrorResponse.TOKEN_GENERATION_ERROR.getDescription());
                return CommonUtils.createGenericResponse(false, 500, ErrorResponse.TOKEN_GENERATION_ERROR.getDescription());
            }
            HashMap<String, String> body = new HashMap<String, String>();
            body.put(LICENSE_KEY, licenseRequest.getLicenseKey());
            body.put(HARDWARE_ID, licenseConfiguration.getHardwareId());
            ClientFactory.instance();
            Invocation.Builder request = ClientFactory.getClientBuilder(activateLicenseUrl);
            request.header("Authorization", (Object)(BEARER + tokenResponse.getAccessToken()));
            request.header("Content-Type", (Object)"application/json");
            response = request.post(Entity.entity(body, (String)"application/json"));
            this.log.info("license Activation request status code: {}", (Object)response.getStatus());
            ObjectMapper mapper = new ObjectMapper();
            if (response.getStatus() == 200) {
                JsonObject entity = (JsonObject)response.readEntity(JsonObject.class);
                Optional<GenericResponse> genericResOptional = this.handleMissingFieldsInResponse(entity, ErrorResponse.LICENSE_DATA_MISSING.getDescription(), "license_key");
                if (genericResOptional.isPresent()) {
                    return genericResOptional.get();
                }
                this.setToLicenseConfiguration(entity, licenseConfiguration);
                AdminConf adminConf = (AdminConf)this.entryManager.find(AdminConf.class, (Object)"ou=admin-ui,ou=configuration,o=jans");
                adminConf.getMainSettings().getLicenseConfig().setLicenseKey(licenseConfiguration.getLicenseKey());
                adminConf.getMainSettings().getLicenseConfig().setLicenseExpired(licenseConfiguration.getLicenseExpired());
                adminConf.getMainSettings().getLicenseConfig().setLicenseActive(licenseConfiguration.getLicenseActive());
                adminConf.getMainSettings().getLicenseConfig().setLicenseType(licenseConfiguration.getLicenseType());
                adminConf.getMainSettings().getLicenseConfig().setLicenseDetailsLastUpdatedOn(licenseConfiguration.getLicenseDetailsLastUpdatedOn());
                adminConf.getMainSettings().getLicenseConfig().setLicenseValidUpto(licenseConfiguration.getLicenseValidUpto());
                adminConf.getMainSettings().getLicenseConfig().setProductName(licenseConfiguration.getProductName());
                adminConf.getMainSettings().getLicenseConfig().setProductCode(licenseConfiguration.getProductCode());
                adminConf.getMainSettings().getLicenseConfig().setCompanyName(licenseConfiguration.getCompanyName());
                adminConf.getMainSettings().getLicenseConfig().setCustomerEmail(licenseConfiguration.getCustomerEmail());
                adminConf.getMainSettings().getLicenseConfig().setCustomerFirstName(licenseConfiguration.getCustomerFirstName());
                adminConf.getMainSettings().getLicenseConfig().setCustomerLastName(licenseConfiguration.getCustomerLastName());
                adminConf.getMainSettings().getLicenseConfig().setLicenseMAUThreshold(licenseConfiguration.getLicenseMAUThreshold());
                this.entryManager.merge((Object)adminConf);
                auiConfiguration.setLicenseConfiguration(licenseConfiguration);
                this.auiConfigurationService.setAuiConfiguration(auiConfiguration);
                return CommonUtils.createGenericResponse(true, 200, "License have been activated.", mapper.readTree(entity.getJsonArray("custom_fields").toString()));
            }
            String jsonData = (String)response.readEntity(String.class);
            JsonNode jsonNode = (JsonNode)mapper.readValue(jsonData, JsonNode.class);
            if (!Strings.isNullOrEmpty((String)jsonNode.get(MESSAGE).textValue())) {
                this.log.error("license Activation error response: {}", (Object)jsonData);
                this.log.error("{}: {}", (Object)LICENSE_ACTIVATE_ERROR_RESPONSE, (Object)jsonData);
                return CommonUtils.createGenericResponse(false, jsonNode.get(CODE).intValue(), jsonNode.get(MESSAGE).textValue());
            }
            this.log.error("license Activation error response: {}", (Object)jsonData);
            this.log.error("{}: {}", (Object)LICENSE_ACTIVATE_ERROR_RESPONSE, (Object)jsonData);
            return CommonUtils.createGenericResponse(false, response.getStatus(), "License is not activated.");
        }
        catch (Exception e) {
            Optional<GenericResponse> genericResOptional = this.handleLicenseApiNotAccessible(response);
            if (genericResOptional.isPresent()) {
                return genericResOptional.get();
            }
            this.log.error(ErrorResponse.ACTIVATE_LICENSE_ERROR.getDescription(), (Throwable)e);
            return CommonUtils.createGenericResponse(false, 500, ErrorResponse.ACTIVATE_LICENSE_ERROR.getDescription());
        }
    }

    private void setToLicenseConfiguration(JsonObject entity, LicenseConfiguration licenseConfiguration) throws RuntimeException {
        try {
            this.log.info("Inside setToLicenseConfiguration: the method to set licence configuration");
            licenseConfiguration.setLicenseKey(entity.getString("license_key"));
            licenseConfiguration.setLicenseType(entity.getString("license_type"));
            licenseConfiguration.setLicenseDetailsLastUpdatedOn(CommonUtils.convertLocalDateToString(LocalDate.now()));
            licenseConfiguration.setLicenseValidUpto(CommonUtils.convertIsoToDateString(entity.getString("validity_period")));
            licenseConfiguration.setProductName(entity.getJsonObject("product_details").getString("product_name"));
            licenseConfiguration.setProductCode(entity.getJsonObject("product_details").getString("short_code"));
            JsonObject customer = entity.getJsonObject("customer");
            if (customer != null) {
                if (customer.get((Object)"company_name") != null) {
                    licenseConfiguration.setCompanyName(customer.getString("company_name"));
                }
                if (customer.get((Object)"email") != null) {
                    licenseConfiguration.setCustomerEmail(customer.getString("email"));
                }
                if (customer.get((Object)"first_name") != null) {
                    licenseConfiguration.setCustomerFirstName(customer.getString("first_name"));
                }
                if (customer.get((Object)"last_name") != null) {
                    licenseConfiguration.setCustomerLastName(customer.getString("last_name"));
                }
            }
            licenseConfiguration.setLicenseDetailsLastUpdatedOn(CommonUtils.convertLocalDateToString(LocalDate.now()));
            JsonArray customFields = entity.getJsonArray("custom_fields");
            Long mauThresholdValue = null;
            for (JsonObject obj : customFields.getValuesAs(JsonObject.class)) {
                if (!"mau_threshold".equals(obj.getString("name"))) continue;
                this.log.info(obj.getString("name"));
                this.log.info(obj.getString("value"));
                mauThresholdValue = Long.valueOf(!Strings.isNullOrEmpty((String)obj.getString("value")) ? obj.getString("value") : "0");
                break;
            }
            licenseConfiguration.setLicenseMAUThreshold(mauThresholdValue);
            try {
                licenseConfiguration.setLicenseExpired(entity.getBoolean("is_expired"));
                licenseConfiguration.setLicenseActive(entity.getBoolean("license_active"));
            }
            catch (Exception ex) {
                licenseConfiguration.setLicenseExpired(false);
                licenseConfiguration.setLicenseActive(entity.getBoolean("active"));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Error in setting licence configuration from persistence", ex);
        }
    }

    public GenericResponse generateTrialLicense() {
        this.log.info("Inside generateTrialLicense: the method to generate trial license");
        Response response = null;
        try {
            AUIConfiguration auiConfiguration = this.auiConfigurationService.getAUIConfiguration();
            LicenseConfiguration licenseConfiguration = auiConfiguration.getLicenseConfiguration();
            this.log.debug("Trying to generate trial License.");
            String trialLicenseUrl = new StringBuffer().append(this.formatApiUrl(licenseConfiguration.getScanApiHostname(), "/trial")).toString();
            TokenResponse tokenResponse = this.generateToken(licenseConfiguration.getScanAuthServerHostname(), licenseConfiguration.getScanApiClientId(), licenseConfiguration.getScanApiClientSecret());
            if (tokenResponse == null) {
                this.log.info(ErrorResponse.TOKEN_GENERATION_ERROR.getDescription());
                return CommonUtils.createGenericResponse(false, 500, ErrorResponse.TOKEN_GENERATION_ERROR.getDescription());
            }
            HashMap<String, String> body = new HashMap<String, String>();
            body.put(HARDWARE_ID, licenseConfiguration.getHardwareId());
            ClientFactory.instance();
            Invocation.Builder request = ClientFactory.getClientBuilder(trialLicenseUrl);
            request.header("Authorization", (Object)(BEARER + tokenResponse.getAccessToken()));
            request.header("Content-Type", (Object)"application/json");
            response = request.post(Entity.entity(body, (String)"application/json"));
            this.log.info("Generate trial license request status code: {}", (Object)response.getStatus());
            ObjectMapper objectMapper = new ObjectMapper();
            if (response.getStatus() == 200) {
                JsonObject entity = (JsonObject)response.readEntity(JsonObject.class);
                Optional<GenericResponse> genericResOptional = this.handleMissingFieldsInResponse(entity, ErrorResponse.LICENSE_DATA_MISSING.getDescription(), "license");
                if (genericResOptional.isPresent()) {
                    return genericResOptional.get();
                }
                AdminConf adminConf = (AdminConf)this.entryManager.find(AdminConf.class, (Object)"ou=admin-ui,ou=configuration,o=jans");
                adminConf.getMainSettings().getLicenseConfig().setLicenseKey(entity.getString("license"));
                this.entryManager.merge((Object)adminConf);
                licenseConfiguration.setLicenseKey(entity.getString("license"));
                auiConfiguration.setLicenseConfiguration(licenseConfiguration);
                this.auiConfigurationService.setAuiConfiguration(auiConfiguration);
                ObjectNode jsonNode = objectMapper.createObjectNode();
                jsonNode.put("license-key", entity.getString("license"));
                return CommonUtils.createGenericResponse(true, 200, "Trial license generated.", (JsonNode)jsonNode);
            }
            String jsonData = (String)response.readEntity(String.class);
            JsonNode jsonNode = (JsonNode)objectMapper.readValue(jsonData, JsonNode.class);
            if (!Strings.isNullOrEmpty((String)jsonNode.get(MESSAGE).textValue())) {
                this.log.error("{}: {}", (Object)TRIAL_GENERATE_ERROR_RESPONSE, (Object)jsonData);
                return CommonUtils.createGenericResponse(false, jsonNode.get(CODE).intValue(), jsonNode.get(MESSAGE).textValue());
            }
            this.log.error("{}: {}", (Object)TRIAL_GENERATE_ERROR_RESPONSE, (Object)jsonData);
            return CommonUtils.createGenericResponse(false, response.getStatus(), "Error in generating trial license.");
        }
        catch (Exception e) {
            Optional<GenericResponse> genericResOptional = this.handleLicenseApiNotAccessible(response);
            if (genericResOptional.isPresent()) {
                return genericResOptional.get();
            }
            this.log.error(ErrorResponse.ERROR_IN_TRIAL_LICENSE.getDescription(), (Throwable)e);
            return CommonUtils.createGenericResponse(false, 500, ErrorResponse.ERROR_IN_TRIAL_LICENSE.getDescription());
        }
    }

    public LicenseResponse getLicenseDetails() {
        this.log.info("Inside getLicenseDetails: the method to get license details");
        LicenseResponse licenseResponse = new LicenseResponse();
        try {
            AUIConfiguration auiConfiguration = this.auiConfigurationService.getAUIConfiguration();
            LicenseConfiguration licenseConfiguration = auiConfiguration.getLicenseConfiguration();
            if (licenseConfiguration == null || Strings.isNullOrEmpty((String)licenseConfiguration.getHardwareId())) {
                this.log.error(ErrorResponse.LICENSE_CONFIG_ABSENT.getDescription());
                licenseResponse.setLicenseEnabled(false);
                return licenseResponse;
            }
            if (Strings.isNullOrEmpty((String)licenseConfiguration.getLicenseKey())) {
                this.log.info(ErrorResponse.LICENSE_NOT_PRESENT.getDescription());
                licenseResponse.setLicenseEnabled(false);
                return licenseResponse;
            }
            if (!licenseConfiguration.getLicenseActive().booleanValue()) {
                this.log.info(ErrorResponse.LICENSE_NOT_PRESENT.getDescription());
                licenseResponse.setLicenseEnabled(false);
                return licenseResponse;
            }
            this.log.debug("Active license for admin-ui found : {}", (Object)licenseConfiguration.getProductName());
            licenseResponse.setLicenseEnabled(licenseConfiguration.getLicenseActive());
            licenseResponse.setProductName(licenseConfiguration.getProductName());
            licenseResponse.setProductCode(licenseConfiguration.getProductCode());
            licenseResponse.setLicenseType(licenseConfiguration.getLicenseType());
            licenseResponse.setLicenseMAUThreshold(licenseConfiguration.getLicenseMAUThreshold());
            licenseResponse.setLicenseKey(licenseConfiguration.getLicenseKey());
            licenseResponse.setValidityPeriod(licenseConfiguration.getLicenseValidUpto());
            licenseResponse.setLicenseActive(licenseConfiguration.getLicenseActive());
            licenseResponse.setLicenseExpired(licenseConfiguration.getLicenseExpired());
            licenseResponse.setCompanyName(licenseConfiguration.getCompanyName());
            licenseResponse.setCustomerEmail(licenseConfiguration.getCustomerEmail());
            licenseResponse.setCustomerFirstName(licenseConfiguration.getCustomerFirstName());
            licenseResponse.setCustomerLastName(licenseConfiguration.getCustomerLastName());
            return licenseResponse;
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.GET_LICENSE_DETAILS_ERROR.getDescription(), (Throwable)e);
            licenseResponse.setLicenseEnabled(false);
            return licenseResponse;
        }
    }

    public GenericResponse postSSA(SSARequest ssaRequest) {
        try {
            DCRResponse dcrResponse = this.executeDCR(ssaRequest.getSsa());
            if (dcrResponse == null) {
                return CommonUtils.createGenericResponse(false, 500, ErrorResponse.ERROR_IN_DCR.getDescription());
            }
            this.saveCreateClientInPersistence(ssaRequest.getSsa(), dcrResponse);
            return CommonUtils.createGenericResponse(true, 201, "SSA saved successfully.");
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.CHECK_LICENSE_ERROR.getDescription(), (Throwable)e);
            return CommonUtils.createGenericResponse(false, 500, ErrorResponse.ERROR_IN_DCR.getDescription());
        }
    }

    private void saveCreateClientInPersistence(String ssa, DCRResponse dcrResponse) throws Exception {
        AdminConf appConf = (AdminConf)this.entryManager.find(AdminConf.class, (Object)"ou=admin-ui,ou=configuration,o=jans");
        LicenseConfig licenseConfig = appConf.getMainSettings().getLicenseConfig();
        licenseConfig.setSsa(ssa);
        licenseConfig.setScanLicenseApiHostname(dcrResponse.getScanHostname());
        licenseConfig.setLicenseHardwareKey(dcrResponse.getHardwareId());
        OIDCClientSettings oidcClient = new OIDCClientSettings(dcrResponse.getOpHost(), dcrResponse.getClientId(), dcrResponse.getClientSecret());
        licenseConfig.setOidcClient(oidcClient);
        appConf.getMainSettings().setLicenseConfig(licenseConfig);
        this.entryManager.merge((Object)appConf);
        AUIConfiguration auiConfiguration = this.auiConfigurationService.getAUIConfiguration();
        LicenseConfiguration licenseConfiguration = auiConfiguration.getLicenseConfiguration();
        if (licenseConfiguration == null) {
            licenseConfiguration = new LicenseConfiguration();
        }
        licenseConfiguration.setScanAuthServerHostname(dcrResponse.getOpHost());
        licenseConfiguration.setScanApiClientId(dcrResponse.getClientId());
        licenseConfiguration.setScanApiClientSecret(dcrResponse.getClientSecret());
        licenseConfiguration.setHardwareId(dcrResponse.getHardwareId());
        licenseConfiguration.setScanApiHostname(dcrResponse.getScanHostname());
        auiConfiguration.setLicenseConfiguration(licenseConfiguration);
        this.auiConfigurationService.setAuiConfiguration(auiConfiguration);
    }

    private TokenResponse generateToken(String opHost, String clientId, String clientSecret) {
        try {
            TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
            tokenRequest.setAuthUsername(clientId);
            tokenRequest.setAuthPassword(clientSecret);
            tokenRequest.setGrantType(GrantType.CLIENT_CREDENTIALS);
            tokenRequest.setScope("https://jans.io/oauth/jans-auth-server/config/adminui/license.readonly");
            this.log.info("Trying to get access token from auth server.");
            String scanLicenseApiHostname = new StringBuffer().append(StringUtils.removeEnd((String)opHost, (String)"/")).append("/jans-auth/restv1/token").toString();
            TokenResponse tokenResponse = null;
            tokenResponse = this.getToken(tokenRequest, scanLicenseApiHostname);
            return tokenResponse;
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.TOKEN_GENERATION_ERROR.getDescription());
            return null;
        }
    }

    private Optional<GenericResponse> handleLicenseApiNotAccessible(Response response) {
        if (response.getStatus() == 404) {
            this.log.error("{}", (Object)LICENSE_APIS_404);
            return Optional.of(CommonUtils.createGenericResponse(false, response.getStatus(), LICENSE_APIS_404));
        }
        if (response.getStatus() == 503) {
            this.log.error("{}", (Object)LICENSE_APIS_503);
            return Optional.of(CommonUtils.createGenericResponse(false, response.getStatus(), LICENSE_APIS_503));
        }
        return Optional.empty();
    }

    private Optional<GenericResponse> handleMissingFieldsInResponse(JsonObject entity, String format, String ... args) {
        StringBuffer missingFields = new StringBuffer("");
        for (String arg : args) {
            if (entity.containsKey((Object)arg)) continue;
            missingFields.append(missingFields.length() > 0 ? ", " : "");
            missingFields.append(arg);
        }
        return missingFields.length() > 0 ? Optional.of(CommonUtils.createGenericResponse(false, 500, String.format(format, missingFields.toString()))) : Optional.empty();
    }

    private String formatApiUrl(String scanApiHostname, String endpoint) {
        return StringUtils.removeEnd((String)scanApiHostname, (String)"/") + "/v1/license" + endpoint;
    }
}

