/*
 * Decompiled with CFR 0.152.
 */
package io.jans.ca.plugin.adminui.utils.security;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PolicyStoreMapperHelper {
    private static final Locale DEFAULT_LOCALE = Locale.ROOT;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Pattern PRINCIPAL_PATTERN = Pattern.compile("Gluu::Flex::AdminUI::Role::\"([A-Za-z0-9_\\-\\.]+)");
    private static final Pattern RESOURCE_ASSIGNMENT_PATTERN = Pattern.compile("resource\\s*(?:==|in|is)\\s*([^;\\n]+)");
    private static final Pattern SINGLE_ACTION_PATTERN = Pattern.compile("action\\s*(?:==|in)\\s*([A-Za-z0-9_:\\\"']+)");
    private static final Pattern MULTI_ACTION_PATTERN = Pattern.compile("action\\s*in\\s*\\[([^\\]]+)\\]");
    private static final String RESOURCE_PREFIX = "Gluu::Flex::AdminUI::Resources::";
    private static final String ACTION_PREFIX = "Gluu::Flex::AdminUI::Action::";
    private static final String PARENT_RESOURCE_PREFIX = "ParentResource::";
    private static final String FEATURES_PREFIX = "Features::";
    private static final String FEATURES_PREFIX_FOR_DEFAULT_ENTITIES = "Gluu::Flex::AdminUI::Resources::Features";

    private PolicyStoreMapperHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static Map<String, Set<String>> mapPrincipalsToScopes(JsonNode policyStoreJson, JsonNode resourcesJson) {
        if (policyStoreJson == null || resourcesJson == null) {
            return Collections.emptyMap();
        }
        Map<String, Set<String>> resourceToCaps = PolicyStoreMapperHelper.buildResourceToScopes(resourcesJson);
        Set<String> allResourceKeys = Collections.unmodifiableSet(resourceToCaps.keySet());
        HashMap<String, Set<String>> principalToScopes = new HashMap<String, Set<String>>();
        ArrayNode policyStores = PolicyStoreMapperHelper.getPolicyStoresArray(policyStoreJson);
        for (JsonNode policyStore : policyStores) {
            ArrayNode policies = PolicyStoreMapperHelper.getArrayNode(policyStore, "policies");
            if (policies == null || policies.isEmpty()) continue;
            for (JsonNode policy : policies) {
                PolicyStoreMapperHelper.processPolicy(policy, policyStore, resourceToCaps, allResourceKeys, principalToScopes);
            }
        }
        return Collections.unmodifiableMap(principalToScopes);
    }

    private static void processPolicy(JsonNode policy, JsonNode policyStore, Map<String, Set<String>> resourceToCaps, Set<String> allResourceKeys, Map<String, Set<String>> principalToScopes) {
        String cedarDsl = PolicyStoreMapperHelper.decodeBase64ToString(policy, "policy_content");
        if (cedarDsl == null || cedarDsl.trim().isEmpty()) {
            return;
        }
        Set<String> principals = PolicyStoreMapperHelper.extractPrincipalsFromCedarDsl(cedarDsl);
        if (principals.isEmpty()) {
            return;
        }
        Set<String> policyResources = PolicyStoreMapperHelper.extractResourceActionPairs(cedarDsl, policyStore);
        Set<String> aggregatedScopes = PolicyStoreMapperHelper.aggregateScopes(policyResources, resourceToCaps, allResourceKeys, policyStore);
        if (!aggregatedScopes.isEmpty()) {
            for (String principal : principals) {
                principalToScopes.computeIfAbsent(principal, k -> new HashSet()).addAll(aggregatedScopes);
            }
        }
    }

    private static Set<String> aggregateScopes(Set<String> policyResources, Map<String, Set<String>> resourceToCaps, Set<String> allResourceKeys, JsonNode policyStore) {
        if (policyResources == null || policyResources.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> aggregatedScopes = new HashSet<String>();
        for (String rawResource : policyResources) {
            String resourceKey;
            if (rawResource == null || rawResource.trim().isEmpty() || PolicyStoreMapperHelper.findAndAddScopes(resourceKey = rawResource.toLowerCase(DEFAULT_LOCALE).trim(), resourceToCaps, allResourceKeys, aggregatedScopes)) continue;
            PolicyStoreMapperHelper.findAndAddScopesFromDefaultEntities(resourceKey, resourceToCaps, allResourceKeys, aggregatedScopes, policyStore);
        }
        return aggregatedScopes;
    }

    private static boolean findAndAddScopes(String resourceKey, Map<String, Set<String>> resourceToCaps, Set<String> allResourceKeys, Set<String> aggregatedScopes) {
        if (resourceKey == null || resourceKey.trim().isEmpty()) {
            return false;
        }
        Set<String> scopes = resourceToCaps.get(resourceKey);
        if (scopes != null && !scopes.isEmpty()) {
            aggregatedScopes.addAll(scopes);
            return true;
        }
        return allResourceKeys.stream().filter(key -> key.equalsIgnoreCase(resourceKey)).findFirst().map(matchedKey -> {
            Set matchedScopes = (Set)resourceToCaps.get(matchedKey);
            if (matchedScopes != null) {
                aggregatedScopes.addAll(matchedScopes);
            }
            return true;
        }).orElse(false);
    }

    private static void findAndAddScopesFromDefaultEntities(String resourceKey, Map<String, Set<String>> resourceToCaps, Set<String> allResourceKeys, Set<String> aggregatedScopes, JsonNode policyStore) {
        JsonNode defaultEntitiesNode = PolicyStoreMapperHelper.decodeBase64ToJson(policyStore, "default_entities");
        if (defaultEntitiesNode == null) {
            return;
        }
        Set<String> featureIds = PolicyStoreMapperHelper.findFeatureIdsByParentResource(defaultEntitiesNode, resourceKey);
        for (String featureId : featureIds) {
            PolicyStoreMapperHelper.findAndAddScopes(featureId, resourceToCaps, allResourceKeys, aggregatedScopes);
        }
    }

    private static Set<String> findFeatureIdsByParentResource(JsonNode defaultEntitiesNode, String targetResource) {
        HashSet<String> featureIds = new HashSet<String>();
        if (defaultEntitiesNode == null || !defaultEntitiesNode.isObject()) {
            return featureIds;
        }
        Iterator fields = defaultEntitiesNode.fields();
        while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            String entityId = (String)entry.getKey();
            JsonNode entityData = PolicyStoreMapperHelper.decodeEntityData((JsonNode)entry.getValue());
            if (!PolicyStoreMapperHelper.isFeatureWithMatchingParent(entityData, targetResource)) continue;
            featureIds.add(entityId.toLowerCase(DEFAULT_LOCALE));
        }
        return featureIds;
    }

    private static JsonNode decodeEntityData(JsonNode encodedNode) {
        if (encodedNode == null || !encodedNode.isTextual()) {
            return null;
        }
        try {
            String base64String = encodedNode.asText();
            byte[] raw = Base64.getDecoder().decode(base64String);
            String jsonString = new String(raw, StandardCharsets.UTF_8);
            return MAPPER.readTree(jsonString);
        }
        catch (IOException | IllegalArgumentException ex) {
            return null;
        }
    }

    private static boolean isFeatureWithMatchingParent(JsonNode entityData, String targetResource) {
        if (entityData == null || !entityData.isObject()) {
            return false;
        }
        JsonNode typeNode = entityData.path("uid").path("type");
        if (!typeNode.isTextual() || !FEATURES_PREFIX_FOR_DEFAULT_ENTITIES.equalsIgnoreCase(typeNode.asText())) {
            return false;
        }
        JsonNode parentsNode = entityData.path("parents");
        if (parentsNode.isArray()) {
            for (JsonNode parentNode : parentsNode) {
                String target;
                String parent;
                JsonNode id = parentNode.path("id");
                if (!id.isTextual() || !(parent = PolicyStoreMapperHelper.normalizeParentResource(id.asText())).equals(target = PolicyStoreMapperHelper.normalizeResource(targetResource))) continue;
                return true;
            }
        }
        return false;
    }

    private static String normalizeParentResource(String parent) {
        if (parent == null) {
            return null;
        }
        String normalized = parent.replace(PARENT_RESOURCE_PREFIX, "");
        if (normalized.contains("::")) {
            normalized = normalized.substring(normalized.lastIndexOf("::") + 2);
        }
        return normalized.toLowerCase(DEFAULT_LOCALE).trim();
    }

    private static ArrayNode getPolicyStoresArray(JsonNode policyStoreJson) {
        ArrayNode policyStores = PolicyStoreMapperHelper.getArrayNode(policyStoreJson, "policy_stores");
        if (policyStores == null) {
            policyStores = MAPPER.createArrayNode().add(policyStoreJson);
        }
        return policyStores;
    }

    private static ArrayNode getArrayNode(JsonNode parent, String field) {
        if (parent == null) {
            return null;
        }
        ArrayNode arrayNode = MAPPER.createArrayNode();
        JsonNode node = parent.path(field);
        if (node != null && node.isObject()) {
            node.fields().forEachRemaining(entry -> arrayNode.add((JsonNode)entry.getValue()));
        } else if (node != null && node.isArray()) {
            return (ArrayNode)node;
        }
        return arrayNode;
    }

    private static Set<String> extractPrincipalsFromCedarDsl(String cedarDsl) {
        HashSet<String> principals = new HashSet<String>();
        Matcher matcher = PRINCIPAL_PATTERN.matcher(cedarDsl);
        while (matcher.find()) {
            principals.add(matcher.group(1).toLowerCase(DEFAULT_LOCALE));
        }
        return principals;
    }

    private static Set<String> extractResourceActionPairs(String policy, JsonNode policyStore) {
        Set<String> resources = PolicyStoreMapperHelper.extractResourcesFromPolicy(policy);
        Set<String> actions = PolicyStoreMapperHelper.extractActionsFromPolicy(policy);
        return PolicyStoreMapperHelper.buildResourceActionPairs(resources, actions, policyStore);
    }

    private static Set<String> extractResourcesFromPolicy(String policy) {
        HashSet<String> resources = new HashSet<String>();
        Matcher matcher = RESOURCE_ASSIGNMENT_PATTERN.matcher(policy);
        while (matcher.find()) {
            String resourceValue = PolicyStoreMapperHelper.cleanValue(matcher.group(1));
            PolicyStoreMapperHelper.extractResourcesFromValue(resourceValue, resources);
        }
        return resources;
    }

    private static void extractResourcesFromValue(String resourceValue, Set<String> resources) {
        if (resourceValue.startsWith("[") && resourceValue.endsWith("]")) {
            String arrayContent = resourceValue.substring(1, resourceValue.length() - 1);
            Arrays.stream(arrayContent.split(",")).map(PolicyStoreMapperHelper::normalizeResource).map(PolicyStoreMapperHelper::cleanValue).filter(cleaned -> !cleaned.isEmpty()).forEach(resources::add);
        } else if (!resourceValue.isEmpty()) {
            resources.add(PolicyStoreMapperHelper.normalizeResource(resourceValue));
        }
    }

    private static Set<String> extractActionsFromPolicy(String policy) {
        HashSet<String> actions = new HashSet<String>();
        if (policy == null || policy.isEmpty()) {
            return actions;
        }
        Matcher matcher = SINGLE_ACTION_PATTERN.matcher(policy);
        if (matcher.find()) {
            actions.add(PolicyStoreMapperHelper.cleanValue(PolicyStoreMapperHelper.normalizeAction(matcher.group(1))));
        } else {
            matcher = MULTI_ACTION_PATTERN.matcher(policy);
            if (matcher.find()) {
                Arrays.stream(matcher.group(1).split(",")).map(PolicyStoreMapperHelper::normalizeAction).map(PolicyStoreMapperHelper::cleanValue).filter(cleaned -> !cleaned.isEmpty()).forEach(actions::add);
            }
        }
        return actions;
    }

    private static Set<String> buildResourceActionPairs(Set<String> resources, Set<String> actions, JsonNode policyStore) {
        HashSet<String> pairs = new HashSet<String>();
        for (String resource : resources) {
            Set<String> matchingEntities = PolicyStoreMapperHelper.findMatchingFeatureEntities(policyStore, resource);
            for (String entity : matchingEntities) {
                for (String action : actions) {
                    String pair = (entity + "~" + action).toLowerCase(DEFAULT_LOCALE).replace("\"", "");
                    pairs.add(pair);
                }
            }
        }
        return pairs;
    }

    private static Set<String> findMatchingFeatureEntities(JsonNode policyStore, String resource) {
        HashSet<String> matchingEntities = new HashSet<String>();
        matchingEntities.add(resource);
        JsonNode defaultEntitiesNode = PolicyStoreMapperHelper.getDefaultEntities(policyStore);
        if (defaultEntitiesNode == null) {
            return matchingEntities;
        }
        Iterator fields = defaultEntitiesNode.fields();
        while (fields.hasNext()) {
            JsonNode idNode;
            JsonNode uidNode;
            Map.Entry entry = (Map.Entry)fields.next();
            JsonNode entityData = PolicyStoreMapperHelper.decodeEntityData((JsonNode)entry.getValue());
            if (!PolicyStoreMapperHelper.isFeatureWithMatchingParent(entityData, resource) || (uidNode = entityData.path("uid")).isMissingNode() || (idNode = uidNode.path("id")).isMissingNode() || !idNode.isTextual()) continue;
            String normalizedId = idNode.asText();
            matchingEntities.add(normalizedId.toLowerCase(DEFAULT_LOCALE).trim());
        }
        return matchingEntities;
    }

    private static JsonNode getDefaultEntities(JsonNode policyStore) {
        JsonNode defaultEntitiesNode = policyStore.path("default_entities");
        if (defaultEntitiesNode.isMissingNode() || defaultEntitiesNode.isNull() || !defaultEntitiesNode.isObject()) {
            return null;
        }
        return defaultEntitiesNode;
    }

    private static String normalizeResource(String value) {
        return value.replace("Gluu::Flex::AdminUI::Resources::ParentResource::", "").replace("Gluu::Flex::AdminUI::Resources::Features::", "").replace("\"", "").toLowerCase(DEFAULT_LOCALE).trim();
    }

    private static String normalizeAction(String value) {
        return value.replace(ACTION_PREFIX, "").trim();
    }

    private static String cleanValue(String value) {
        if (value == null) {
            return null;
        }
        return value.trim().replaceAll("^[\"']|[\"']$", "");
    }

    private static Map<String, Set<String>> buildResourceToScopes(JsonNode resourcesJson) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        if (resourcesJson == null) {
            return map;
        }
        Iterable<JsonNode> items = PolicyStoreMapperHelper.extractResourcesArray(resourcesJson);
        for (JsonNode item : items) {
            String resource = PolicyStoreMapperHelper.firstNonEmptyText(item, "resource", "name");
            String accessType = PolicyStoreMapperHelper.firstNonEmptyText(item, "access_type", "accessType", "type");
            if (resource == null || accessType == null) continue;
            String key = (resource + "~" + accessType).toLowerCase(DEFAULT_LOCALE);
            Set<String> scopes = PolicyStoreMapperHelper.extractScopes(item);
            map.merge(key, scopes, (oldSet, newSet) -> {
                oldSet.addAll(newSet);
                return oldSet;
            });
        }
        return map;
    }

    private static Iterable<JsonNode> extractResourcesArray(JsonNode resourcesJson) {
        if (resourcesJson.isArray()) {
            return resourcesJson;
        }
        JsonNode arr = resourcesJson.path("resources");
        return arr.isArray() ? arr : Collections.emptyList();
    }

    private static Set<String> extractScopes(JsonNode item) {
        JsonNode capsNode;
        HashSet<String> scopes = new HashSet<String>();
        JsonNode jsonNode = capsNode = item.has("scopes") ? item.get("scopes") : item.get("capability");
        if (capsNode != null && capsNode.isArray()) {
            for (JsonNode capability : capsNode) {
                if (!capability.isTextual()) continue;
                scopes.add(capability.asText());
            }
        }
        return scopes;
    }

    private static String decodeBase64ToString(JsonNode parent, String field) {
        String base64String = PolicyStoreMapperHelper.getFieldAsText(parent, field);
        if (base64String == null) {
            return null;
        }
        try {
            byte[] raw = Base64.getDecoder().decode(base64String);
            return new String(raw, StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    private static JsonNode decodeBase64ToJson(JsonNode parent, String field) {
        String base64String = PolicyStoreMapperHelper.getFieldAsText(parent, field);
        if (base64String == null) {
            return null;
        }
        try {
            byte[] raw = Base64.getDecoder().decode(base64String);
            return MAPPER.readTree(new String(raw, StandardCharsets.UTF_8));
        }
        catch (IOException | IllegalArgumentException ex) {
            return null;
        }
    }

    private static String getFieldAsText(JsonNode parent, String field) {
        if (parent == null) {
            return null;
        }
        JsonNode node = parent.path(field);
        if (node.isMissingNode() || node.isNull()) {
            return null;
        }
        if (node.isArray() || node.isObject()) {
            try {
                return MAPPER.writeValueAsString((Object)node);
            }
            catch (IOException e) {
                return null;
            }
        }
        String value = node.asText("");
        return value.isEmpty() ? null : value;
    }

    private static String firstNonEmptyText(JsonNode node, String ... fieldNames) {
        if (node == null) {
            return null;
        }
        for (String field : fieldNames) {
            String value;
            if (!node.has(field) || !node.get(field).isTextual() || (value = node.get(field).asText().trim()).isEmpty()) continue;
            return value;
        }
        return null;
    }
}

