/*
 * Decompiled with CFR 0.152.
 */
package io.jans.ca.plugin.adminui.rest.auth;

import io.jans.as.model.crypto.AuthCryptoProvider;
import io.jans.as.model.jwt.Jwt;
import io.jans.ca.plugin.adminui.model.auth.ApiTokenRequest;
import io.jans.ca.plugin.adminui.model.auth.TokenResponse;
import io.jans.ca.plugin.adminui.model.exception.ApplicationException;
import io.jans.ca.plugin.adminui.service.auth.OAuth2Service;
import io.jans.ca.plugin.adminui.service.config.AUIConfigurationService;
import io.jans.ca.plugin.adminui.utils.CommonUtils;
import io.jans.ca.plugin.adminui.utils.ErrorResponse;
import io.jans.configapi.configuration.ConfigurationFactory;
import io.jans.configapi.core.rest.ProtectedApi;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.Response;
import java.security.KeyStoreException;
import java.util.UUID;
import org.json.JSONObject;
import org.slf4j.Logger;

@Hidden
@Path(value="/app")
public class OAuth2Resource {
    static final String SESSION = "/{appType}/oauth2/session";
    static final String USER_DN_VARIABLE = "/{userDn}";
    static final String USER_DN_CONST = "userDn";
    static final String OAUTH2_API_PROTECTION_TOKEN = "/{appType}/oauth2/api-protection-token";
    static final String ADMIN_UI_SESSION_ID = "admin_ui_session_id";
    public static final String SCOPE_OPENID = "openid";
    static final String ADMINUI_SESSION_WRITE = "https://jans.io/oauth/jans-auth-server/config/adminui/user/session.write";
    static final String ADMINUI_SESSION_DELETE = "https://jans.io/oauth/jans-auth-server/config/adminui/user/session.delete";
    @Inject
    Logger log;
    @Inject
    AUIConfigurationService auiConfigurationService;
    @Inject
    OAuth2Service oAuth2Service;
    @Inject
    ConfigurationFactory configurationFactory;
    private volatile AuthCryptoProvider authCryptoProvider;
    private final Object cryptoProviderLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthCryptoProvider getAuthCryptoProvider() throws KeyStoreException {
        if (this.authCryptoProvider == null) {
            Object object = this.cryptoProviderLock;
            synchronized (object) {
                if (this.authCryptoProvider == null) {
                    this.authCryptoProvider = new AuthCryptoProvider();
                }
            }
        }
        return this.authCryptoProvider;
    }

    @POST
    @Path(value="/{appType}/oauth2/session")
    @Produces(value={"application/json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/session.write"}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/session.write"})
    public Response createSession(@Valid @NotNull ApiTokenRequest apiTokenRequest) {
        try {
            if (apiTokenRequest.getUjwt() == null) {
                throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.UJWT_NOT_FOUND.getDescription());
            }
            String sessionId = UUID.randomUUID().toString();
            this.authCryptoProvider = this.getAuthCryptoProvider();
            Jwt userInfoJwt = Jwt.parse((String)apiTokenRequest.getUjwt());
            boolean isValidJWTSignature = this.authCryptoProvider.verifySignature(userInfoJwt.getSigningInput(), userInfoJwt.getEncodedSignature(), userInfoJwt.getHeader().getKeyId(), new JSONObject((Object)this.configurationFactory.getJwks()), null, userInfoJwt.getHeader().getSignatureAlgorithm());
            if (!isValidJWTSignature) {
                throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.SIGNATURE_NOT_VALID.getDescription());
            }
            String cookie = "admin_ui_session_id=" + sessionId + "; Path=/; HttpOnly; Secure; SameSite=None";
            this.oAuth2Service.setAdminUISession(sessionId, apiTokenRequest.getUjwt());
            return Response.ok((Object)CommonUtils.createGenericResponse(true, 200, "Admin UI Session created successfully.")).header("Set-Cookie", (Object)cookie).build();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.ADMINUI_SESSION_CREATE_ERROR.getDescription(), (Throwable)e);
            return Response.status((int)e.getErrorCode()).entity((Object)CommonUtils.createGenericResponse(false, e.getErrorCode(), e.getMessage())).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.ADMINUI_SESSION_CREATE_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, 500, ErrorResponse.ADMINUI_SESSION_CREATE_ERROR.getDescription())).build();
        }
    }

    @DELETE
    @Path(value="/{appType}/oauth2/session")
    @Produces(value={"application/json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/session.delete"}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/session.delete"})
    public Response deleteSessionBySessionCookie(@CookieParam(value="admin_ui_session_id") Cookie sessionCookie) {
        if (sessionCookie == null || sessionCookie.getValue() == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)CommonUtils.createGenericResponse(false, 400, "Session cookie not found")).build();
        }
        this.log.debug("Inside deleteSessionBySessionCookie method. Session Cookie name: {}", (Object)sessionCookie.getName());
        try {
            this.oAuth2Service.removeSession(sessionCookie.getValue());
            String cookie = "admin_ui_session_id=" + sessionCookie.getValue() + "; Path=/; Max-Age=0; HttpOnly; Secure; SameSite=None";
            return Response.ok((Object)CommonUtils.createGenericResponse(true, 200, "Admin UI Session revoked successfully.")).header("Set-Cookie", (Object)cookie).build();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.ADMINUI_SESSION_REMOVE_ERROR.getDescription(), (Throwable)e);
            return Response.status((int)e.getErrorCode()).entity((Object)CommonUtils.createGenericResponse(false, e.getErrorCode(), e.getMessage())).build();
        }
    }

    @DELETE
    @Path(value="/{appType}/oauth2/session/{userDn}")
    @Produces(value={"application/json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/session.delete"}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/session.delete"})
    public Response deleteSessionsByUserDn(@Parameter(description="User DN") @PathParam(value="userDn") @NotNull String userDn) {
        this.log.debug("Inside deleteSessionsByUserDn method...");
        if (!userDn.matches("^inum=[a-zA-Z0-9\\-]+,ou=people,o=jans$")) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)CommonUtils.createGenericResponse(false, 400, "Invalid user DN format")).build();
        }
        try {
            this.oAuth2Service.removeAdminUIUserSessionByDn(userDn);
            return Response.ok((Object)CommonUtils.createGenericResponse(true, 200, "Admin UI Sessions revoked successfully.")).build();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.ADMINUI_SESSION_REMOVE_ERROR.getDescription(), (Throwable)e);
            return Response.status((int)e.getErrorCode()).entity((Object)CommonUtils.createGenericResponse(false, e.getErrorCode(), e.getMessage())).build();
        }
    }

    @POST
    @Path(value="/{appType}/oauth2/api-protection-token")
    @Produces(value={"application/json"})
    public Response getApiProtectionToken(@Valid @NotNull ApiTokenRequest apiTokenRequest, @PathParam(value="appType") String appType) {
        try {
            this.log.info("Api protection token request to Auth Server.");
            TokenResponse tokenResponse = this.oAuth2Service.getApiProtectionToken(apiTokenRequest, appType);
            this.log.info("Api protection token received from Auth Server.");
            return Response.ok((Object)tokenResponse).build();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.GET_API_PROTECTION_TOKEN_ERROR.getDescription(), (Throwable)e);
            return Response.status((int)e.getErrorCode()).entity((Object)CommonUtils.createGenericResponse(false, e.getErrorCode(), e.getMessage())).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.GET_API_PROTECTION_TOKEN_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, 500, ErrorResponse.GET_API_PROTECTION_TOKEN_ERROR.getDescription())).build();
        }
    }
}

