/*
 * Decompiled with CFR 0.152.
 */
package io.jans.ca.plugin.adminui.rest.license;

import io.jans.ca.plugin.adminui.model.auth.GenericResponse;
import io.jans.ca.plugin.adminui.model.auth.LicenseRequest;
import io.jans.ca.plugin.adminui.model.auth.LicenseResponse;
import io.jans.ca.plugin.adminui.model.auth.SSARequest;
import io.jans.ca.plugin.adminui.service.license.LicenseDetailsService;
import io.jans.ca.plugin.adminui.utils.CommonUtils;
import io.jans.ca.plugin.adminui.utils.ErrorResponse;
import io.jans.configapi.core.rest.ProtectedApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;

@Path(value="/admin-ui/license")
public class LicenseResource {
    static final String IS_ACTIVE = "/isActive";
    static final String ACTIVATE = "/activate";
    static final String TRIAL = "/trial";
    static final String DETAILS = "/details";
    static final String RETRIEVE = "/retrieve";
    static final String SSA = "/ssa";
    static final String IS_LICENSE_CONFIG_VALID = "/isConfigValid";
    static final String CONFIG_DELETE = "/deleteConfig";
    public static final String SCOPE_LICENSE_READ = "https://jans.io/oauth/jans-auth-server/config/adminui/license.readonly";
    public static final String SCOPE_LICENSE_WRITE = "https://jans.io/oauth/jans-auth-server/config/adminui/license.write";
    public static final String SCOPE_LICENSE_ADMIN = "https://jans.io/oauth/jans-auth-server/config/adminui/license.admin";
    @Inject
    Logger log;
    @Inject
    LicenseDetailsService licenseDetailsService;

    @Operation(summary="Check if admin-ui license is active", description="Check if admin-ui license is active", operationId="is-license-active", tags={"Admin UI - License"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/read-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))})})
    @GET
    @Path(value="/isActive")
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.readonly"}, groupScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.write"}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.admin", "https://jans.io/oauth/jans-auth-server/config/adminui/read-all"})
    @Produces(value={"application/json"})
    public Response isActive() {
        GenericResponse licenseResponse = null;
        try {
            this.log.info("Check if active license present.");
            licenseResponse = this.licenseDetailsService.checkLicense();
            this.log.info("Active license present (true/false): {}", (Object)licenseResponse.isSuccess());
            return Response.status((int)licenseResponse.getResponseCode()).entity((Object)licenseResponse).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.CHECK_LICENSE_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)licenseResponse).build();
        }
    }

    @Operation(summary="Delete license details in admin-ui configuration", description="Delete license details in admin-ui configuration", operationId="license-config-delete", tags={"Admin UI - License"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))})})
    @DELETE
    @Path(value="/deleteConfig")
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.admin", "https://jans.io/oauth/jans-auth-server/config/adminui/write-all"})
    @Produces(value={"application/json"})
    public Response deleteLicenseConfiguration() {
        GenericResponse licenseResponse = null;
        try {
            this.log.info("Before deleting license configuration.");
            licenseResponse = this.licenseDetailsService.deleteLicenseConfiguration();
            this.log.info("License deleted successful (true/false): {}", (Object)licenseResponse.isSuccess());
            return Response.status((int)licenseResponse.getResponseCode()).entity((Object)licenseResponse).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.LICENSE_DELETE_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)licenseResponse).build();
        }
    }

    @Operation(summary="Retrieve license from SCAN", description="Retrieve license from SCAN", operationId="retrieve-license", tags={"Admin UI - License"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/read-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))})})
    @GET
    @Path(value="/retrieve")
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.readonly"}, groupScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.write"}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.admin", "https://jans.io/oauth/jans-auth-server/config/adminui/read-all"})
    @Produces(value={"application/json"})
    public Response retrieveLicense() {
        GenericResponse licenseResponse = null;
        try {
            this.log.info("Retrieve license from SCAN.");
            licenseResponse = this.licenseDetailsService.retrieveLicense();
            this.log.info("Retrieve license from SCAN result (true/false): {}", (Object)licenseResponse.isSuccess());
            return Response.status((int)licenseResponse.getResponseCode()).entity((Object)licenseResponse).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.RETRIEVE_LICENSE_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)licenseResponse).build();
        }
    }

    @Operation(summary="Generate trial license", description="Generate trial license", operationId="get-trial-license", tags={"Admin UI - License"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/read-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))})})
    @GET
    @Path(value="/trial")
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.readonly"}, groupScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.write"}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.admin", "https://jans.io/oauth/jans-auth-server/config/adminui/read-all"})
    @Produces(value={"application/json"})
    public Response trial() {
        GenericResponse licenseResponse = null;
        try {
            this.log.info("Generate trial license.");
            licenseResponse = this.licenseDetailsService.generateTrialLicense();
            this.log.info("Generate trial license (true/false): {}", (Object)licenseResponse.isSuccess());
            return Response.status((int)licenseResponse.getResponseCode()).entity((Object)licenseResponse).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.CHECK_LICENSE_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)licenseResponse).build();
        }
    }

    @Operation(summary="Activate license using license-key", description="Activate license using license-key", operationId="activate-adminui-license", tags={"Admin UI - License"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/write-all"})})
    @RequestBody(description="LicenseRequest object", content={@Content(mediaType="application/json", schema=@Schema(implementation=LicenseRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))})})
    @POST
    @Path(value="/activate")
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.write"}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.admin", "https://jans.io/oauth/jans-auth-server/config/adminui/write-all"})
    @Produces(value={"application/json"})
    public Response activate(@Valid @NotNull LicenseRequest licenseRequest) {
        GenericResponse licenseResponse = null;
        try {
            this.log.info("Trying to activate license using licese-key.");
            licenseResponse = this.licenseDetailsService.activateLicense(licenseRequest);
            this.log.info("License activated (true/false): {}", (Object)licenseResponse.isSuccess());
            return Response.status((int)licenseResponse.getResponseCode()).entity((Object)licenseResponse).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.ACTIVATE_LICENSE_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)licenseResponse).build();
        }
    }

    @Operation(summary="Save SSA in configuration", description="Save SSA in configuration", operationId="adminui-post-ssa", tags={"Admin UI - License"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/write-all"})})
    @RequestBody(description="SSARequest object", content={@Content(mediaType="application/json", schema=@Schema(implementation=SSARequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))})})
    @POST
    @Path(value="/ssa")
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.write"}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.admin", "https://jans.io/oauth/jans-auth-server/config/adminui/write-all"})
    @Produces(value={"application/json"})
    public Response ssa(@Valid @NotNull SSARequest ssaRequest) {
        GenericResponse licenseResponse = null;
        try {
            this.log.info("Trying to execute post ssa.");
            licenseResponse = this.licenseDetailsService.postSSA(ssaRequest);
            this.log.info("SSA Saved (true/false): {}", (Object)licenseResponse.isSuccess());
            return Response.status((int)licenseResponse.getResponseCode()).entity((Object)licenseResponse).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.ACTIVATE_LICENSE_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)licenseResponse).build();
        }
    }

    @Operation(summary="Is license configuration valid", description="Is license configuration valid", operationId="check-adminui-license-config", tags={"Admin UI - License"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/read-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))})})
    @GET
    @Path(value="/isConfigValid")
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.readonly"}, groupScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.write"}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.admin", "https://jans.io/oauth/jans-auth-server/config/adminui/read-all"})
    @Produces(value={"application/json"})
    public Response isConfigValid() {
        GenericResponse licenseResponse = null;
        try {
            this.log.info("Check if license config valid.");
            licenseResponse = this.licenseDetailsService.validateLicenseConfiguration();
            this.log.info("License config valid (true/false): {}", (Object)licenseResponse.isSuccess());
            return Response.status((int)licenseResponse.getResponseCode()).entity((Object)licenseResponse).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.ACTIVATE_LICENSE_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)licenseResponse).build();
        }
    }

    @Operation(summary="Get admin ui license details", description="Get admin ui license details", operationId="get-adminui-license", tags={"Admin UI - License"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/read-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=LicenseResponse.class, description="License Response"))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="License response"))})})
    @GET
    @Path(value="/details")
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.readonly"}, groupScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.write"}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/license.admin", "https://jans.io/oauth/jans-auth-server/config/adminui/read-all"})
    @Produces(value={"application/json"})
    public Response details() {
        try {
            this.log.info("Trying to fetch license details.");
            LicenseResponse licenseResponse = this.licenseDetailsService.getLicenseDetails();
            return Response.ok((Object)licenseResponse).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.GET_LICENSE_DETAILS_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, 500, ErrorResponse.GET_LICENSE_DETAILS_ERROR.getDescription())).build();
        }
    }
}

