/*
 * Decompiled with CFR 0.152.
 */
package io.jans.ca.plugin.adminui.service;

import com.google.common.base.Strings;
import io.jans.as.client.TokenRequest;
import io.jans.as.client.TokenResponse;
import io.jans.as.model.jwt.Jwt;
import io.jans.ca.plugin.adminui.model.auth.DCRResponse;
import io.jans.ca.plugin.adminui.model.exception.ApplicationException;
import io.jans.ca.plugin.adminui.utils.ClientFactory;
import io.jans.ca.plugin.adminui.utils.CommonUtils;
import io.jans.ca.plugin.adminui.utils.ErrorResponse;
import jakarta.inject.Inject;
import jakarta.json.JsonObject;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class BaseService {
    @Inject
    Logger log;

    public TokenResponse getToken(TokenRequest tokenRequest, String tokenEndpoint) {
        return this.getToken(tokenRequest, tokenEndpoint, null);
    }

    public TokenResponse getToken(TokenRequest tokenRequest, String tokenEndpoint, String userInfoJwt) {
        try {
            MultivaluedHashMap body = new MultivaluedHashMap();
            if (!Strings.isNullOrEmpty((String)tokenRequest.getCode())) {
                body.putSingle((Object)"code", (Object)tokenRequest.getCode());
            }
            if (!Strings.isNullOrEmpty((String)tokenRequest.getScope())) {
                body.putSingle((Object)"scope", (Object)tokenRequest.getScope());
            }
            if (!Strings.isNullOrEmpty((String)userInfoJwt)) {
                body.putSingle((Object)"ujwt", (Object)userInfoJwt);
            }
            if (!Strings.isNullOrEmpty((String)tokenRequest.getCodeVerifier())) {
                body.putSingle((Object)"code_verifier", (Object)tokenRequest.getCodeVerifier());
            }
            if (tokenRequest.getGrantType() != null && !Strings.isNullOrEmpty((String)tokenRequest.getGrantType().getValue())) {
                body.putSingle((Object)"grant_type", (Object)tokenRequest.getGrantType().getValue());
            }
            if (!Strings.isNullOrEmpty((String)tokenRequest.getRedirectUri())) {
                body.putSingle((Object)"redirect_uri", (Object)tokenRequest.getRedirectUri());
            }
            if (!Strings.isNullOrEmpty((String)tokenRequest.getAuthUsername())) {
                body.putSingle((Object)"client_id", (Object)tokenRequest.getAuthUsername());
            }
            Invocation.Builder request = ClientFactory.instance().getClientBuilder(tokenEndpoint);
            Response response = request.header("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials())).post(Entity.form((MultivaluedMap)body));
            this.log.info("Get Access Token status code: {}", (Object)response.getStatus());
            if (response.getStatus() == 200) {
                String entity = (String)response.readEntity(String.class);
                TokenResponse tokenResponse = new TokenResponse();
                tokenResponse.setEntity(entity);
                tokenResponse.injectDataFromJson(entity);
                return tokenResponse;
            }
            this.log.error("Error in getting access token: {}", response.getEntity());
        }
        catch (Exception e) {
            this.log.error("Problems processing token call", (Throwable)e);
            throw e;
        }
        return null;
    }

    public DCRResponse executeDCR(String ssaJwt) {
        try {
            this.log.info("executing DCR");
            if (Strings.isNullOrEmpty((String)ssaJwt)) {
                throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.BLANK_JWT.getDescription());
            }
            Jwt tokenJwt = Jwt.parse((String)ssaJwt);
            Map<String, Object> claims = CommonUtils.getClaims(tokenJwt);
            if (claims.get("iss") == null) {
                throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.ISS_CLAIM_NOT_FOUND.getDescription());
            }
            if (claims.get("org_id") == null) {
                throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.ORG_ID_CLAIM_NOT_FOUND.getDescription());
            }
            String issuer = StringUtils.removeEnd((String)claims.get("iss").toString(), (String)"/");
            String hardwareId = claims.get("org_id").toString();
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("software_statement", ssaJwt);
            body.put("response_types", "token");
            body.put("redirect_uris", issuer);
            body.put("client_name", "admin-ui-license-client-" + UUID.randomUUID().toString());
            Invocation.Builder request = ClientFactory.instance().getClientBuilder(issuer + "/jans-auth/restv1/register");
            Response response = request.header("Content-Type", (Object)"application/json").post(Entity.entity(body, (String)"application/json"));
            this.log.info("DCR status code: {}", (Object)response.getStatus());
            if (response.getStatus() == 201) {
                JsonObject entity = (JsonObject)response.readEntity(JsonObject.class);
                DCRResponse dcrResponse = new DCRResponse();
                dcrResponse.setClientId(entity.getString("client_id"));
                dcrResponse.setClientSecret(entity.getString("client_secret"));
                dcrResponse.setOpHost(issuer);
                dcrResponse.setHardwareId(hardwareId);
                if (issuer.equals("https://account-dev.gluu.cloud")) {
                    dcrResponse.setScanHostname("https://cloud-dev.gluu.cloud");
                }
                if (issuer.equals("https://account.gluu.org")) {
                    dcrResponse.setScanHostname("https://cloud.gluu.org");
                }
                return dcrResponse;
            }
            this.log.error("Error in DCR: {}", response.readEntity(String.class));
            return null;
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.ERROR_IN_DCR.getDescription(), (Throwable)e);
            return null;
        }
    }

    public Optional<Map<String, Object>> introspectToken(String accessToken, String introspectionEndpoint) throws NoSuchAlgorithmException, KeyManagementException {
        this.log.info("Token introspection from auth-server.");
        Invocation.Builder request = ClientFactory.instance().getClientBuilder(introspectionEndpoint);
        request.header("Authorization", (Object)("Bearer " + accessToken));
        MultivaluedHashMap body = new MultivaluedHashMap();
        body.putSingle((Object)"token", (Object)accessToken);
        Response response = request.post(Entity.form((MultivaluedMap)body));
        this.log.info("Introspection response status code: {}", (Object)response.getStatus());
        if (response.getStatus() == 200) {
            Optional<Map<String, Object>> entity = Optional.of((Map)response.readEntity(Map.class));
            this.log.info("Introspection response entity: {}", (Object)entity.get().toString());
            return entity;
        }
        return Optional.empty();
    }
}

