/*
 * Decompiled with CFR 0.152.
 */
package io.jans.ca.plugin.adminui.filters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Strings;
import io.jans.as.client.TokenResponse;
import io.jans.as.model.config.adminui.AdminConf;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.jwt.Jwt;
import io.jans.ca.plugin.adminui.service.adminui.AdminUISessionService;
import io.jans.configapi.core.model.adminui.AUIConfiguration;
import io.jans.configapi.core.model.adminui.AdminUISession;
import io.jans.configapi.core.model.adminui.CedarlingLogType;
import io.jans.configapi.core.model.adminui.CedarlingPolicyStrRetrievalPoint;
import io.jans.configapi.core.model.exception.ConfigApiApplicationException;
import io.jans.configapi.service.auth.ConfigurationService;
import io.jans.configapi.util.TtlCache;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Provider
@Priority(value=500)
public class AdminUICookieFilter
implements ContainerRequestFilter {
    @Inject
    Logger log;
    @Inject
    AdminUISessionService configApiSessionService;
    @Inject
    ConfigurationService configurationService;
    private volatile AUIConfiguration auiConfiguration;
    private volatile TtlCache<String, String> ujwtTokenCache;
    private final Object cacheLock = new Object();
    private final Object configLock = new Object();
    private static final String ADMIN_UI_SESSION_ID = "admin_ui_session_id";
    private static final String AUTHENTICATION_SCHEME = "Bearer";
    private static final String EXCLUDED_PATH_SESSION = "/app/admin-ui/oauth2/session";
    private static final String EXCLUDED_PATH_CONFIG_API_TOKEN = "/app/admin-ui/oauth2/api-protection-token";
    private static final List<String> EXCLUDED_PATHS = List.of("/app/admin-ui/oauth2/session", "/app/admin-ui/oauth2/api-protection-token");
    private static final long CACHE_TTL_MS = 3600000L;
    private static final int CACHE_MAX_SIZE = 100;
    private volatile long lastCleanupTime = 0L;
    private static final long CLEANUP_INTERVAL_MS = 300000L;

    public void filter(ContainerRequestContext requestContext) {
        try {
            this.log.debug("========================================================================");
            this.log.debug("Inside AdminUICookieFilter filter...");
            this.log.debug("========================================================================");
            Map cookies = requestContext.getCookies();
            this.initializeCaches();
            this.removeExpiredSessionsIfNeeded();
            Optional<String> ujwtOptional = this.fetchUJWTFromAdminUISession(cookies);
            if (cookies.containsKey(ADMIN_UI_SESSION_ID) && !this.isExcludedPath(requestContext) && requestContext.getHeaders().get((Object)"Authorization") == null && ujwtOptional.isEmpty()) {
                this.abortWithException(requestContext, Response.Status.FORBIDDEN, "Admin UI session is not present on server.");
            }
            if (ujwtOptional.isEmpty()) {
                return;
            }
            this.initializeAdminUIConfiguration();
            if (this.auiConfiguration == null) {
                this.log.warn("Admin UI configuration could not be initialized. Skipping token injection.");
                return;
            }
            String accessToken = null;
            accessToken = this.getAccessToken(ujwtOptional.get(), this.auiConfiguration);
            if (Strings.isNullOrEmpty((String)accessToken)) {
                this.abortWithException(requestContext, Response.Status.INTERNAL_SERVER_ERROR, "Generated Config Api access token is null or empty.");
                return;
            }
            requestContext.getHeaders().putSingle((Object)"Authorization", (Object)("Bearer " + accessToken));
        }
        catch (Exception e) {
            this.abortWithException(requestContext, Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    private boolean hasAdminUISessionCookie(Map<String, Cookie> cookies) {
        return cookies != null && cookies.containsKey(ADMIN_UI_SESSION_ID);
    }

    private boolean isExcludedPath(ContainerRequestContext requestContext) {
        String path = requestContext.getUriInfo().getPath();
        return EXCLUDED_PATHS.stream().anyMatch(excluded -> path.equals(excluded) || path.equals(excluded.substring(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExpiredSessionsIfNeeded() {
        long now = System.currentTimeMillis();
        if (now - this.lastCleanupTime > 300000L) {
            Object object = this.cacheLock;
            synchronized (object) {
                if (now - this.lastCleanupTime > 300000L) {
                    this.configApiSessionService.removeAllExpiredSessions();
                    this.lastCleanupTime = now;
                }
            }
        }
    }

    private String getAccessToken(String ujwtString, AUIConfiguration auiConfiguration) throws ConfigApiApplicationException {
        String sub = this.getSubjectFromUJWT(ujwtString);
        String cachedToken = (String)this.ujwtTokenCache.get((Object)sub);
        if (cachedToken != null) {
            try {
                if (this.configApiSessionService.isCachedTokenValid(cachedToken, auiConfiguration)) {
                    return cachedToken;
                }
                this.ujwtTokenCache.remove((Object)sub);
            }
            catch (JsonProcessingException e) {
                this.log.warn("Error occurred while introspecting the cached token to access the Config API.");
            }
        }
        TokenResponse tokenResponse = null;
        try {
            tokenResponse = this.configApiSessionService.getApiProtectionToken(ujwtString, auiConfiguration);
        }
        catch (Exception e) {
            throw new ConfigApiApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Error in generating token generated for accessing Config API: " + e.getMessage());
        }
        if (tokenResponse == null || Strings.isNullOrEmpty((String)tokenResponse.getAccessToken())) {
            throw new ConfigApiApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Failed to obtain a valid access token for Config API");
        }
        this.ujwtTokenCache.put((Object)sub, (Object)tokenResponse.getAccessToken(), 3600000L);
        return tokenResponse.getAccessToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeCaches() {
        if (this.ujwtTokenCache != null) {
            return;
        }
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.ujwtTokenCache == null) {
                this.ujwtTokenCache = new TtlCache(100);
            }
        }
    }

    private String getSubjectFromUJWT(String ujwtString) throws ConfigApiApplicationException {
        try {
            Jwt tokenJwt = Jwt.parse((String)ujwtString);
            Map<String, Object> claims = this.configApiSessionService.getClaims(tokenJwt);
            if (claims.get("sub") == null) {
                throw new ConfigApiApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "The `sub` claim missing in User-Info JWT");
            }
            return (String)claims.get("sub");
        }
        catch (InvalidJwtException e) {
            throw new ConfigApiApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Invalid User-Info JWT: " + e.getMessage());
        }
    }

    private Optional<String> fetchUJWTFromAdminUISession(Map<String, Cookie> cookies) {
        if (!this.hasAdminUISessionCookie(cookies)) {
            return Optional.empty();
        }
        this.log.debug("Found a Admin UI session cookie in request header.");
        Cookie adminUISessionCookie = cookies.get(ADMIN_UI_SESSION_ID);
        String sessionId = adminUISessionCookie.getValue();
        AdminUISession configApiSession = this.configApiSessionService.getSession(sessionId);
        if (configApiSession == null) {
            return Optional.empty();
        }
        this.log.debug("Admin UI session exist in persistence.");
        String ujwtString = configApiSession.getUjwt();
        return Optional.ofNullable(ujwtString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeAdminUIConfiguration() {
        if (this.auiConfiguration != null) {
            return;
        }
        Object object = this.configLock;
        synchronized (object) {
            if (this.auiConfiguration != null) {
                return;
            }
            AdminConf adminConf = this.configApiSessionService.fetchAdminUIConfiguration();
            this.addPropertiesToAUIConfiguration(adminConf);
        }
    }

    private void addPropertiesToAUIConfiguration(AdminConf appConf) {
        if (appConf == null || appConf.getMainSettings() == null || appConf.getMainSettings().getOidcConfig() == null || appConf.getMainSettings().getOidcConfig().getAuiWebClient() == null || appConf.getMainSettings().getOidcConfig().getAuiBackendApiClient() == null || appConf.getMainSettings().getUiConfig() == null) {
            this.log.error("Admin UI configuration is incomplete or null");
            return;
        }
        AUIConfiguration config = new AUIConfiguration();
        AppConfiguration appConfiguration = this.configurationService.find();
        config.setAppType("admin_ui");
        config.setAuiWebServerHost(appConf.getMainSettings().getOidcConfig().getAuiWebClient().getOpHost());
        config.setAuiWebServerClientId(appConf.getMainSettings().getOidcConfig().getAuiWebClient().getClientId());
        config.setAuiWebServerClientSecret(appConf.getMainSettings().getOidcConfig().getAuiWebClient().getClientSecret());
        config.setAuiWebServerScope(StringUtils.join((Iterable)appConf.getMainSettings().getOidcConfig().getAuiWebClient().getScopes(), (String)"+"));
        config.setAuiWebServerRedirectUrl(appConf.getMainSettings().getOidcConfig().getAuiWebClient().getRedirectUri());
        config.setAuiWebServerFrontChannelLogoutUrl(appConf.getMainSettings().getOidcConfig().getAuiWebClient().getFrontchannelLogoutUri());
        config.setAuiWebServerPostLogoutRedirectUri(appConf.getMainSettings().getOidcConfig().getAuiWebClient().getPostLogoutUri());
        config.setAuiWebServerAuthzBaseUrl(appConfiguration.getAuthorizationEndpoint());
        config.setAuiWebServerTokenEndpoint(appConfiguration.getTokenEndpoint());
        config.setAuiWebServerIntrospectionEndpoint(appConfiguration.getIntrospectionEndpoint());
        config.setAuiWebServerUserInfoEndpoint(appConfiguration.getUserInfoEndpoint());
        config.setAuiWebServerEndSessionEndpoint(appConfiguration.getEndSessionEndpoint());
        config.setAuiWebServerAcrValues(StringUtils.join((Iterable)appConf.getMainSettings().getOidcConfig().getAuiWebClient().getAcrValues(), (String)"+"));
        config.setAuiBackendApiServerClientId(appConf.getMainSettings().getOidcConfig().getAuiBackendApiClient().getClientId());
        config.setAuiBackendApiServerClientSecret(appConf.getMainSettings().getOidcConfig().getAuiBackendApiClient().getClientSecret());
        config.setAuiBackendApiServerScope(StringUtils.join((Iterable)appConf.getMainSettings().getOidcConfig().getAuiBackendApiClient().getScopes(), (String)"+"));
        config.setAuiBackendApiServerTokenEndpoint(appConf.getMainSettings().getOidcConfig().getAuiBackendApiClient().getTokenEndpoint());
        config.setAuiBackendApiServerIntrospectionEndpoint(appConf.getMainSettings().getOidcConfig().getAuiBackendApiClient().getIntrospectionEndpoint());
        config.setSessionTimeoutInMins(appConf.getMainSettings().getUiConfig().getSessionTimeoutInMins());
        config.setAllowSmtpKeystoreEdit(appConf.getMainSettings().getUiConfig().getAllowSmtpKeystoreEdit());
        config.setAdditionalParameters(appConf.getMainSettings().getOidcConfig().getAuiWebClient().getAdditionalParameters());
        config.setCedarlingLogType(CedarlingLogType.fromString((String)appConf.getMainSettings().getUiConfig().getCedarlingLogType()));
        config.setAuiCedarlingPolicyStoreUrl(appConf.getMainSettings().getUiConfig().getAuiPolicyStoreUrl());
        config.setCedarlingPolicyStoreRetrievalPoint(CedarlingPolicyStrRetrievalPoint.fromString((String)appConf.getMainSettings().getUiConfig().getCedarlingPolicyStoreRetrievalPoint()));
        config.setAuiCedarlingDefaultPolicyStorePath(appConf.getMainSettings().getUiConfig().getAuiDefaultPolicyStorePath());
        this.auiConfiguration = config;
    }

    private void abortWithException(ContainerRequestContext requestContext, Response.Status status, String errMsg) {
        requestContext.abortWith(Response.status((Response.Status)status).entity((Object)errMsg).build());
    }
}

