/*
 * Decompiled with CFR 0.152.
 */
package io.jans.ca.plugin.adminui.rest.adminui;

import io.jans.as.model.config.adminui.AdminPermission;
import io.jans.as.model.config.adminui.AdminRole;
import io.jans.as.model.config.adminui.RolePermissionMapping;
import io.jans.ca.plugin.adminui.model.auth.AppConfigResponse;
import io.jans.ca.plugin.adminui.model.auth.GenericResponse;
import io.jans.ca.plugin.adminui.model.exception.ApplicationException;
import io.jans.ca.plugin.adminui.service.adminui.AdminUIService;
import io.jans.ca.plugin.adminui.utils.CommonUtils;
import io.jans.ca.plugin.adminui.utils.ErrorResponse;
import io.jans.configapi.core.rest.ProtectedApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.slf4j.Logger;

@Path(value="/admin-ui")
public class AdminUIResource {
    static final String CONFIG = "/config";
    static final String ROLES = "/adminUIRoles";
    static final String ROLE_PATH_VARIABLE = "/{adminUIRole}";
    static final String ROLE_CONST = "adminUIRole";
    static final String PERMISSIONS = "/adminUIPermissions";
    static final String PERMISSION_PATH_VARIABLE = "/{adminUIPermission}";
    static final String PERMISSION_CONST = "adminUIPermission";
    static final String ROLE_PERMISSIONS_MAPPING = "/adminUIRolePermissionsMapping";
    static final String SCOPE_ROLE_READ = "https://jans.io/oauth/jans-auth-server/config/adminui/user/role.readonly";
    static final String SCOPE_ROLE_WRITE = "https://jans.io/oauth/jans-auth-server/config/adminui/user/role.write";
    static final String SCOPE_ROLE_DELETE = "https://jans.io/oauth/jans-auth-server/config/adminui/user/role.delete";
    static final String SCOPE_PERMISSION_READ = "https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.readonly";
    static final String SCOPE_PERMISSION_WRITE = "https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.write";
    static final String SCOPE_PERMISSION_DELETE = "https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.delete";
    static final String SCOPE_ROLE_PERMISSION_MAPPING_READ = "https://jans.io/oauth/jans-auth-server/config/adminui/user/rolePermissionMapping.readonly";
    static final String SCOPE_ROLE_PERMISSION_MAPPING_WRITE = "https://jans.io/oauth/jans-auth-server/config/adminui/user/rolePermissionMapping.write";
    static final String SCOPE_ROLE_PERMISSION_MAPPING_DELETE = "https://jans.io/oauth/jans-auth-server/config/adminui/user/rolePermissionMapping.delete";
    public static final String ADMINUI_CONF_READ = "https://jans.io/oauth/jans-auth-server/config/adminui/properties.readonly";
    public static final String ADMINUI_CONF_WRITE = "https://jans.io/oauth/jans-auth-server/config/adminui/properties.write";
    static final String SCOPE_ROLE_ADMIN = "https://jans.io/oauth/jans-auth-server/config/adminui/user/role.admin";
    static final String SCOPE_PERMISSION_ADMIN = "https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.admin";
    static final String SCOPE_ROLE_PERMISSION_MAPPING_ADMIN = "https://jans.io/oauth/jans-auth-server/config/adminui/user/rolePermissionMapping.admin";
    @Inject
    Logger log;
    @Inject
    AdminUIService adminUIService;

    @Operation(summary="Get Admin UI editable configuration", description="Get Admin UI editable configuration", operationId="get-adminui-conf", tags={"Admin UI - Configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/properties.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/properties.write"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppConfigResponse.class, description="Admin UI editable configuration"))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="Bad Request"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="InternalServerError"))})})
    @GET
    @Path(value="/config")
    @Produces(value={"application/json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/properties.readonly"}, groupScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/properties.write"}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/properties.readonly"})
    public Response getConf() {
        try {
            this.log.info("Get Admin UI editable configuration.");
            AppConfigResponse appConf = this.adminUIService.getAdminUIEditableConfiguration();
            this.log.info("Configuration received.");
            return Response.ok((Object)appConf).build();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.GET_ADMIUI_CONFIG_ERROR.getDescription(), (Throwable)e);
            return Response.status((int)e.getErrorCode()).entity((Object)CommonUtils.createGenericResponse(false, e.getErrorCode(), e.getMessage())).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.GET_ADMIUI_CONFIG_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, 500, e.getMessage())).build();
        }
    }

    @Operation(summary="Edit Admin UI editable configuration", description="Edit Admin UI editable configuration", operationId="edit-adminui-conf", tags={"Admin UI - Configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/properties.write"})})
    @RequestBody(description="Admin Config object", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppConfigResponse.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppConfigResponse.class, description="Admin UI editable configuration"))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="Bad Request"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="InternalServerError"))})})
    @PUT
    @Path(value="/config")
    @Produces(value={"application/json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/properties.write"}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/properties.write"})
    public Response editConf(@Valid @NotNull AppConfigResponse appConfigResponse) {
        try {
            this.log.info("Editing Admin UI editable configuration.");
            AppConfigResponse appConf = this.adminUIService.editAdminUIEditableConfiguration(appConfigResponse);
            this.log.info("Configuration edited");
            return Response.ok((Object)appConf).build();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.SAVE_ADMIUI_CONFIG_ERROR.getDescription(), (Throwable)e);
            return Response.status((int)e.getErrorCode()).entity((Object)CommonUtils.createGenericResponse(false, e.getErrorCode(), e.getMessage())).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.SAVE_ADMIUI_CONFIG_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, 500, e.getMessage())).build();
        }
    }

    @Operation(summary="Get all admin ui roles", description="Get all admin ui roles", operationId="get-all-adminui-roles", tags={"Admin UI - Role"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/role.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/role.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/role.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/read-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=AdminRole.class, description="List of AdminRole")))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="Bad Request"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="InternalServerError"))})})
    @GET
    @Path(value="/adminUIRoles")
    @Produces(value={"application/json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/role.readonly"}, groupScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/role.write"}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/role.admin", "https://jans.io/oauth/jans-auth-server/config/adminui/read-all"})
    public Response getAllRoles() {
        try {
            this.log.info("Get all Admin-UI roles.");
            List<AdminRole> roles = this.adminUIService.getAllRoles();
            this.log.info("Roles received from Auth Server.");
            return Response.ok(roles).build();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.GET_ADMIUI_ROLES_ERROR.getDescription(), (Throwable)e);
            return Response.status((int)e.getErrorCode()).entity((Object)CommonUtils.createGenericResponse(false, e.getErrorCode(), e.getMessage())).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.GET_ADMIUI_ROLES_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, 500, ErrorResponse.GET_ADMIUI_ROLES_ERROR.getDescription())).build();
        }
    }

    @Operation(summary="Add admin ui role", description="Add admin ui role", operationId="add-adminui-role", tags={"Admin UI - Role"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/role.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/role.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/write-all"})})
    @RequestBody(description="AdminRole object", content={@Content(mediaType="application/json", schema=@Schema(implementation=AdminRole.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=AdminRole.class, description="List of AdminRole")))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="Bad Request"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="InternalServerError"))})})
    @POST
    @Path(value="/adminUIRoles")
    @Produces(value={"application/json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/role.write"}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/role.admin", "https://jans.io/oauth/jans-auth-server/config/adminui/write-all"})
    public Response addRole(@Valid @NotNull AdminRole roleArg) {
        try {
            this.log.info("Adding Admin-UI role.");
            List<AdminRole> savedRoles = this.adminUIService.addRole(roleArg);
            this.log.info("Added Admin-UI role..");
            return Response.ok(savedRoles).build();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.SAVE_ADMIUI_ROLES_ERROR.getDescription(), (Throwable)e);
            return Response.status((int)e.getErrorCode()).entity((Object)CommonUtils.createGenericResponse(false, e.getErrorCode(), e.getMessage())).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.SAVE_ADMIUI_ROLES_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, 500, ErrorResponse.SAVE_ADMIUI_ROLES_ERROR.getDescription())).build();
        }
    }

    @Operation(summary="Edit admin ui role", description="Edit admin ui role", operationId="edit-adminui-role", tags={"Admin UI - Role"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/role.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/role.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/write-all"})})
    @RequestBody(description="AdminRole object", content={@Content(mediaType="application/json", schema=@Schema(implementation=AdminRole.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=AdminRole.class, description="List of  AdminRole")))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="Bad Request"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="InternalServerError"))})})
    @PUT
    @Path(value="/adminUIRoles")
    @Produces(value={"application/json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/role.write"}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/role.admin", "https://jans.io/oauth/jans-auth-server/config/adminui/write-all"})
    public Response editRole(@Valid @NotNull AdminRole roleArg) {
        try {
            this.log.info("Editing Admin-UI role.");
            List<AdminRole> savedRoles = this.adminUIService.editRole(roleArg);
            this.log.info("Edited Admin-UI role..");
            return Response.ok(savedRoles).build();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.EDIT_ADMIUI_ROLES_ERROR.getDescription(), (Throwable)e);
            return Response.status((int)e.getErrorCode()).entity((Object)CommonUtils.createGenericResponse(false, e.getErrorCode(), e.getMessage())).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.EDIT_ADMIUI_ROLES_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, 500, ErrorResponse.EDIT_ADMIUI_ROLES_ERROR.getDescription())).build();
        }
    }

    @Operation(summary="Get admin ui role details by role-name", description="Get admin ui role details by role-name", operationId="get-adminui-role", tags={"Admin UI - Role"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/role.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/role.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/role.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/read-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=AdminRole.class, description="List of AdminRole")))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="Bad Request"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="InternalServerError"))})})
    @GET
    @Path(value="/adminUIRoles/{adminUIRole}")
    @Produces(value={"application/json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/role.readonly"}, groupScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/role.write"}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/role.admin", "https://jans.io/oauth/jans-auth-server/config/adminui/read-all"})
    public Response getRole(@Parameter(description="Admin UI role") @PathParam(value="adminUIRole") @NotNull String adminUIRole) {
        try {
            this.log.info("Get all Admin-UI roles.");
            AdminRole roleObj = this.adminUIService.getRoleObjByName(adminUIRole);
            this.log.info("Roles received from Auth Server.");
            return Response.ok((Object)roleObj).build();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.GET_ADMIUI_ROLES_ERROR.getDescription(), (Throwable)e);
            return Response.status((int)e.getErrorCode()).entity((Object)CommonUtils.createGenericResponse(false, e.getErrorCode(), e.getMessage())).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.GET_ADMIUI_ROLES_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, 500, ErrorResponse.GET_ADMIUI_ROLES_ERROR.getDescription())).build();
        }
    }

    @Operation(summary="Delete admin ui role by role-name", description="Delete admin ui role by role-name", operationId="delete-adminui-role", tags={"Admin UI - Role"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/role.delete"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/role.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/delete-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=AdminRole.class, description="List of AdminRole")))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="Bad Request"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="InternalServerError"))})})
    @DELETE
    @Path(value="/adminUIRoles/{adminUIRole}")
    @Produces(value={"application/json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/role.delete"}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/role.admin", "https://jans.io/oauth/jans-auth-server/config/adminui/delete-all"})
    public Response deleteRole(@Parameter(description="Admin UI role") @PathParam(value="adminUIRole") @NotNull String adminUIRole) {
        try {
            this.log.info("Deleting Admin-UI role.");
            List<AdminRole> roles = this.adminUIService.deleteRole(adminUIRole);
            this.log.info("Deleted Admin-UI role..");
            return Response.ok(roles).build();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.ERROR_IN_MAPPING_ROLE_PERMISSION.getDescription(), (Throwable)e);
            return Response.status((int)e.getErrorCode()).entity((Object)CommonUtils.createGenericResponse(false, e.getErrorCode(), e.getMessage())).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.ERROR_IN_MAPPING_ROLE_PERMISSION.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, 500, ErrorResponse.ERROR_IN_MAPPING_ROLE_PERMISSION.getDescription())).build();
        }
    }

    @Operation(summary="Get all admin ui permissions", description="Get all admin ui permissions", operationId="get-all-adminui-permissions", tags={"Admin UI - Permission"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/read-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=AdminPermission.class, description="List of AdminPermission")))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="Bad Request"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="InternalServerError"))})})
    @GET
    @Path(value="/adminUIPermissions")
    @Produces(value={"application/json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.readonly"}, groupScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.write"}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.admin", "https://jans.io/oauth/jans-auth-server/config/adminui/read-all"})
    public Response getAllPermissions() {
        try {
            this.log.info("Get all Admin-UI permissions.");
            List<AdminPermission> permissions = this.adminUIService.getPermissions();
            this.log.info("Permissions received from Auth Server.");
            return Response.ok(permissions).build();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.GET_ADMIUI_PERMISSIONS_ERROR.getDescription(), (Throwable)e);
            return Response.status((int)e.getErrorCode()).entity((Object)CommonUtils.createGenericResponse(false, e.getErrorCode(), e.getMessage())).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.GET_ADMIUI_PERMISSIONS_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, 500, ErrorResponse.GET_ADMIUI_PERMISSIONS_ERROR.getDescription())).build();
        }
    }

    @Operation(summary="Add admin ui permissions", description="Add admin ui permissions", operationId="add-adminui-permission", tags={"Admin UI - Permission"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/write-all"})})
    @RequestBody(description="AdminPermission object", content={@Content(mediaType="application/json", schema=@Schema(implementation=AdminPermission.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=AdminPermission.class, description="List of AdminPermission")))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="Bad Request"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="InternalServerError"))})})
    @POST
    @Path(value="/adminUIPermissions")
    @Produces(value={"application/json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.write"}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.admin", "https://jans.io/oauth/jans-auth-server/config/adminui/write-all"})
    public Response addPermission(@Valid @NotNull AdminPermission permissionArg) {
        try {
            this.log.info("Adding Admin-UI permissions.");
            List<AdminPermission> savedPermissions = this.adminUIService.addPermission(permissionArg);
            this.log.info("Added Admin-UI permissions..");
            return Response.ok(savedPermissions).build();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.SAVE_ADMIUI_PERMISSIONS_ERROR.getDescription(), (Throwable)e);
            return Response.status((int)e.getErrorCode()).entity((Object)CommonUtils.createGenericResponse(false, e.getErrorCode(), e.getMessage())).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.SAVE_ADMIUI_PERMISSIONS_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, 500, ErrorResponse.SAVE_ADMIUI_PERMISSIONS_ERROR.getDescription())).build();
        }
    }

    @Operation(summary="Edit admin ui permissions", description="Edit admin ui permissions", operationId="edit-adminui-permission", tags={"Admin UI - Permission"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/write-all"})})
    @RequestBody(description="AdminPermission object", content={@Content(mediaType="application/json", schema=@Schema(implementation=AdminPermission.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=AdminPermission.class, description="List of AdminPermission")))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="Bad Request"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="InternalServerError"))})})
    @PUT
    @Path(value="/adminUIPermissions")
    @Produces(value={"application/json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.write"}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.admin", "https://jans.io/oauth/jans-auth-server/config/adminui/write-all"})
    public Response editPermission(@Valid @NotNull AdminPermission permissionArg) {
        try {
            this.log.info("Editing Admin-UI permissions.");
            List<AdminPermission> savedPermissions = this.adminUIService.editPermission(permissionArg);
            this.log.info("Edited Admin-UI permissions..");
            return Response.ok(savedPermissions).build();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.EDIT_ADMIUI_ROLES_ERROR.getDescription(), (Throwable)e);
            return Response.status((int)e.getErrorCode()).entity((Object)CommonUtils.createGenericResponse(false, e.getErrorCode(), e.getMessage())).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.EDIT_ADMIUI_ROLES_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, 500, ErrorResponse.EDIT_ADMIUI_ROLES_ERROR.getDescription())).build();
        }
    }

    @Operation(summary="Get admin ui permission by permission-name", description="Get admin ui permission by permission-name", operationId="get-adminui-permission", tags={"Admin UI - Permission"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/read-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=AdminPermission.class, description="List of AdminPermission")))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="Bad Request"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="InternalServerError"))})})
    @GET
    @Path(value="/adminUIPermissions/{adminUIPermission}")
    @Produces(value={"application/json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.readonly"}, groupScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.write"}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.admin", "https://jans.io/oauth/jans-auth-server/config/adminui/read-all"})
    public Response getPermission(@Parameter(description="Admin UI Permission") @PathParam(value="adminUIPermission") @NotNull String adminUIPermission) {
        try {
            this.log.info("Get Admin-UI permission.");
            AdminPermission permissionObj = this.adminUIService.getPermissionObjByName(adminUIPermission);
            this.log.info("Permission received from Auth Server.");
            return Response.ok((Object)permissionObj).build();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.GET_ADMIUI_PERMISSIONS_ERROR.getDescription(), (Throwable)e);
            return Response.status((int)e.getErrorCode()).entity((Object)CommonUtils.createGenericResponse(false, e.getErrorCode(), e.getMessage())).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.GET_ADMIUI_PERMISSIONS_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, 500, ErrorResponse.GET_ADMIUI_PERMISSIONS_ERROR.getDescription())).build();
        }
    }

    @Operation(summary="Delete admin ui permission", description="Delete admin ui permission", operationId="delete-adminui-permission", tags={"Admin UI - Permission"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.delete"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/delete-all"})})
    @RequestBody(description="AdminPermission object", content={@Content(mediaType="application/json", schema=@Schema(implementation=AdminPermission.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=AdminPermission.class, description="List of AdminPermission")))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="Bad Request"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="InternalServerError"))})})
    @DELETE
    @Path(value="/adminUIPermissions")
    @Produces(value={"application/json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.delete"}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.admin", "https://jans.io/oauth/jans-auth-server/config/adminui/delete-all"})
    public Response deletePermission(@Valid @NotNull AdminPermission permissionArg) {
        try {
            String adminUIPermission = null;
            if (permissionArg != null) {
                adminUIPermission = permissionArg.getPermission();
            }
            this.log.info("Deleting Admin-UI permission.");
            List<AdminPermission> permissions = this.adminUIService.deletePermission(adminUIPermission);
            this.log.info("Deleted Admin-UI permission..");
            return Response.ok(permissions).build();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.DELETE_ADMIUI_PERMISSIONS_ERROR.getDescription(), (Throwable)e);
            return Response.status((int)e.getErrorCode()).entity((Object)CommonUtils.createGenericResponse(false, e.getErrorCode(), e.getMessage())).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.DELETE_ADMIUI_PERMISSIONS_ERROR.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, 500, ErrorResponse.DELETE_ADMIUI_PERMISSIONS_ERROR.getDescription())).build();
        }
    }

    @Operation(summary="Get all admin ui role-permissions mapping", description="Get all admin ui role-permissions mapping", operationId="get-all-adminui-role-permissions", tags={"Admin UI - Role-Permissions Mapping"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/rolePermissionMapping.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/rolePermissionMapping.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/read-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=RolePermissionMapping.class, description="List of RolePermissionMapping")))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="Bad Request"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="InternalServerError"))})})
    @GET
    @Path(value="/adminUIRolePermissionsMapping")
    @Produces(value={"application/json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/rolePermissionMapping.readonly"}, groupScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/rolePermissionMapping.write"}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.admin", "https://jans.io/oauth/jans-auth-server/config/adminui/read-all"})
    public Response getAllAdminUIRolePermissionsMapping() {
        try {
            this.log.info("Get all Admin-UI role-permissions mapping.");
            List<RolePermissionMapping> roleScopeMapping = this.adminUIService.getAllAdminUIRolePermissionsMapping();
            this.log.info("Role-Permissions mapping received from Auth Server.");
            return Response.ok(roleScopeMapping).build();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.ERROR_READING_ROLE_PERMISSION_MAP.getDescription(), (Throwable)e);
            return Response.status((int)e.getErrorCode()).entity((Object)CommonUtils.createGenericResponse(false, e.getErrorCode(), e.getMessage())).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.ERROR_READING_ROLE_PERMISSION_MAP.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, 500, ErrorResponse.ERROR_READING_ROLE_PERMISSION_MAP.getDescription())).build();
        }
    }

    @Operation(summary="Add role-permissions mapping", description="Add role-permissions mapping", operationId="add-role-permissions-mapping", tags={"Admin UI - Role-Permissions Mapping"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/rolePermissionMapping.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/write-all"})})
    @RequestBody(description="RolePermissionMapping object", content={@Content(mediaType="application/json", schema=@Schema(implementation=RolePermissionMapping.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=RolePermissionMapping.class, description="List of RolePermissionMapping")))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="Bad Request"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="InternalServerError"))})})
    @POST
    @Path(value="/adminUIRolePermissionsMapping")
    @Produces(value={"application/json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/rolePermissionMapping.write"}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.admin", "https://jans.io/oauth/jans-auth-server/config/adminui/write-all"})
    public Response addPermissionsToRole(@Valid @NotNull RolePermissionMapping rolePermissionMappingArg) {
        try {
            this.log.info("Adding role-permissions to Admin-UI.");
            List<RolePermissionMapping> roleScopeMapping = this.adminUIService.addPermissionsToRole(rolePermissionMappingArg);
            this.log.info("Added role-permissions to Admin-UI..");
            return Response.ok(roleScopeMapping).build();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.ERROR_IN_MAPPING_ROLE_PERMISSION.getDescription(), (Throwable)e);
            return Response.status((int)e.getErrorCode()).entity((Object)CommonUtils.createGenericResponse(false, e.getErrorCode(), e.getMessage())).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.ERROR_IN_MAPPING_ROLE_PERMISSION.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, 500, ErrorResponse.ERROR_IN_MAPPING_ROLE_PERMISSION.getDescription())).build();
        }
    }

    @Operation(summary="Map permissions to role", description="Map permissions to role", operationId="map-permissions-to-role", tags={"Admin UI - Role-Permissions Mapping"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/rolePermissionMapping.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/write-all"})})
    @RequestBody(description="RolePermissionMapping object", content={@Content(mediaType="application/json", schema=@Schema(implementation=RolePermissionMapping.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=RolePermissionMapping.class, description="List of RolePermissionMapping")))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="Bad Request"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="InternalServerError"))})})
    @PUT
    @Path(value="/adminUIRolePermissionsMapping")
    @Produces(value={"application/json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/rolePermissionMapping.write"}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.admin", "https://jans.io/oauth/jans-auth-server/config/adminui/write-all"})
    public Response mapPermissionsToRole(@Valid @NotNull RolePermissionMapping rolePermissionMappingArg) {
        try {
            this.log.info("Mapping permissions to Admin-UI role.");
            List<RolePermissionMapping> roleScopeMapping = this.adminUIService.mapPermissionsToRole(rolePermissionMappingArg);
            this.log.info("Mapped permissions to Admin-UI role..");
            return Response.ok(roleScopeMapping).build();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.ERROR_IN_MAPPING_ROLE_PERMISSION.getDescription(), (Throwable)e);
            return Response.status((int)e.getErrorCode()).entity((Object)CommonUtils.createGenericResponse(false, e.getErrorCode(), e.getMessage())).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.ERROR_IN_MAPPING_ROLE_PERMISSION.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, 500, ErrorResponse.ERROR_IN_MAPPING_ROLE_PERMISSION.getDescription())).build();
        }
    }

    @Operation(summary="Get admin ui role-permissions mapping by role-name", description="Get admin ui role-permissions mapping by role-name", operationId="get-adminui-role-permissions", tags={"Admin UI - Role-Permissions Mapping"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/rolePermissionMapping.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/rolePermissionMapping.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/read-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=RolePermissionMapping.class, description="List of RolePermissionMapping")))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="Bad Request"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="InternalServerError"))})})
    @GET
    @Path(value="/adminUIRolePermissionsMapping/{adminUIRole}")
    @Produces(value={"application/json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/rolePermissionMapping.readonly"}, groupScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/rolePermissionMapping.write"}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.admin", "https://jans.io/oauth/jans-auth-server/config/adminui/read-all"})
    public Response getAdminUIRolePermissionsMapping(@Parameter(description="Admin UI Role") @PathParam(value="adminUIRole") @NotNull String adminUIRole) {
        try {
            this.log.info("Get Admin-UI role-permissions mapping by role-name.");
            RolePermissionMapping roleScopeMapping = this.adminUIService.getAdminUIRolePermissionsMapping(adminUIRole);
            this.log.info("Role-Permissions mapping received from Auth Server.");
            return Response.ok((Object)roleScopeMapping).build();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.ERROR_READING_ROLE_PERMISSION_MAP.getDescription(), (Throwable)e);
            return Response.status((int)e.getErrorCode()).entity((Object)CommonUtils.createGenericResponse(false, e.getErrorCode(), e.getMessage())).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.ERROR_READING_ROLE_PERMISSION_MAP.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, 500, ErrorResponse.ERROR_READING_ROLE_PERMISSION_MAP.getDescription())).build();
        }
    }

    @Operation(summary="Remove role-permissions mapping by role-name", description="Remove role-permissions mapping by role-name", operationId="remove-role-permissions-permission", tags={"Admin UI - Role-Permissions Mapping"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/rolePermissionMapping.delete"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/delete-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=RolePermissionMapping.class, description="List of RolePermissionMapping")))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="Bad Request"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=GenericResponse.class, description="InternalServerError"))})})
    @DELETE
    @Path(value="/adminUIRolePermissionsMapping/{adminUIRole}")
    @Produces(value={"application/json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/rolePermissionMapping.delete"}, superScopes={"https://jans.io/oauth/jans-auth-server/config/adminui/user/permission.admin", "https://jans.io/oauth/jans-auth-server/config/adminui/delete-all"})
    public Response removePermissionsFromRole(@Parameter(description="role") @PathParam(value="adminUIRole") @NotNull String role) {
        try {
            this.log.info("Removing permissions to Admin-UI role.");
            List<RolePermissionMapping> roleScopeMapping = this.adminUIService.removePermissionsFromRole(role);
            this.log.info("Removed permissions to Admin-UI role..");
            return Response.ok(roleScopeMapping).build();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.ERROR_IN_DELETING_ROLE_PERMISSION.getDescription(), (Throwable)e);
            return Response.status((int)e.getErrorCode()).entity((Object)CommonUtils.createGenericResponse(false, e.getErrorCode(), e.getMessage())).build();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.ERROR_IN_DELETING_ROLE_PERMISSION.getDescription(), (Throwable)e);
            return Response.serverError().entity((Object)CommonUtils.createGenericResponse(false, 500, ErrorResponse.ERROR_IN_DELETING_ROLE_PERMISSION.getDescription())).build();
        }
    }
}

