/*
 * Decompiled with CFR 0.152.
 */
package io.jans.ca.plugin.adminui.service.adminui;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import io.jans.as.model.config.adminui.AdminRole;
import io.jans.as.model.config.adminui.RolePermissionMapping;
import io.jans.ca.plugin.adminui.model.adminui.AdminUIResourceScopesMapping;
import io.jans.ca.plugin.adminui.model.auth.AppConfigResponse;
import io.jans.ca.plugin.adminui.model.auth.GenericResponse;
import io.jans.ca.plugin.adminui.model.exception.ApplicationException;
import io.jans.ca.plugin.adminui.service.adminui.AdminUIService;
import io.jans.ca.plugin.adminui.service.config.AUIConfigurationService;
import io.jans.ca.plugin.adminui.utils.ClientFactory;
import io.jans.ca.plugin.adminui.utils.CommonUtils;
import io.jans.ca.plugin.adminui.utils.ErrorResponse;
import io.jans.ca.plugin.adminui.utils.security.PolicyStoreMapperHelper;
import io.jans.configapi.core.model.adminui.AUIConfiguration;
import io.jans.configapi.core.model.adminui.CedarlingPolicyStrRetrievalPoint;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.search.filter.Filter;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Response;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;

@Singleton
public class AdminUISecurityService {
    @Inject
    Logger log;
    @Inject
    private PersistenceEntryManager entryManager;
    @Inject
    AUIConfigurationService auiConfigurationService;
    @Inject
    AdminUIService adminUIService;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public GenericResponse getPolicyStore() throws ApplicationException {
        try {
            AUIConfiguration auiConfiguration = this.auiConfigurationService.getAUIConfiguration();
            if (auiConfiguration.getCedarlingPolicyStoreRetrievalPoint() == CedarlingPolicyStrRetrievalPoint.REMOTE && !Strings.isNullOrEmpty((String)auiConfiguration.getAuiCedarlingPolicyStoreUrl())) {
                Invocation.Builder request = ClientFactory.instance().getClientBuilder(auiConfiguration.getAuiCedarlingPolicyStoreUrl());
                request.header("Content-Type", (Object)"application/json");
                Response response = request.get();
                this.log.info("policy store request status code: {}", (Object)response.getStatus());
                if (response.getStatus() == 200) {
                    String entity = (String)response.readEntity(String.class);
                    JsonNode policyStoreJsonNode = (JsonNode)MAPPER.readValue(entity, JsonNode.class);
                    return CommonUtils.createGenericResponse(true, 200, "Policy store fetched successfully.", policyStoreJsonNode);
                }
                String jsonData = (String)response.readEntity(String.class);
                this.log.error("{}: {}", (Object)ErrorResponse.RETRIEVE_POLICY_STORE_ERROR, (Object)jsonData);
                return CommonUtils.createGenericResponse(false, response.getStatus(), jsonData);
            }
            String policyStorePath = Optional.ofNullable(auiConfiguration.getAuiCedarlingDefaultPolicyStorePath()).filter(path -> !Strings.isNullOrEmpty((String)path)).orElse("./custom/config/adminUI/admin-ui-policy-store.json");
            Path path2 = Paths.get(policyStorePath, new String[0]);
            this.log.debug("Absolute path of policy-store file: {}", (Object)path2.toAbsolutePath());
            byte[] jsonBytes = Files.readAllBytes(path2);
            JsonNode policyStoreJsonNode = MAPPER.readTree(jsonBytes);
            return CommonUtils.createGenericResponse(true, 200, "Policy store fetched successfully.", policyStoreJsonNode);
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.RETRIEVE_POLICY_STORE_ERROR.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.RETRIEVE_POLICY_STORE_ERROR.getDescription());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GenericResponse setRemotePolicyStoreAsDefault() throws ApplicationException {
        try {
            AUIConfiguration auiConfiguration = this.auiConfigurationService.getAUIConfiguration();
            if (auiConfiguration.getCedarlingPolicyStoreRetrievalPoint() == CedarlingPolicyStrRetrievalPoint.DEFAULT) return CommonUtils.createGenericResponse(false, 500, "Either remote policy-store URL is not configured or it is not enabled for use.");
            if (Strings.isNullOrEmpty((String)auiConfiguration.getAuiCedarlingPolicyStoreUrl())) {
                return CommonUtils.createGenericResponse(false, 500, "Either remote policy-store URL is not configured or it is not enabled for use.");
            }
            Invocation.Builder request = ClientFactory.instance().getClientBuilder(auiConfiguration.getAuiCedarlingPolicyStoreUrl()).header("Content-Type", (Object)"application/json");
            try (Response response = request.get();){
                int status = response.getStatus();
                this.log.info("Policy store request status code: {}", (Object)status);
                if (status == 200) {
                    String responseEntity = (String)response.readEntity(String.class);
                    JsonNode policyStoreJson = MAPPER.readTree(responseEntity);
                    String policyStorePath = Optional.ofNullable(auiConfiguration.getAuiCedarlingDefaultPolicyStorePath()).filter(path -> !Strings.isNullOrEmpty((String)path)).orElse("./custom/config/adminUI/admin-ui-policy-store.json");
                    Path path2 = Paths.get(policyStorePath, new String[0]);
                    MAPPER.writerWithDefaultPrettyPrinter().writeValue(path2.toFile(), (Object)policyStoreJson);
                    AppConfigResponse appConfigResponse = new AppConfigResponse();
                    appConfigResponse.setCedarlingPolicyStoreRetrievalPoint(CedarlingPolicyStrRetrievalPoint.DEFAULT);
                    this.adminUIService.editAdminUIEditableConfiguration(appConfigResponse);
                    this.log.info("Default policy-store overwritten successfully from remote source: {}", (Object)policyStorePath);
                    GenericResponse genericResponse2 = CommonUtils.createGenericResponse(true, 200, "Policy store fetched and overwritten successfully.");
                    return genericResponse2;
                }
                String errorResponse = (String)response.readEntity(String.class);
                this.log.error("{}: {}", (Object)ErrorResponse.REWRITING_DEFAULT_POLICY_STORE_ERROR, (Object)errorResponse);
                GenericResponse genericResponse = CommonUtils.createGenericResponse(false, status, errorResponse);
                return genericResponse;
            }
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.RETRIEVE_POLICY_STORE_ERROR.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.RETRIEVE_POLICY_STORE_ERROR.getDescription());
        }
    }

    public GenericResponse syncRoleScopeMapping() throws ApplicationException {
        try {
            Filter filter = Filter.createPresenceFilter((String)"jansResource");
            List adminUIResourceScopesMappings = this.entryManager.findEntries("ou=adminUIResourceScopesMapping,ou=admin-ui,o=jans", AdminUIResourceScopesMapping.class, filter);
            JsonNode resourceScopesJson = CommonUtils.toJsonNode(adminUIResourceScopesMappings);
            JsonNode policyStoreJson = this.getPolicyStore().getResponseObject();
            if (resourceScopesJson == null || policyStoreJson == null) {
                throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), "Invalid input data for synchronization");
            }
            Map<String, Set<String>> principalsToScopesMap = PolicyStoreMapperHelper.mapPrincipalsToScopes(policyStoreJson, resourceScopesJson);
            if (principalsToScopesMap.isEmpty()) {
                this.log.warn("No principal-to-scope mappings found during synchronization");
            }
            List<AdminRole> roles = this.createAdminRoles(principalsToScopesMap.keySet());
            List<RolePermissionMapping> rolePermissionMappings = this.createRolePermissionMappings(principalsToScopesMap);
            List<RolePermissionMapping> updatedMappings = this.removeDuplicatePermissions(rolePermissionMappings);
            this.adminUIService.resetRoles(roles);
            this.adminUIService.resetPermissionsToRole(updatedMappings);
            return CommonUtils.createGenericResponse(true, 200, "Sync of role-to-scope mappings from the policy store completed successfully.");
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.SYNC_ROLE_SCOPES_MAPPING_ERROR.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.SYNC_ROLE_SCOPES_MAPPING_ERROR.getDescription());
        }
    }

    private List<AdminRole> createAdminRoles(Set<String> roleNames) {
        return roleNames.stream().map(roleName -> {
            AdminRole role = new AdminRole();
            role.setRole(roleName);
            role.setDescription("Role created after parsing policy-store for " + roleName);
            role.setDeletable(Boolean.valueOf(true));
            return role;
        }).collect(Collectors.toList());
    }

    private List<RolePermissionMapping> createRolePermissionMappings(Map<String, Set<String>> principalsToScopesMap) {
        return principalsToScopesMap.entrySet().stream().map(entry -> {
            RolePermissionMapping rpm = new RolePermissionMapping();
            rpm.setRole((String)entry.getKey());
            rpm.setPermissions(new ArrayList((Collection)entry.getValue()));
            return rpm;
        }).collect(Collectors.toList());
    }

    private List<RolePermissionMapping> removeDuplicatePermissions(List<RolePermissionMapping> rolePermissionMappings) {
        return rolePermissionMappings.stream().map(entry -> {
            RolePermissionMapping rpm = new RolePermissionMapping();
            rpm.setRole(entry.getRole());
            rpm.setPermissions(new ArrayList(new LinkedHashSet(entry.getPermissions())));
            return rpm;
        }).collect(Collectors.toList());
    }
}

