/*
 * Decompiled with CFR 0.152.
 */
package io.jans.ca.plugin.adminui.service.adminui;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.jans.as.model.config.adminui.AdminConf;
import io.jans.as.model.config.adminui.AdminPermission;
import io.jans.as.model.config.adminui.AdminRole;
import io.jans.as.model.config.adminui.RolePermissionMapping;
import io.jans.ca.plugin.adminui.model.auth.AppConfigResponse;
import io.jans.ca.plugin.adminui.model.exception.ApplicationException;
import io.jans.ca.plugin.adminui.service.config.AUIConfigurationService;
import io.jans.ca.plugin.adminui.utils.CommonUtils;
import io.jans.ca.plugin.adminui.utils.ErrorResponse;
import io.jans.configapi.core.model.adminui.AUIConfiguration;
import io.jans.orm.PersistenceEntryManager;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;

@Singleton
public class AdminUIService {
    @Inject
    Logger log;
    @Inject
    private PersistenceEntryManager entryManager;
    @Inject
    AUIConfigurationService auiConfigurationService;

    public AppConfigResponse getAdminUIEditableConfiguration() throws ApplicationException {
        try {
            AUIConfiguration auiConfiguration = this.auiConfigurationService.getAUIConfiguration();
            AppConfigResponse appConfigResponse = new AppConfigResponse();
            appConfigResponse.setAuthServerHost(auiConfiguration.getAuiWebServerHost());
            appConfigResponse.setAuthzBaseUrl(auiConfiguration.getAuiWebServerAuthzBaseUrl());
            appConfigResponse.setClientId(auiConfiguration.getAuiWebServerClientId());
            appConfigResponse.setResponseType("code");
            appConfigResponse.setScope(auiConfiguration.getAuiWebServerScope());
            appConfigResponse.setRedirectUrl(auiConfiguration.getAuiWebServerRedirectUrl());
            appConfigResponse.setAcrValues(auiConfiguration.getAuiWebServerAcrValues());
            appConfigResponse.setFrontChannelLogoutUrl(auiConfiguration.getAuiWebServerFrontChannelLogoutUrl());
            appConfigResponse.setPostLogoutRedirectUri(auiConfiguration.getAuiWebServerPostLogoutRedirectUri());
            appConfigResponse.setEndSessionEndpoint(auiConfiguration.getAuiWebServerEndSessionEndpoint());
            appConfigResponse.setSessionTimeoutInMins(auiConfiguration.getSessionTimeoutInMins());
            appConfigResponse.setAllowSmtpKeystoreEdit(auiConfiguration.getAllowSmtpKeystoreEdit());
            appConfigResponse.setAdditionalParameters(auiConfiguration.getAdditionalParameters());
            appConfigResponse.setCedarlingLogType(auiConfiguration.getCedarlingLogType());
            appConfigResponse.setAuiPolicyStoreUrl(auiConfiguration.getAuiCedarlingPolicyStoreUrl());
            appConfigResponse.setAuiDefaultPolicyStorePath(auiConfiguration.getAuiCedarlingDefaultPolicyStorePath());
            appConfigResponse.setCedarlingPolicyStoreRetrievalPoint(auiConfiguration.getCedarlingPolicyStoreRetrievalPoint());
            return appConfigResponse;
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.GET_ADMIUI_CONFIG_ERROR.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.GET_ADMIUI_CONFIG_ERROR.getDescription());
        }
    }

    public AppConfigResponse editAdminUIEditableConfiguration(AppConfigResponse appConfigResponse) throws ApplicationException {
        try {
            AdminConf adminConf = (AdminConf)this.entryManager.find(AdminConf.class, (Object)"ou=admin-ui,ou=configuration,o=jans");
            if (!Strings.isNullOrEmpty((String)appConfigResponse.getAcrValues())) {
                adminConf.getMainSettings().getOidcConfig().getAuiWebClient().setAcrValues((List)Lists.newArrayList((Object[])new String[]{appConfigResponse.getAcrValues()}));
                this.auiConfigurationService.getAUIConfiguration().setAuiWebServerAcrValues(appConfigResponse.getAcrValues());
            }
            if (appConfigResponse.getSessionTimeoutInMins() != null) {
                adminConf.getMainSettings().getUiConfig().setSessionTimeoutInMins(appConfigResponse.getSessionTimeoutInMins());
                this.auiConfigurationService.getAUIConfiguration().setSessionTimeoutInMins(appConfigResponse.getSessionTimeoutInMins());
            }
            if (!CollectionUtils.isEmpty(appConfigResponse.getAdditionalParameters())) {
                adminConf.getMainSettings().getOidcConfig().getAuiWebClient().setAdditionalParameters(appConfigResponse.getAdditionalParameters());
                this.auiConfigurationService.getAUIConfiguration().setAdditionalParameters(appConfigResponse.getAdditionalParameters());
            }
            if (appConfigResponse.getAllowSmtpKeystoreEdit() != null) {
                adminConf.getMainSettings().getUiConfig().setAllowSmtpKeystoreEdit(appConfigResponse.getAllowSmtpKeystoreEdit());
                this.auiConfigurationService.getAUIConfiguration().setAllowSmtpKeystoreEdit(appConfigResponse.getAllowSmtpKeystoreEdit());
            }
            if (appConfigResponse.getCedarlingLogType() != null) {
                adminConf.getMainSettings().getUiConfig().setCedarlingLogType(appConfigResponse.getCedarlingLogType().getValue());
                this.auiConfigurationService.getAUIConfiguration().setCedarlingLogType(appConfigResponse.getCedarlingLogType());
            }
            if (!Strings.isNullOrEmpty((String)appConfigResponse.getAuiPolicyStoreUrl())) {
                adminConf.getMainSettings().getUiConfig().setAuiPolicyStoreUrl(appConfigResponse.getAuiPolicyStoreUrl());
                this.auiConfigurationService.getAUIConfiguration().setAuiCedarlingPolicyStoreUrl(appConfigResponse.getAuiPolicyStoreUrl());
            }
            if (appConfigResponse.getCedarlingPolicyStoreRetrievalPoint() != null) {
                adminConf.getMainSettings().getUiConfig().setCedarlingPolicyStoreRetrievalPoint(appConfigResponse.getCedarlingPolicyStoreRetrievalPoint().toString());
                this.auiConfigurationService.getAUIConfiguration().setCedarlingPolicyStoreRetrievalPoint(appConfigResponse.getCedarlingPolicyStoreRetrievalPoint());
            }
            if (!Strings.isNullOrEmpty((String)appConfigResponse.getAuiDefaultPolicyStorePath())) {
                adminConf.getMainSettings().getUiConfig().setAuiDefaultPolicyStorePath(appConfigResponse.getAuiDefaultPolicyStorePath());
                this.auiConfigurationService.getAUIConfiguration().setAuiCedarlingDefaultPolicyStorePath(appConfigResponse.getAuiDefaultPolicyStorePath());
            }
            this.entryManager.merge((Object)adminConf);
            return this.getAdminUIEditableConfiguration();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.SAVE_ADMIUI_CONFIG_ERROR.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.SAVE_ADMIUI_CONFIG_ERROR.getDescription());
        }
    }

    public List<AdminRole> getAllRoles() throws ApplicationException {
        try {
            AdminConf adminConf = (AdminConf)this.entryManager.find(AdminConf.class, (Object)"ou=admin-ui,ou=configuration,o=jans");
            return adminConf.getDynamic().getRoles();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.GET_ADMIUI_ROLES_ERROR.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.GET_ADMIUI_ROLES_ERROR.getDescription());
        }
    }

    public AdminRole getRoleObjByName(String role) throws ApplicationException {
        try {
            AdminConf adminConf = (AdminConf)this.entryManager.find(AdminConf.class, (Object)"ou=admin-ui,ou=configuration,o=jans");
            List roles = adminConf.getDynamic().getRoles().stream().filter(ele -> ele.getRole().equals(role)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(roles)) {
                return (AdminRole)roles.get(0);
            }
            this.log.error(ErrorResponse.ROLE_NOT_FOUND.getDescription());
            throw new ApplicationException(Response.Status.NOT_FOUND.getStatusCode(), ErrorResponse.ROLE_NOT_FOUND.getDescription());
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.GET_ADMIUI_ROLES_ERROR.getDescription());
            throw e;
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.GET_ADMIUI_ROLES_ERROR.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.GET_ADMIUI_ROLES_ERROR.getDescription());
        }
    }

    public List<AdminRole> addRole(AdminRole roleArg) throws ApplicationException {
        try {
            AdminConf adminConf = (AdminConf)this.entryManager.find(AdminConf.class, (Object)"ou=admin-ui,ou=configuration,o=jans");
            List roles = adminConf.getDynamic().getRoles();
            if (roles.contains(roleArg)) {
                this.log.error(ErrorResponse.ADMIUI_ROLE_ALREADY_PRESENT.getDescription());
                throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.ADMIUI_ROLE_ALREADY_PRESENT.getDescription());
            }
            roles.add(roleArg);
            adminConf.getDynamic().setRoles(roles);
            this.entryManager.merge((Object)adminConf);
            return adminConf.getDynamic().getRoles();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.SAVE_ADMIUI_ROLES_ERROR.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.SAVE_ADMIUI_ROLES_ERROR.getDescription());
        }
    }

    public List<AdminRole> resetRoles(List<AdminRole> roleArgs) throws ApplicationException {
        try {
            AdminConf adminConf = (AdminConf)this.entryManager.find(AdminConf.class, (Object)"ou=admin-ui,ou=configuration,o=jans");
            adminConf.getDynamic().setRoles(roleArgs);
            this.entryManager.merge((Object)adminConf);
            return adminConf.getDynamic().getRoles();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.SAVE_ADMIUI_ROLES_ERROR.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.SAVE_ADMIUI_ROLES_ERROR.getDescription());
        }
    }

    public List<AdminRole> editRole(AdminRole roleArg) throws ApplicationException {
        try {
            AdminConf adminConf = (AdminConf)this.entryManager.find(AdminConf.class, (Object)"ou=admin-ui,ou=configuration,o=jans");
            List roles = adminConf.getDynamic().getRoles();
            if (roles.stream().noneMatch(ele -> ele.equals((Object)roleArg))) {
                this.log.error(ErrorResponse.ROLE_NOT_FOUND.getDescription());
                throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.ROLE_NOT_FOUND.getDescription());
            }
            roles.removeIf(ele -> ele.equals((Object)roleArg));
            roles.add(roleArg);
            adminConf.getDynamic().setRoles(roles);
            this.entryManager.merge((Object)adminConf);
            return adminConf.getDynamic().getRoles();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.EDIT_ADMIUI_ROLES_ERROR.getDescription());
            throw e;
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.EDIT_ADMIUI_ROLES_ERROR.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.EDIT_ADMIUI_ROLES_ERROR.getDescription());
        }
    }

    public List<AdminRole> deleteRole(String role) throws ApplicationException {
        try {
            AdminConf adminConf = (AdminConf)this.entryManager.find(AdminConf.class, (Object)"ou=admin-ui,ou=configuration,o=jans");
            List roleScopeMapping = adminConf.getDynamic().getRolePermissionMapping().stream().filter(ele -> ele.getRole().equalsIgnoreCase(role)).collect(Collectors.toList());
            if (!roleScopeMapping.isEmpty()) {
                Optional rolePermissionMappingOptional = roleScopeMapping.stream().findAny();
                List permissions = Lists.newArrayList();
                if (rolePermissionMappingOptional.isPresent()) {
                    permissions = ((RolePermissionMapping)rolePermissionMappingOptional.get()).getPermissions();
                }
                if (!permissions.isEmpty()) {
                    this.log.error(ErrorResponse.UNABLE_TO_DELETE_ROLE_MAPPED_TO_PERMISSIONS.getDescription());
                    throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.UNABLE_TO_DELETE_ROLE_MAPPED_TO_PERMISSIONS.getDescription());
                }
            }
            List roles = adminConf.getDynamic().getRoles();
            if (!Optional.ofNullable(this.getRoleObjByName(role).getDeletable()).orElse(false).booleanValue()) {
                this.log.error(ErrorResponse.ROLE_MARKED_UNDELETABLE.getDescription());
                throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.ROLE_MARKED_UNDELETABLE.getDescription());
            }
            roles.removeIf(ele -> ele.getRole().equals(role));
            adminConf.getDynamic().setRoles(roles);
            this.entryManager.merge((Object)adminConf);
            return adminConf.getDynamic().getRoles();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.DELETE_ADMIUI_ROLES_ERROR.getDescription());
            throw e;
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.DELETE_ADMIUI_ROLES_ERROR.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.DELETE_ADMIUI_ROLES_ERROR.getDescription());
        }
    }

    public List<AdminPermission> getPermissions() throws ApplicationException {
        try {
            AdminConf adminConf = (AdminConf)this.entryManager.find(AdminConf.class, (Object)"ou=admin-ui,ou=configuration,o=jans");
            return adminConf.getDynamic().getPermissions();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.GET_ADMIUI_PERMISSIONS_ERROR.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.GET_ADMIUI_PERMISSIONS_ERROR.getDescription());
        }
    }

    public AdminPermission getPermissionObjByName(String permission) throws ApplicationException {
        try {
            AdminConf adminConf = (AdminConf)this.entryManager.find(AdminConf.class, (Object)"ou=admin-ui,ou=configuration,o=jans");
            List permissions = adminConf.getDynamic().getPermissions().stream().filter(ele -> ele.getPermission().equals(permission)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(permissions)) {
                return (AdminPermission)permissions.get(0);
            }
            this.log.error(ErrorResponse.ROLE_NOT_FOUND.getDescription());
            throw new ApplicationException(Response.Status.NOT_FOUND.getStatusCode(), ErrorResponse.PERMISSION_NOT_FOUND.getDescription());
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.GET_ADMIUI_PERMISSIONS_ERROR.getDescription());
            throw e;
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.GET_ADMIUI_PERMISSIONS_ERROR.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.GET_ADMIUI_ROLES_ERROR.getDescription());
        }
    }

    public List<AdminPermission> addPermission(AdminPermission permissionArg) throws ApplicationException {
        try {
            AdminConf adminConf = (AdminConf)this.entryManager.find(AdminConf.class, (Object)"ou=admin-ui,ou=configuration,o=jans");
            List permissions = adminConf.getDynamic().getPermissions();
            if (permissions.contains(permissionArg)) {
                this.log.error(ErrorResponse.ADMIUI_PERMISSIONS_ALREADY_PRESENT.getDescription());
                throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.ADMIUI_PERMISSIONS_ALREADY_PRESENT.getDescription());
            }
            permissions.add(permissionArg);
            adminConf.getDynamic().setPermissions(permissions);
            this.entryManager.merge((Object)adminConf);
            return adminConf.getDynamic().getPermissions();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.SAVE_ADMIUI_PERMISSIONS_ERROR.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.SAVE_ADMIUI_PERMISSIONS_ERROR.getDescription());
        }
    }

    public List<AdminPermission> editPermission(AdminPermission permissionArg) throws ApplicationException {
        try {
            AdminConf adminConf = (AdminConf)this.entryManager.find(AdminConf.class, (Object)"ou=admin-ui,ou=configuration,o=jans");
            List permissions = adminConf.getDynamic().getPermissions();
            if (permissions.stream().noneMatch(ele -> ele.equals((Object)permissionArg))) {
                this.log.error(ErrorResponse.PERMISSION_NOT_FOUND.getDescription());
                throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.PERMISSION_NOT_FOUND.getDescription());
            }
            permissions.removeIf(ele -> ele.equals((Object)permissionArg));
            permissions.add(permissionArg);
            adminConf.getDynamic().setPermissions(permissions);
            this.entryManager.merge((Object)adminConf);
            return adminConf.getDynamic().getPermissions();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.EDIT_ADMIUI_PERMISSIONS_ERROR.getDescription());
            throw e;
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.EDIT_ADMIUI_PERMISSIONS_ERROR.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.EDIT_ADMIUI_PERMISSIONS_ERROR.getDescription());
        }
    }

    public List<AdminPermission> deletePermission(String permission) throws ApplicationException {
        try {
            String decodedPermission = CommonUtils.decode(permission);
            AdminConf adminConf = (AdminConf)this.entryManager.find(AdminConf.class, (Object)"ou=admin-ui,ou=configuration,o=jans");
            boolean anyPermissionMapped = adminConf.getDynamic().getRolePermissionMapping().stream().anyMatch(ele -> ele.getPermissions().contains(decodedPermission));
            if (anyPermissionMapped) {
                this.log.error(ErrorResponse.UNABLE_TO_DELETE_PERMISSION_MAPPED_TO_ROLE.getDescription());
                throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.UNABLE_TO_DELETE_PERMISSION_MAPPED_TO_ROLE.getDescription());
            }
            List permissions = adminConf.getDynamic().getPermissions();
            permissions.removeIf(ele -> ele.getPermission().equals(decodedPermission));
            adminConf.getDynamic().setPermissions(permissions);
            this.entryManager.merge((Object)adminConf);
            return adminConf.getDynamic().getPermissions();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.DELETE_ADMIUI_PERMISSIONS_ERROR.getDescription());
            throw e;
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.DELETE_ADMIUI_PERMISSIONS_ERROR.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.DELETE_ADMIUI_PERMISSIONS_ERROR.getDescription());
        }
    }

    public List<RolePermissionMapping> getAllAdminUIRolePermissionsMapping() throws ApplicationException {
        try {
            AdminConf adminConf = (AdminConf)this.entryManager.find(AdminConf.class, (Object)"ou=admin-ui,ou=configuration,o=jans");
            return adminConf.getDynamic().getRolePermissionMapping();
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.ERROR_READING_ROLE_PERMISSION_MAP.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.ERROR_READING_ROLE_PERMISSION_MAP.getDescription());
        }
    }

    public void resetPermissionsToRole(List<RolePermissionMapping> rolePermissionsArgs) throws ApplicationException {
        try {
            AdminConf adminConf = (AdminConf)this.entryManager.find(AdminConf.class, (Object)"ou=admin-ui,ou=configuration,o=jans");
            for (RolePermissionMapping mapping : Optional.ofNullable(rolePermissionsArgs).orElse(Collections.emptyList())) {
                this.validateRolePermissionMapping(adminConf, mapping);
            }
            adminConf.getDynamic().setRolePermissionMapping(rolePermissionsArgs);
            this.entryManager.merge((Object)adminConf);
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.ERROR_IN_MAPPING_ROLE_PERMISSION.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.ERROR_IN_MAPPING_ROLE_PERMISSION.getDescription());
        }
    }

    public List<RolePermissionMapping> addPermissionsToRole(RolePermissionMapping rolePermissionMappingArg) throws ApplicationException {
        try {
            AdminConf adminConf = (AdminConf)this.entryManager.find(AdminConf.class, (Object)"ou=admin-ui,ou=configuration,o=jans");
            List<RolePermissionMapping> roleScopeMappingList = this.getRolePermMapByRole(adminConf, rolePermissionMappingArg);
            if (CollectionUtils.isNotEmpty(roleScopeMappingList)) {
                this.log.warn(ErrorResponse.ROLE_PERMISSION_MAPPING_PRESENT.getDescription());
                throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.ROLE_PERMISSION_MAPPING_PRESENT.getDescription());
            }
            RolePermissionMapping rolePermissionMapping = new RolePermissionMapping();
            rolePermissionMapping.setRole(rolePermissionMappingArg.getRole());
            LinkedHashSet scopesSet = new LinkedHashSet(rolePermissionMappingArg.getPermissions());
            ArrayList combinedScopes = new ArrayList(scopesSet);
            rolePermissionMapping.setPermissions(combinedScopes);
            roleScopeMappingList.add(rolePermissionMapping);
            adminConf.getDynamic().getRolePermissionMapping().addAll(roleScopeMappingList);
            this.entryManager.merge((Object)adminConf);
            return adminConf.getDynamic().getRolePermissionMapping();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.ERROR_IN_MAPPING_ROLE_PERMISSION.getDescription());
            throw e;
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.ERROR_IN_MAPPING_ROLE_PERMISSION.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.ERROR_IN_MAPPING_ROLE_PERMISSION.getDescription());
        }
    }

    public List<RolePermissionMapping> mapPermissionsToRole(RolePermissionMapping rolePermissionMappingArg) throws ApplicationException {
        try {
            AdminConf adminConf = (AdminConf)this.entryManager.find(AdminConf.class, (Object)"ou=admin-ui,ou=configuration,o=jans");
            ArrayList roleScopeMappingList = this.getRolePermMapByRole(adminConf, rolePermissionMappingArg);
            if (roleScopeMappingList == null || roleScopeMappingList.isEmpty()) {
                RolePermissionMapping rolePermissionMapping = new RolePermissionMapping();
                rolePermissionMapping.setRole(rolePermissionMappingArg.getRole());
                roleScopeMappingList = Lists.newArrayList();
                roleScopeMappingList.add(rolePermissionMapping);
            }
            LinkedHashSet scopesSet = new LinkedHashSet(rolePermissionMappingArg.getPermissions());
            ArrayList combinedScopes = new ArrayList(scopesSet);
            if (adminConf.getDynamic().getRolePermissionMapping().stream().anyMatch(ele -> ele.getRole().equalsIgnoreCase(rolePermissionMappingArg.getRole()))) {
                adminConf.getDynamic().getRolePermissionMapping().stream().filter(ele -> ele.getRole().equalsIgnoreCase(rolePermissionMappingArg.getRole())).collect(Collectors.toList()).forEach(ele -> ele.setPermissions(combinedScopes));
            } else {
                roleScopeMappingList.forEach(ele -> ele.setPermissions(combinedScopes));
                adminConf.getDynamic().getRolePermissionMapping().addAll(roleScopeMappingList);
            }
            this.entryManager.merge((Object)adminConf);
            return adminConf.getDynamic().getRolePermissionMapping();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.ERROR_IN_MAPPING_ROLE_PERMISSION.getDescription());
            throw e;
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.ERROR_IN_MAPPING_ROLE_PERMISSION.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.ERROR_IN_MAPPING_ROLE_PERMISSION.getDescription());
        }
    }

    public RolePermissionMapping getAdminUIRolePermissionsMapping(String role) throws ApplicationException {
        try {
            AdminConf adminConf = (AdminConf)this.entryManager.find(AdminConf.class, (Object)"ou=admin-ui,ou=configuration,o=jans");
            List roleScopeMappings = adminConf.getDynamic().getRolePermissionMapping().stream().filter(ele -> ele.getRole().equalsIgnoreCase(role)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(roleScopeMappings)) {
                return (RolePermissionMapping)roleScopeMappings.get(0);
            }
            this.log.error(ErrorResponse.ROLE_PERMISSION_MAP_NOT_FOUND.getDescription());
            throw new ApplicationException(Response.Status.NOT_FOUND.getStatusCode(), ErrorResponse.ROLE_PERMISSION_MAP_NOT_FOUND.getDescription());
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.GET_ADMIUI_PERMISSIONS_ERROR.getDescription());
            throw e;
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.ERROR_READING_ROLE_PERMISSION_MAP.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.ERROR_READING_ROLE_PERMISSION_MAP.getDescription());
        }
    }

    public List<RolePermissionMapping> removePermissionsFromRole(String role) throws ApplicationException {
        try {
            AdminConf adminConf = (AdminConf)this.entryManager.find(AdminConf.class, (Object)"ou=admin-ui,ou=configuration,o=jans");
            if (!Optional.ofNullable(this.getRoleObjByName(role).getDeletable()).orElse(false).booleanValue()) {
                this.log.error(ErrorResponse.ROLE_MARKED_UNDELETABLE.getDescription());
                throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.ROLE_MARKED_UNDELETABLE.getDescription());
            }
            List roleScopeMapping = adminConf.getDynamic().getRolePermissionMapping().stream().filter(ele -> !ele.getRole().equalsIgnoreCase(role)).collect(Collectors.toList());
            adminConf.getDynamic().setRolePermissionMapping(roleScopeMapping);
            this.entryManager.merge((Object)adminConf);
            return adminConf.getDynamic().getRolePermissionMapping();
        }
        catch (ApplicationException e) {
            this.log.error(ErrorResponse.ERROR_IN_DELETING_ROLE_PERMISSION.getDescription());
            throw e;
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.ERROR_IN_DELETING_ROLE_PERMISSION.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.ERROR_IN_DELETING_ROLE_PERMISSION.getDescription());
        }
    }

    private List<RolePermissionMapping> getRolePermMapByRole(AdminConf adminConf, RolePermissionMapping rolePermissionMappingArg) throws ApplicationException {
        this.validateRolePermissionMapping(adminConf, rolePermissionMappingArg);
        return adminConf.getDynamic().getRolePermissionMapping().stream().filter(ele -> ele.getRole().equalsIgnoreCase(rolePermissionMappingArg.getRole())).collect(Collectors.toList());
    }

    private void validateRolePermissionMapping(AdminConf adminConf, RolePermissionMapping rolePermissionMappingArg) throws ApplicationException {
        List roles = adminConf.getDynamic().getRoles();
        List permissions = adminConf.getDynamic().getPermissions();
        if (roles.stream().noneMatch(ele -> ele.getRole().equals(rolePermissionMappingArg.getRole()))) {
            this.log.error(ErrorResponse.ROLE_NOT_FOUND.getDescription());
            throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.ROLE_NOT_FOUND.getDescription());
        }
        if (permissions.stream().noneMatch(ele -> rolePermissionMappingArg.getPermissions().contains(ele.getPermission()))) {
            this.log.error(ErrorResponse.PERMISSION_NOT_FOUND.getDescription());
            throw new ApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), ErrorResponse.PERMISSION_NOT_FOUND.getDescription());
        }
    }
}

