/*
 * Decompiled with CFR 0.152.
 */
package io.jans.ca.plugin.adminui.service.adminui;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import io.jans.as.client.TokenRequest;
import io.jans.as.client.TokenResponse;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.config.adminui.AdminConf;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.jwt.JwtClaims;
import io.jans.as.model.util.Util;
import io.jans.configapi.core.model.adminui.AUIConfiguration;
import io.jans.configapi.core.model.adminui.AdminUISession;
import io.jans.configapi.core.model.exception.ConfigApiApplicationException;
import io.jans.configapi.core.service.ConfigHttpService;
import io.jans.model.net.HttpServiceResponse;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.exception.EntryPersistenceException;
import io.jans.orm.search.filter.Filter;
import io.jans.service.EncryptionService;
import io.jans.util.security.StringEncrypter;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;

@ApplicationScoped
public class AdminUISessionService {
    private static final String SID_MSG = "Get Config API Session by sid:{}";
    private static final String SID_ERROR = "Failed to load  Config API session entry with sid ";
    private static final String ADMIN_UI_CONFIG_DN = "ou=admin-ui,ou=configuration,o=jans";
    private static final String SID = "sid";
    private static final String SESSION_DN = "ou=adminUISession,ou=admin-ui,o=jans";
    private static final String TOKEN_GENERATION_ERROR = "Error in generating token to access Config API endpoints";
    @Inject
    Logger logger;
    @Inject
    PersistenceEntryManager persistenceEntryManager;
    @Inject
    EncryptionService encryptionService;
    @Inject
    ConfigHttpService httpService;

    private String getDnForSession(String sessionId) {
        return String.format("inum=%s,%s", sessionId, SESSION_DN);
    }

    public AdminUISession getSession(String sessionId) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(SID_MSG, (Object)Util.escapeLog((Object)sessionId));
        }
        AdminUISession configApiSession = null;
        try {
            configApiSession = (AdminUISession)this.persistenceEntryManager.find(AdminUISession.class, (Object)this.getDnForSession(sessionId));
        }
        catch (EntryPersistenceException e) {
            return configApiSession;
        }
        catch (Exception ex) {
            this.logger.error("Failed to load  Config API session entry with sid {}", (Object)sessionId, (Object)ex);
            throw ex;
        }
        return configApiSession;
    }

    public void removeAllExpiredSessions() {
        Filter filter = Filter.createPresenceFilter((String)SID);
        List adminUISessions = this.persistenceEntryManager.findEntries(SESSION_DN, AdminUISession.class, filter);
        Date currentDate = new Date();
        adminUISessions.stream().filter(ele -> ele.getExpirationDate().getTime() - currentDate.getTime() < 0L).forEach(e -> this.persistenceEntryManager.remove(e));
    }

    public boolean isCachedTokenValid(String token, AUIConfiguration auiConfiguration) throws JsonProcessingException {
        this.logger.debug("Inside isCachedTokenValid : Token introspection from auth-server.");
        HashMap<String, String> body = new HashMap<String, String>();
        if (!Strings.isNullOrEmpty((String)token)) {
            body.put("token", token);
        }
        HttpServiceResponse httpServiceResponse = this.httpService.executePost(auiConfiguration.getAuiBackendApiServerIntrospectionEndpoint(), token, AdminUISessionService.toUrlEncodedString(body), ContentType.APPLICATION_FORM_URLENCODED, "Bearer ");
        String jsonString = null;
        if (httpServiceResponse.getHttpResponse() != null && httpServiceResponse.getHttpResponse().getStatusLine() != null) {
            this.logger.debug("httpServiceResponse.getHttpResponse():{}, httpServiceResponse.getHttpResponse().getStatusLine():{}, httpServiceResponse.getHttpResponse().getEntity():{}", new Object[]{httpServiceResponse.getHttpResponse(), httpServiceResponse.getHttpResponse().getStatusLine(), httpServiceResponse.getHttpResponse().getEntity()});
            if (httpServiceResponse.getHttpResponse().getStatusLine().getStatusCode() == 200) {
                ObjectMapper mapper = new ObjectMapper();
                HttpEntity httpEntity = httpServiceResponse.getHttpResponse().getEntity();
                if (httpEntity != null) {
                    jsonString = this.httpService.getContent(httpEntity);
                    HashMap payloadMap = (HashMap)mapper.readValue(jsonString, HashMap.class);
                    if (payloadMap.containsKey("active")) {
                        return (Boolean)payloadMap.get("active");
                    }
                    return false;
                }
                this.logger.error("Error in introspection of token to access Config API endpoints. Response is null.");
            }
        }
        return false;
    }

    public TokenResponse getApiProtectionToken(String ujwtString, AUIConfiguration auiConfiguration) throws StringEncrypter.EncryptionException, ConfigApiApplicationException {
        try {
            this.logger.debug("Getting api-protection token");
            TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
            tokenRequest.setAuthUsername(auiConfiguration.getAuiBackendApiServerClientId());
            tokenRequest.setAuthPassword(this.encryptionService.decrypt(auiConfiguration.getAuiBackendApiServerClientSecret()));
            tokenRequest.setGrantType(GrantType.CLIENT_CREDENTIALS);
            tokenRequest.setRedirectUri(auiConfiguration.getAuiBackendApiServerRedirectUrl());
            Map<String, Object> tokenResponse = null;
            if (Strings.isNullOrEmpty((String)ujwtString)) {
                this.logger.warn("User-Info JWT is null or empty. Token to access Config Api will not be generated.");
                return null;
            }
            tokenResponse = this.getToken(tokenRequest, auiConfiguration.getAuiBackendApiServerTokenEndpoint(), ujwtString);
            TokenResponse tokenResp = new TokenResponse();
            tokenResp.setAccessToken((String)tokenResponse.get("access_token"));
            return tokenResp;
        }
        catch (Exception e) {
            this.logger.error(TOKEN_GENERATION_ERROR, (Throwable)e);
            throw e;
        }
    }

    public Map<String, Object> getToken(TokenRequest tokenRequest, String tokenEndpoint, String userInfoJwt) throws ConfigApiApplicationException {
        try {
            HashMap<String, String> body = new HashMap<String, String>();
            if (!Strings.isNullOrEmpty((String)tokenRequest.getCode())) {
                body.put("code", tokenRequest.getCode());
            }
            if (!Strings.isNullOrEmpty((String)tokenRequest.getScope())) {
                body.put("scope", tokenRequest.getScope());
            }
            if (!Strings.isNullOrEmpty((String)userInfoJwt)) {
                body.put("ujwt", userInfoJwt);
            }
            if (!Strings.isNullOrEmpty((String)tokenRequest.getCodeVerifier())) {
                body.put("code_verifier", tokenRequest.getCodeVerifier());
            }
            body.put("grant_type", tokenRequest.getGrantType().getValue());
            body.put("redirect_uri", tokenRequest.getRedirectUri());
            body.put("client_id", tokenRequest.getAuthUsername());
            HttpServiceResponse httpServiceResponse = this.httpService.executePost(tokenEndpoint, tokenRequest.getEncodedCredentials(), AdminUISessionService.toUrlEncodedString(body), ContentType.APPLICATION_FORM_URLENCODED, "Basic ");
            String jsonString = null;
            if (httpServiceResponse.getHttpResponse() != null && httpServiceResponse.getHttpResponse().getStatusLine() != null) {
                this.logger.debug(" FINAL  httpServiceResponse.getHttpResponse():{}, httpServiceResponse.getHttpResponse().getStatusLine():{}, httpServiceResponse.getHttpResponse().getEntity():{}", new Object[]{httpServiceResponse.getHttpResponse(), httpServiceResponse.getHttpResponse().getStatusLine(), httpServiceResponse.getHttpResponse().getEntity()});
                if (httpServiceResponse.getHttpResponse().getStatusLine().getStatusCode() == 200) {
                    ObjectMapper mapper = new ObjectMapper();
                    HttpEntity httpEntity = httpServiceResponse.getHttpResponse().getEntity();
                    if (httpEntity != null) {
                        jsonString = this.httpService.getContent(httpEntity);
                        HashMap tokenMap = (HashMap)mapper.readValue(jsonString, HashMap.class);
                        tokenMap.remove("token_type");
                        return tokenMap;
                    }
                    this.logger.error("Error in generating token to access Config API endpoints: {}", (Object)"Response entity is null.");
                }
            }
            this.logger.error("Error in generating token to access Config API endpoints: {}", (Object)"Response is null.");
            throw new ConfigApiApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Error in generating token to access Config API endpointsResponse is null.");
        }
        catch (Exception e) {
            this.logger.error(TOKEN_GENERATION_ERROR, (Throwable)e);
            throw new ConfigApiApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), e.getMessage());
        }
    }

    private static String toUrlEncodedString(Map<String, String> params) {
        return params.entrySet().stream().filter(e -> e.getValue() != null).map(e -> URLEncoder.encode((String)e.getKey(), StandardCharsets.UTF_8) + "=" + URLEncoder.encode((String)e.getValue(), StandardCharsets.UTF_8)).collect(Collectors.joining("&"));
    }

    public AdminConf fetchAdminUIConfiguration() {
        return (AdminConf)this.persistenceEntryManager.find(AdminConf.class, (Object)ADMIN_UI_CONFIG_DN);
    }

    public Map<String, Object> getClaims(Jwt jwtObj) {
        HashMap claims = Maps.newHashMap();
        if (jwtObj == null) {
            return claims;
        }
        JwtClaims jwtClaims = jwtObj.getClaims();
        Set keys = jwtClaims.keys();
        keys.forEach(key -> {
            if (jwtClaims.getClaim(key) instanceof String) {
                claims.put(key, jwtClaims.getClaim(key).toString());
            } else if (jwtClaims.getClaim(key) instanceof Integer) {
                claims.put(key, Integer.valueOf(jwtClaims.getClaim(key).toString()));
            } else if (jwtClaims.getClaim(key) instanceof Long) {
                claims.put(key, Long.valueOf(jwtClaims.getClaim(key).toString()));
            } else if (jwtClaims.getClaim(key) instanceof Boolean) {
                claims.put(key, Boolean.valueOf(jwtClaims.getClaim(key).toString()));
            } else if (jwtClaims.getClaim(key) instanceof JSONArray) {
                List sourceArr = jwtClaims.getClaimAsStringList(key);
                claims.put(key, sourceArr);
            } else if (jwtClaims.getClaim(key) instanceof JSONObject) {
                claims.put(key, jwtClaims.getClaim(key));
            }
        });
        return claims;
    }
}

