/*
 * Decompiled with CFR 0.152.
 */
package io.jans.ca.plugin.adminui.service.auth;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import io.jans.as.client.TokenRequest;
import io.jans.as.client.TokenResponse;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.jwt.Jwt;
import io.jans.ca.plugin.adminui.model.auth.ApiTokenRequest;
import io.jans.ca.plugin.adminui.model.exception.ApplicationException;
import io.jans.ca.plugin.adminui.service.BaseService;
import io.jans.ca.plugin.adminui.service.config.AUIConfigurationService;
import io.jans.ca.plugin.adminui.utils.CommonUtils;
import io.jans.ca.plugin.adminui.utils.ErrorResponse;
import io.jans.configapi.core.model.adminui.AUIConfiguration;
import io.jans.configapi.core.model.adminui.AdminUISession;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.exception.EntryPersistenceException;
import io.jans.orm.search.filter.Filter;
import io.jans.service.EncryptionService;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.Response;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;

@Singleton
public class OAuth2Service
extends BaseService {
    @Inject
    Logger log;
    @Inject
    AUIConfigurationService auiConfigurationService;
    @Inject
    EncryptionService encryptionService;
    @Inject
    private PersistenceEntryManager entryManager;
    private static final String SID_GET_MSG = "Error in get Admin UI Session by sid: ";
    private static final String JANS_USR_DN = "jansUsrDN";
    private static final String SESSION_DN = "ou=adminUISession,ou=admin-ui,o=jans";

    public io.jans.ca.plugin.adminui.model.auth.TokenResponse getApiProtectionToken(ApiTokenRequest apiTokenRequest, String appType) throws ApplicationException {
        try {
            this.log.debug("Getting api-protection token");
            AUIConfiguration auiConfiguration = this.auiConfigurationService.getAUIConfiguration(appType);
            TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
            tokenRequest.setAuthUsername(auiConfiguration.getAuiBackendApiServerClientId());
            tokenRequest.setAuthPassword(this.encryptionService.decrypt(auiConfiguration.getAuiBackendApiServerClientSecret()));
            tokenRequest.setGrantType(GrantType.CLIENT_CREDENTIALS);
            tokenRequest.setRedirectUri(auiConfiguration.getAuiBackendApiServerRedirectUrl());
            TokenResponse tokenResponse = null;
            if (apiTokenRequest == null) {
                tokenRequest.setScope(OAuth2Service.scopeAsString(List.of("openid")));
                tokenResponse = this.getToken(tokenRequest, auiConfiguration.getAuiBackendApiServerTokenEndpoint());
            } else {
                if (Strings.isNullOrEmpty((String)apiTokenRequest.getUjwt())) {
                    this.log.warn(ErrorResponse.USER_INFO_JWT_BLANK.getDescription());
                    tokenRequest.setScope(OAuth2Service.scopeAsString(List.of("openid")));
                }
                tokenResponse = this.getToken(tokenRequest, auiConfiguration.getAuiBackendApiServerTokenEndpoint(), apiTokenRequest.getUjwt());
            }
            Optional<Map<String, Object>> introspectionResponse = this.introspectToken(tokenResponse.getAccessToken(), auiConfiguration.getAuiBackendApiServerIntrospectionEndpoint());
            io.jans.ca.plugin.adminui.model.auth.TokenResponse tokenResp = new io.jans.ca.plugin.adminui.model.auth.TokenResponse();
            tokenResp.setAccessToken(tokenResponse.getAccessToken());
            tokenResp.setIdToken(tokenResponse.getIdToken());
            tokenResp.setRefreshToken(tokenResponse.getRefreshToken());
            if (introspectionResponse.isEmpty()) {
                return tokenResp;
            }
            String SCOPE = "scope";
            Map<String, Object> claims = introspectionResponse.get();
            if (claims.get("scope") != null) {
                if (claims.get("scope") instanceof List) {
                    tokenResp.setScopes((List)claims.get("scope"));
                }
                if (claims.get("scope") instanceof String) {
                    tokenResp.setScopes(Arrays.asList(((String)claims.get("scope")).split(" ")));
                }
            }
            if (claims.get("iat") != null) {
                tokenResp.setIat(Long.parseLong(claims.get("iat").toString()));
            }
            if (claims.get("exp") != null) {
                tokenResp.setExp(Long.parseLong(claims.get("exp").toString()));
            }
            if (claims.get("iss") != null) {
                tokenResp.setIssuer(claims.get("iss").toString());
            }
            return tokenResp;
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.GET_API_PROTECTION_TOKEN_ERROR.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.GET_API_PROTECTION_TOKEN_ERROR.getDescription());
        }
    }

    private static String scopeAsString(List<String> scopes) throws UnsupportedEncodingException {
        HashSet scope = Sets.newHashSet();
        scope.addAll(scopes);
        return CommonUtils.joinAndUrlEncode(scope);
    }

    private String getDnForSession(String sessionId) {
        return String.format("inum=%s,%s", sessionId, SESSION_DN);
    }

    public void setAdminUISession(String sessionId, String ujwt) throws ApplicationException {
        AUIConfiguration auiConfiguration = this.auiConfigurationService.getAUIConfiguration();
        Date currentDate = new Date();
        Jwt tokenJwt = null;
        try {
            tokenJwt = Jwt.parse((String)ujwt);
        }
        catch (InvalidJwtException e) {
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Error in parsing user-info JWT.");
        }
        Map<String, Object> claims = CommonUtils.getClaims(tokenJwt);
        if (claims.get("inum") == null) {
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "The user `inum` claim missing in User-Info JWT");
        }
        AdminUISession adminUISession = new AdminUISession();
        adminUISession.setInum(sessionId);
        adminUISession.setDn(this.getDnForSession(sessionId));
        adminUISession.setSessionId(sessionId);
        adminUISession.setUjwt(ujwt);
        adminUISession.setJansUsrDN(this.getDnForUser((String)claims.get("inum")));
        adminUISession.setCreationDate(currentDate);
        adminUISession.setExpirationDate(CommonUtils.addMinutes(currentDate, auiConfiguration.getSessionTimeoutInMins()));
        this.entryManager.persist((Object)adminUISession);
    }

    public void removeAdminUIUserSessionByDn(String userDn) throws ApplicationException {
        try {
            Filter userDnFilter = Filter.createEqualityFilter((String)JANS_USR_DN, (Object)userDn);
            List adminUISessions = this.entryManager.findEntries(SESSION_DN, AdminUISession.class, userDnFilter);
            for (AdminUISession adminUISession : adminUISessions) {
                this.entryManager.remove((Object)adminUISession);
            }
        }
        catch (Exception e) {
            this.log.error(ErrorResponse.ADMINUI_SESSION_REMOVE_ERROR.getDescription(), (Throwable)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ErrorResponse.ADMINUI_SESSION_REMOVE_ERROR.getDescription());
        }
    }

    public AdminUISession getSession(String sessionId) throws ApplicationException {
        AdminUISession adminUISession = null;
        try {
            adminUISession = (AdminUISession)this.entryManager.find(AdminUISession.class, (Object)this.getDnForSession(sessionId));
        }
        catch (EntryPersistenceException e) {
            return adminUISession;
        }
        catch (Exception ex) {
            this.log.error("Error in get Admin UI Session by sid: {}", (Object)sessionId, (Object)ex);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), SID_GET_MSG + sessionId);
        }
        return adminUISession;
    }

    public void removeSession(String sessionId) throws ApplicationException {
        try {
            AdminUISession configApiSession = this.getSession(sessionId);
            if (configApiSession == null) {
                this.log.warn("Session not found for removal: {}", (Object)sessionId);
                return;
            }
            this.entryManager.remove((Object)configApiSession);
        }
        catch (Exception e) {
            this.log.error("Failed to remove Admin UI session: {}", (Object)sessionId, (Object)e);
            throw new ApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Failed to remove Admin UI session");
        }
    }

    private String getDnForUser(String userInum) {
        return String.format("inum=%s,%s", userInum, "ou=people,o=jans");
    }
}

