/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.fido2.model.config;

import io.jans.exception.ConfigurationException;
import jakarta.enterprise.context.ApplicationScoped;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class Fido2ConfigSource
implements ConfigSource {
    private static Logger log = LoggerFactory.getLogger(Fido2ConfigSource.class);
    private static final String FILE_CONFIG = "fido2.properties";
    private Properties properties = null;
    Map<String, String> propertiesMap = new HashMap<String, String>();

    public Fido2ConfigSource() {
        this.loadProperties();
    }

    public Map<String, String> getProperties() {
        log.debug("Getting properties");
        return this.propertiesMap;
    }

    public Set<String> getPropertyNames() {
        log.debug("Getting Property Names");
        try {
            return this.properties.stringPropertyNames();
        }
        catch (Exception e) {
            log.error("Unable to read properties from file: fido2.properties", (Throwable)e);
            return Collections.emptySet();
        }
    }

    public int getOrdinal() {
        return 800;
    }

    public String getValue(String name) {
        log.debug("Fido2ConfigSource()::getValue() - name:{}", (Object)name);
        try {
            return this.properties.getProperty(name);
        }
        catch (Exception e) {
            log.error("Unable to read properties from file: fido2.properties", (Throwable)e);
            return null;
        }
    }

    public String getName() {
        return FILE_CONFIG;
    }

    private Properties loadProperties() {
        Properties properties;
        block8: {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            InputStream inputStream = loader.getResourceAsStream(FILE_CONFIG);
            try {
                this.properties = new Properties();
                this.properties.load(inputStream);
                this.properties.stringPropertyNames().stream().forEach(key -> this.propertiesMap.put((String)key, this.properties.getProperty((String)key)));
                properties = this.properties;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ConfigurationException("Failed to load configuration from fido2.properties", (Throwable)e);
                }
            }
            inputStream.close();
        }
        return properties;
    }
}

