/*
 * Decompiled with CFR 0.152.
 */
package io.jans.fido2.ctap;

import java.util.HashMap;
import java.util.Map;

public enum CoseEdDSAAlgorithm {
    Ed25519(-8);

    private static final Map<Integer, CoseEdDSAAlgorithm> ALGORITHM_MAPPINGS;
    private final int numericValue;

    private CoseEdDSAAlgorithm(int value) {
        this.numericValue = value;
    }

    public static CoseEdDSAAlgorithm fromNumericValue(int value) {
        return ALGORITHM_MAPPINGS.get(value);
    }

    public int getNumericValue() {
        return this.numericValue;
    }

    static {
        ALGORITHM_MAPPINGS = new HashMap<Integer, CoseEdDSAAlgorithm>();
        for (CoseEdDSAAlgorithm enumType : CoseEdDSAAlgorithm.values()) {
            ALGORITHM_MAPPINGS.put(enumType.getNumericValue(), enumType);
        }
    }
}

