/*
 * Decompiled with CFR 0.152.
 */
package io.jans.fido2.model.metric;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.jans.orm.annotation.AttributeName;
import io.jans.orm.annotation.DataEntry;
import io.jans.orm.annotation.JsonObject;
import io.jans.orm.annotation.ObjectClass;
import io.jans.orm.model.base.Entry;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Objects;

@DataEntry
@ObjectClass(value="jansFido2UserMetrics")
@JsonIgnoreProperties(ignoreUnknown=true)
public class Fido2UserMetrics
extends Entry
implements Serializable {
    private static final long serialVersionUID = 1L;
    @AttributeName(name="jansId")
    private String id;
    @AttributeName(name="jansUserId")
    private String userId;
    @AttributeName(name="jansUsername")
    private String username;
    @AttributeName(name="jansFirstRegistrationDate")
    private LocalDateTime firstRegistrationDate;
    @AttributeName(name="jansLastActivityDate")
    private LocalDateTime lastActivityDate;
    @AttributeName(name="jansTotalRegistrations")
    private Integer totalRegistrations = 0;
    @AttributeName(name="jansTotalAuthentications")
    private Integer totalAuthentications = 0;
    @AttributeName(name="jansSuccessfulRegistrations")
    private Integer successfulRegistrations = 0;
    @AttributeName(name="jansSuccessfulAuthentications")
    private Integer successfulAuthentications = 0;
    @AttributeName(name="jansFailedRegistrations")
    private Integer failedRegistrations = 0;
    @AttributeName(name="jansFailedAuthentications")
    private Integer failedAuthentications = 0;
    @AttributeName(name="jansFallbackEvents")
    private Integer fallbackEvents = 0;
    @AttributeName(name="jansPreferredAuthenticatorType")
    private String preferredAuthenticatorType;
    @AttributeName(name="jansPreferredDeviceType")
    private String preferredDeviceType;
    @AttributeName(name="jansPreferredBrowser")
    private String preferredBrowser;
    @AttributeName(name="jansPreferredOs")
    private String preferredOs;
    @AttributeName(name="jansAvgRegistrationDuration")
    private Double avgRegistrationDuration;
    @AttributeName(name="jansAvgAuthenticationDuration")
    private Double avgAuthenticationDuration;
    @AttributeName(name="jansLastIpAddress")
    private String lastIpAddress;
    @AttributeName(name="jansLastUserAgent")
    private String lastUserAgent;
    @AttributeName(name="jansIsActive")
    private Boolean isActive = true;
    @AttributeName(name="jansUserSegments")
    @JsonObject
    private transient Map<String, Object> userSegments;
    @AttributeName(name="jansBehaviorPatterns")
    @JsonObject
    private transient Map<String, Object> behaviorPatterns;
    @AttributeName(name="jansRiskScore")
    private Double riskScore;
    @AttributeName(name="jansEngagementLevel")
    private String engagementLevel;
    @AttributeName(name="jansAdoptionStage")
    private String adoptionStage;
    @AttributeName(name="jansLastUpdated")
    private LocalDateTime lastUpdated = LocalDateTime.now();

    public Fido2UserMetrics() {
    }

    public Fido2UserMetrics(String userId, String username) {
        this();
        this.userId = userId;
        this.username = username;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public LocalDateTime getFirstRegistrationDate() {
        return this.firstRegistrationDate;
    }

    public void setFirstRegistrationDate(LocalDateTime firstRegistrationDate) {
        this.firstRegistrationDate = firstRegistrationDate;
    }

    public LocalDateTime getLastActivityDate() {
        return this.lastActivityDate;
    }

    public void setLastActivityDate(LocalDateTime lastActivityDate) {
        this.lastActivityDate = lastActivityDate;
    }

    public Integer getTotalRegistrations() {
        return this.totalRegistrations;
    }

    public void setTotalRegistrations(Integer totalRegistrations) {
        this.totalRegistrations = totalRegistrations;
    }

    public Integer getTotalAuthentications() {
        return this.totalAuthentications;
    }

    public void setTotalAuthentications(Integer totalAuthentications) {
        this.totalAuthentications = totalAuthentications;
    }

    public Integer getSuccessfulRegistrations() {
        return this.successfulRegistrations;
    }

    public void setSuccessfulRegistrations(Integer successfulRegistrations) {
        this.successfulRegistrations = successfulRegistrations;
    }

    public Integer getSuccessfulAuthentications() {
        return this.successfulAuthentications;
    }

    public void setSuccessfulAuthentications(Integer successfulAuthentications) {
        this.successfulAuthentications = successfulAuthentications;
    }

    public Integer getFailedRegistrations() {
        return this.failedRegistrations;
    }

    public void setFailedRegistrations(Integer failedRegistrations) {
        this.failedRegistrations = failedRegistrations;
    }

    public Integer getFailedAuthentications() {
        return this.failedAuthentications;
    }

    public void setFailedAuthentications(Integer failedAuthentications) {
        this.failedAuthentications = failedAuthentications;
    }

    public Integer getFallbackEvents() {
        return this.fallbackEvents;
    }

    public void setFallbackEvents(Integer fallbackEvents) {
        this.fallbackEvents = fallbackEvents;
    }

    public String getPreferredAuthenticatorType() {
        return this.preferredAuthenticatorType;
    }

    public void setPreferredAuthenticatorType(String preferredAuthenticatorType) {
        this.preferredAuthenticatorType = preferredAuthenticatorType;
    }

    public String getPreferredDeviceType() {
        return this.preferredDeviceType;
    }

    public void setPreferredDeviceType(String preferredDeviceType) {
        this.preferredDeviceType = preferredDeviceType;
    }

    public String getPreferredBrowser() {
        return this.preferredBrowser;
    }

    public void setPreferredBrowser(String preferredBrowser) {
        this.preferredBrowser = preferredBrowser;
    }

    public String getPreferredOs() {
        return this.preferredOs;
    }

    public void setPreferredOs(String preferredOs) {
        this.preferredOs = preferredOs;
    }

    public Double getAvgRegistrationDuration() {
        return this.avgRegistrationDuration;
    }

    public void setAvgRegistrationDuration(Double avgRegistrationDuration) {
        this.avgRegistrationDuration = avgRegistrationDuration;
    }

    public Double getAvgAuthenticationDuration() {
        return this.avgAuthenticationDuration;
    }

    public void setAvgAuthenticationDuration(Double avgAuthenticationDuration) {
        this.avgAuthenticationDuration = avgAuthenticationDuration;
    }

    public String getLastIpAddress() {
        return this.lastIpAddress;
    }

    public void setLastIpAddress(String lastIpAddress) {
        this.lastIpAddress = lastIpAddress;
    }

    public String getLastUserAgent() {
        return this.lastUserAgent;
    }

    public void setLastUserAgent(String lastUserAgent) {
        this.lastUserAgent = lastUserAgent;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public Map<String, Object> getUserSegments() {
        return this.userSegments;
    }

    public void setUserSegments(Map<String, Object> userSegments) {
        this.userSegments = userSegments;
    }

    public Map<String, Object> getBehaviorPatterns() {
        return this.behaviorPatterns;
    }

    public void setBehaviorPatterns(Map<String, Object> behaviorPatterns) {
        this.behaviorPatterns = behaviorPatterns;
    }

    public Double getRiskScore() {
        return this.riskScore;
    }

    public void setRiskScore(Double riskScore) {
        this.riskScore = riskScore;
    }

    public String getEngagementLevel() {
        return this.engagementLevel;
    }

    public void setEngagementLevel(String engagementLevel) {
        this.engagementLevel = engagementLevel;
    }

    public String getAdoptionStage() {
        return this.adoptionStage;
    }

    public void setAdoptionStage(String adoptionStage) {
        this.adoptionStage = adoptionStage;
    }

    public LocalDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(LocalDateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public void incrementRegistrations(boolean success) {
        Integer n = this.totalRegistrations;
        this.totalRegistrations = this.totalRegistrations + 1;
        if (success) {
            n = this.successfulRegistrations;
            this.successfulRegistrations = this.successfulRegistrations + 1;
        } else {
            n = this.failedRegistrations;
            this.failedRegistrations = this.failedRegistrations + 1;
        }
        this.lastActivityDate = LocalDateTime.now();
        this.lastUpdated = LocalDateTime.now();
    }

    public void incrementAuthentications(boolean success) {
        Integer n = this.totalAuthentications;
        this.totalAuthentications = this.totalAuthentications + 1;
        if (success) {
            n = this.successfulAuthentications;
            this.successfulAuthentications = this.successfulAuthentications + 1;
        } else {
            n = this.failedAuthentications;
            this.failedAuthentications = this.failedAuthentications + 1;
        }
        this.lastActivityDate = LocalDateTime.now();
        this.lastUpdated = LocalDateTime.now();
    }

    public void incrementFallbackEvents() {
        Integer n = this.fallbackEvents;
        this.fallbackEvents = this.fallbackEvents + 1;
        this.lastActivityDate = LocalDateTime.now();
        this.lastUpdated = LocalDateTime.now();
    }

    public double getRegistrationSuccessRate() {
        if (this.totalRegistrations == null || this.totalRegistrations == 0) {
            return 0.0;
        }
        return (double)this.successfulRegistrations.intValue() / (double)this.totalRegistrations.intValue();
    }

    public double getAuthenticationSuccessRate() {
        if (this.totalAuthentications == null || this.totalAuthentications == 0) {
            return 0.0;
        }
        return (double)this.successfulAuthentications.intValue() / (double)this.totalAuthentications.intValue();
    }

    public double getOverallSuccessRate() {
        int totalOperations = (this.totalRegistrations != null ? this.totalRegistrations : 0) + (this.totalAuthentications != null ? this.totalAuthentications : 0);
        int totalSuccesses = (this.successfulRegistrations != null ? this.successfulRegistrations : 0) + (this.successfulAuthentications != null ? this.successfulAuthentications : 0);
        if (totalOperations == 0) {
            return 0.0;
        }
        return (double)totalSuccesses / (double)totalOperations;
    }

    public double getFallbackRate() {
        int totalOperations = (this.totalRegistrations != null ? this.totalRegistrations : 0) + (this.totalAuthentications != null ? this.totalAuthentications : 0);
        if (totalOperations == 0) {
            return 0.0;
        }
        return (double)(this.fallbackEvents != null ? this.fallbackEvents : 0) / (double)totalOperations;
    }

    public boolean isNewUser() {
        return this.firstRegistrationDate != null && this.firstRegistrationDate.isAfter(LocalDateTime.now().minusDays(30L));
    }

    public boolean isActiveUser() {
        return this.lastActivityDate != null && this.lastActivityDate.isAfter(LocalDateTime.now().minusDays(30L));
    }

    public void updateEngagementLevel() {
        int totalOperations = (this.totalRegistrations != null ? this.totalRegistrations : 0) + (this.totalAuthentications != null ? this.totalAuthentications : 0);
        this.engagementLevel = totalOperations >= 50 ? "HIGH" : (totalOperations >= 10 ? "MEDIUM" : "LOW");
    }

    public void updateAdoptionStage() {
        this.adoptionStage = this.totalRegistrations == null || this.totalRegistrations == 0 ? "NEW" : (this.totalRegistrations == 1 ? "LEARNING" : (this.totalRegistrations <= 5 ? "ADOPTED" : "EXPERT"));
    }

    public String toString() {
        return "Fido2UserMetrics{id='" + this.id + "', userId='" + this.userId + "', username='" + this.username + "', firstRegistrationDate=" + this.firstRegistrationDate + ", lastActivityDate=" + this.lastActivityDate + ", totalRegistrations=" + this.totalRegistrations + ", totalAuthentications=" + this.totalAuthentications + ", successfulRegistrations=" + this.successfulRegistrations + ", successfulAuthentications=" + this.successfulAuthentications + ", engagementLevel='" + this.engagementLevel + "', adoptionStage='" + this.adoptionStage + "', isActive=" + this.isActive + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Fido2UserMetrics that = (Fido2UserMetrics)obj;
        return Objects.equals(this.userId, that.userId) && Objects.equals(this.username, that.username) && Objects.equals(this.firstRegistrationDate, that.firstRegistrationDate);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.username, this.firstRegistrationDate);
    }
}

