/*
 * Decompiled with CFR 0.152.
 */
package io.jans.fido2.ctap;

import java.util.HashMap;
import java.util.Map;

public enum CoseRSAAlgorithm {
    RS256(-257),
    RS65535(-65535),
    RS384(-258),
    RS512(-259),
    RS1(-262),
    PS512(-39),
    PS384(-38),
    PS256(-37);

    private static final Map<Integer, CoseRSAAlgorithm> ALGORITHM_MAPPINGS;
    private final int numericValue;

    private CoseRSAAlgorithm(int value) {
        this.numericValue = value;
    }

    public static CoseRSAAlgorithm fromNumericValue(int value) {
        return ALGORITHM_MAPPINGS.get(value);
    }

    public int getNumericValue() {
        return this.numericValue;
    }

    static {
        ALGORITHM_MAPPINGS = new HashMap<Integer, CoseRSAAlgorithm>();
        for (CoseRSAAlgorithm enumType : CoseRSAAlgorithm.values()) {
            ALGORITHM_MAPPINGS.put(enumType.getNumericValue(), enumType);
        }
    }
}

