/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.fido2.rest;

import io.jans.as.model.util.Util;
import io.jans.configapi.core.model.ApiError;
import io.jans.configapi.core.rest.BaseResource;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.plugin.fido2.service.Fido2RegistrationService;
import io.jans.model.SearchRequest;
import io.jans.orm.model.PagedResult;
import io.jans.orm.model.fido2.Fido2RegistrationEntry;
import io.jans.util.exception.InvalidAttributeException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;

@Path(value="/registration")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class Fido2RegistrationResource
extends BaseResource {
    @Inject
    Logger logger;
    @Inject
    Fido2RegistrationService fido2RegistrationService;

    @Operation(summary="Get a list of Fido2RegistrationEntry.", description="Get a list of Fido2RegistrationEntry.", operationId="search-fido2-registration-data", tags={"Fido2 - Registration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/fido2.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=Fido2RegistrationEntryPagedResult.class), examples={@ExampleObject(name="Response example", value="example/fido2/search-fido2-registration-data.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/fido2.readonly"}, groupScopes={"https://jans.io/oauth/config/fido2.write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    public Response getFido2RegistrationEntry(@Parameter(description="Search size - max size of the results to return") @DefaultValue(value="50") @QueryParam(value="limit") int limit, @Parameter(description="Search pattern") @DefaultValue(value="") @QueryParam(value="pattern") String pattern, @Parameter(description="The 1-based index of the first query result") @DefaultValue(value="0") @QueryParam(value="startIndex") int startIndex, @Parameter(description="Data whose value will be used to order the returned response") @DefaultValue(value="jansId") @QueryParam(value="sortBy") String sortBy, @Parameter(description="Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\"") @DefaultValue(value="ascending") @QueryParam(value="sortOrder") String sortOrder, @Parameter(description="Field and value pair for seraching", examples={@ExampleObject(name="Field value example", value="mail=abc@mail.com,jansStatus=true")}) @DefaultValue(value="") @QueryParam(value="fieldValuePair") String fieldValuePair) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Fido2RegistrationEntry search param - limit:{}, pattern:{}, startIndex:{}, sortBy:{}, sortOrder:{}, fieldValuePair:{}", new Object[]{Util.escapeLog((Object)limit), Util.escapeLog((Object)pattern), Util.escapeLog((Object)startIndex), Util.escapeLog((Object)sortBy), Util.escapeLog((Object)sortOrder), Util.escapeLog((Object)fieldValuePair)});
        }
        SearchRequest searchReq = this.createSearchRequest(this.fido2RegistrationService.getBaseDnForFido2RegistrationEntries(null), pattern, sortBy, sortOrder, startIndex, limit, null, null, this.fido2RegistrationService.getRecordMaxCount(), fieldValuePair, Fido2RegistrationEntry.class);
        return Response.ok((Object)((Object)this.doSearch(searchReq))).build();
    }

    @Operation(summary="Fetch Fido2RegistrationEntry by Id.", description="Fetch Fido2RegistrationEntry by Id.", operationId="get-fido2-by-id", tags={"Fido2 - Registration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/fido2.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=Fido2RegistrationEntry.class), examples={@ExampleObject(name="Response example", value="example/fido2/get-fido2-by-id.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/fido2.readonly"}, groupScopes={"https://jans.io/oauth/config/fido2.write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    @Path(value="/id/{jansId}")
    public Response getFido2RegistrationEntryById(@Parameter(description="Fido2Registration identifier") @PathParam(value="jansId") @NotNull String jansId) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Fido2RegistrationEntry search by id:{}", (Object)Util.escapeLog((Object)jansId));
        }
        Fido2RegistrationEntry fido2RegistrationEntry = this.fido2RegistrationService.getFido2RegistrationEntryById(jansId);
        return Response.ok((Object)fido2RegistrationEntry).build();
    }

    @Operation(summary="Get details of connected FIDO2 devices registered to user", description="Get details of connected FIDO2 devices registered to user", operationId="get-registration-entries-fido2", tags={"Fido2 - Registration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/fido2.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=Fido2RegistrationEntryPagedResult.class), examples={@ExampleObject(name="Response example", value="example/fido2/search-fido2-registration-data.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @Path(value="/entries/{username}")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/fido2.readonly"})
    public Response findAllRegisteredByUsername(@Parameter(description="User name") @PathParam(value="username") @NotNull String username) {
        this.logger.info("FIDO2 registration entries by username.");
        Fido2RegistrationResource.checkNotNull((String)username, (String)"User name");
        PagedResult<Fido2RegistrationEntry> entries = this.fido2RegistrationService.getFido2RegisteredByUsername(username);
        this.logger.info("FIDO2 registration entries by entries:{}", entries);
        return Response.ok(entries).build();
    }

    @Operation(summary="Delete Fido2 Device Data based on device UID", description="Delete Fido2 Device Data based on device UID", operationId="delete-fido2-data", tags={"Fido2 - Registration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/fido2.delete"})})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="BadRequestException"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="InternalServerError"))})})
    @DELETE
    @Path(value="/id/{jansId}")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/fido2.delete"})
    public Response deleteFido2Data(@Parameter(description="Fido2Registration Unique identifier.") @PathParam(value="jansId") @NotNull String jansId) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Request to delete Fido2 device identified by jansId:{}", (Object)Util.escapeLog((Object)jansId));
        }
        Fido2RegistrationResource.checkResourceNotNull((Object)jansId, (String)"jansId");
        try {
            this.fido2RegistrationService.removeFido2RegistrationEntry(jansId);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Successfully deleted Fido2 with id:{}", (Object)Util.escapeLog((Object)jansId));
            }
        }
        catch (InvalidAttributeException iae) {
            Fido2RegistrationResource.throwNotFoundException((String)"Not Found", (String)iae.getMessage());
        }
        catch (Exception ex) {
            Fido2RegistrationResource.throwInternalServerException((Throwable)ex);
        }
        return Response.noContent().build();
    }

    private Fido2RegistrationEntryPagedResult doSearch(SearchRequest searchReq) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("User search params - searchReq:{}", (Object)Util.escapeLog((Object)searchReq));
        }
        PagedResult<Fido2RegistrationEntry> pagedResult = this.fido2RegistrationService.searchFido2Registration(searchReq);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Fido2RegistrationEntry  - pagedResult:{}", pagedResult);
        }
        Fido2RegistrationEntryPagedResult pagedFido2Registration = new Fido2RegistrationEntryPagedResult();
        if (pagedResult != null) {
            this.logger.debug("Users fetched  - pagedResult.getEntries():{}", (Object)pagedResult.getEntries());
            pagedFido2Registration.setStart(pagedResult.getStart());
            pagedFido2Registration.setEntriesCount(pagedResult.getEntriesCount());
            pagedFido2Registration.setTotalEntriesCount(pagedResult.getTotalEntriesCount());
            pagedFido2Registration.setEntries(pagedResult.getEntries());
        }
        this.logger.info("Fido2RegistrationEntry pagedFido2Registration:{}", (Object)pagedFido2Registration);
        return pagedFido2Registration;
    }

    private class Fido2RegistrationEntryPagedResult
    extends PagedResult<Fido2RegistrationEntry> {
        private Fido2RegistrationEntryPagedResult() {
        }
    }
}

