/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.fido2.service;

import io.jans.configapi.configuration.ConfigurationFactory;
import io.jans.fido2.model.conf.AppConfiguration;
import io.jans.fido2.model.conf.Conf;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.exception.BasePersistenceException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.slf4j.Logger;

@ApplicationScoped
public class Fido2Service {
    @Inject
    Logger logger;
    @Inject
    PersistenceEntryManager persistenceManager;
    @Inject
    ConfigurationFactory configurationFactory;

    public Conf findConf() {
        try {
            String configurationDn = this.configurationFactory.getBaseConfiguration().getString("fido2_ConfigurationEntryDN");
            return (Conf)this.persistenceManager.find(Conf.class, (Object)configurationDn);
        }
        catch (BasePersistenceException var3) {
            this.logger.error("Failed to load Fido2 configuration from LDAP");
            return null;
        }
    }

    public AppConfiguration find() {
        Conf conf = this.findConf();
        return conf.getDynamicConf();
    }

    public void mergeConf(Conf conf) {
        conf.setRevision(conf.getRevision() + 1L);
        this.persistenceManager.merge((Object)conf);
    }

    public void merge(AppConfiguration fido2ConfigJson) {
        Conf conf = this.findConf();
        conf.setDynamicConf(fido2ConfigJson);
        this.mergeConf(conf);
    }
}

