/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.fido2.service;

import io.jans.as.common.service.OrganizationService;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.util.Util;
import io.jans.configapi.configuration.ConfigurationFactory;
import io.jans.configapi.core.util.DataUtil;
import io.jans.configapi.plugin.fido2.service.UserFido2Service;
import io.jans.model.SearchRequest;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.model.PagedResult;
import io.jans.orm.model.SortOrder;
import io.jans.orm.model.base.SimpleBranch;
import io.jans.orm.model.fido2.Fido2RegistrationEntry;
import io.jans.orm.model.fido2.Fido2RegistrationStatus;
import io.jans.orm.search.filter.Filter;
import io.jans.util.StringHelper;
import io.jans.util.exception.InvalidAttributeException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class Fido2RegistrationService {
    private static final String JANS_STATUS = "jansStatus";
    private static final String PERSON_INUM = "personInum";
    @Inject
    private Logger log;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    OrganizationService organizationService;
    @Inject
    ConfigurationFactory configurationFactory;
    @Inject
    private UserFido2Service userFido2Srv;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;

    public int getRecordMaxCount() {
        this.log.trace(" MaxCount details - ApiAppConfiguration.MaxCount():{}, DEFAULT_MAX_COUNT:{} ", (Object)this.configurationFactory.getApiAppConfiguration().getMaxCount(), (Object)200);
        return this.configurationFactory.getApiAppConfiguration().getMaxCount() > 0 ? this.configurationFactory.getApiAppConfiguration().getMaxCount() : 200;
    }

    public Fido2RegistrationEntry getFido2RegistrationEntryById(String id) {
        Fido2RegistrationEntry fido2RegistrationEntry = null;
        try {
            fido2RegistrationEntry = (Fido2RegistrationEntry)this.persistenceEntryManager.find(Fido2RegistrationEntry.class, (Object)this.getDnFido2RegistrationEntry(id));
        }
        catch (Exception ex) {
            this.log.error("Failed to get fido2RegistrationEntry identified by id:{" + id + "}", (Throwable)ex);
        }
        return fido2RegistrationEntry;
    }

    public PagedResult<Fido2RegistrationEntry> searchFido2Registration(SearchRequest searchRequest) {
        this.log.info("**** Search Fido2Registration with searchRequest:{}", (Object)searchRequest);
        Filter searchFilter = null;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (searchRequest.getFilterAssertionValue() != null && !searchRequest.getFilterAssertionValue().isEmpty()) {
            for (String assertionValue : searchRequest.getFilterAssertionValue()) {
                this.log.info(" **** Search Fido2Registration with assertionValue:{}", (Object)assertionValue);
                String[] targetArray = new String[]{assertionValue};
                Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
                Filter descriptionFilter = Filter.createSubstringFilter((String)"jansRegistrationData", null, (String[])targetArray, null);
                Filter statusFilter = Filter.createSubstringFilter((String)JANS_STATUS, null, (String[])targetArray, null);
                Filter notificationConfFilter = Filter.createSubstringFilter((String)"jansDeviceNotificationConf", null, (String[])targetArray, null);
                Filter deviceDataFilter = Filter.createSubstringFilter((String)"jansDeviceData", null, (String[])targetArray, null);
                Filter personInumFilter = Filter.createSubstringFilter((String)PERSON_INUM, null, (String[])targetArray, null);
                Filter inumFilter = Filter.createSubstringFilter((String)"jansId", null, (String[])targetArray, null);
                filters.add(Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter, statusFilter, notificationConfFilter, deviceDataFilter, personInumFilter, inumFilter}));
            }
            searchFilter = Filter.createORFilter(filters);
        }
        this.log.debug("Fido2Registration pattern searchFilter:{}", searchFilter);
        List fieldValueFilters = new ArrayList();
        if (searchRequest.getFieldFilterData() != null && !searchRequest.getFieldFilterData().isEmpty()) {
            fieldValueFilters = DataUtil.createFilter((List)searchRequest.getFieldFilterData(), (String)this.getDnFido2RegistrationEntry(null), (PersistenceEntryManager)this.persistenceEntryManager);
        }
        searchFilter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createORFilter(filters), Filter.createANDFilter(fieldValueFilters)});
        this.log.info(" Final - Fido2Registration searchFilter:{}", (Object)searchFilter);
        return this.persistenceEntryManager.findPagedEntries(this.getDnFido2RegistrationEntry(null), Fido2RegistrationEntry.class, searchFilter, null, searchRequest.getSortBy(), SortOrder.getByValue((String)searchRequest.getSortOrder()), searchRequest.getStartIndex().intValue(), searchRequest.getCount().intValue(), searchRequest.getMaxCount());
    }

    public List<Fido2RegistrationEntry> findAllRegisteredByUsername(String username) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Find Fido2 Registered by username:{}", (Object)Util.escapeLog((Object)username));
        }
        String userInum = this.userFido2Srv.getUserInum(username);
        this.log.info("Find Fido2 Registered by userInum:{}", (Object)userInum);
        if (userInum == null) {
            return Collections.emptyList();
        }
        String baseDn = this.getBaseDnForFido2RegistrationEntries(userInum);
        this.log.info("Find Fido2 Registered by baseDn:{}", (Object)baseDn);
        if (this.persistenceEntryManager.hasBranchesSupport(baseDn) && !this.containsBranch(baseDn)) {
            return Collections.emptyList();
        }
        Filter searchFilter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)PERSON_INUM, (Object)userInum), Filter.createEqualityFilter((String)JANS_STATUS, (Object)Fido2RegistrationStatus.registered.getValue())});
        this.log.info("Fido2 Registered by searchFilter:{}", (Object)searchFilter);
        return this.persistenceEntryManager.findEntries(this.getDnFido2RegistrationEntry(baseDn), Fido2RegistrationEntry.class, searchFilter);
    }

    public PagedResult<Fido2RegistrationEntry> getFido2RegisteredByUsername(String username) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Fetch Fido2 Registered by username:{}", (Object)Util.escapeLog((Object)username));
        }
        PagedResult<Fido2RegistrationEntry> fido2RegistrationEntry = null;
        String userInum = this.userFido2Srv.getUserInum(username);
        this.log.info("Find Fido2 Registered by userInum:{}", (Object)userInum);
        if (userInum == null) {
            return fido2RegistrationEntry;
        }
        String baseDn = this.getBaseDnForFido2RegistrationEntries(userInum);
        this.log.info("Find Fido2 Registered by baseDn:{}", (Object)baseDn);
        if (this.persistenceEntryManager.hasBranchesSupport(baseDn) && !this.containsBranch(baseDn)) {
            return fido2RegistrationEntry;
        }
        Filter searchFilter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)PERSON_INUM, (Object)userInum), Filter.createEqualityFilter((String)JANS_STATUS, (Object)Fido2RegistrationStatus.registered.getValue())});
        this.log.info("Fido2 Registered by searchFilter:{}", (Object)searchFilter);
        return this.persistenceEntryManager.findPagedEntries(this.getDnFido2RegistrationEntry(baseDn), Fido2RegistrationEntry.class, searchFilter, null, "jansId", SortOrder.ASCENDING, Integer.parseInt("0"), Integer.parseInt("50"), this.getRecordMaxCount());
    }

    public String getBaseDnForFido2RegistrationEntries(String userInum) {
        String userBaseDn = this.getDnForUser(userInum);
        if (StringHelper.isEmpty((String)userInum)) {
            return userBaseDn;
        }
        return String.format("ou=fido2_register,%s", userBaseDn);
    }

    public String getDnForUser(String userInum) {
        String peopleDn = this.staticConfiguration.getBaseDn().getPeople();
        if (StringHelper.isEmpty((String)userInum)) {
            return peopleDn;
        }
        return String.format("inum=%s,%s", userInum, peopleDn);
    }

    public boolean containsBranch(String baseDn) {
        return this.persistenceEntryManager.contains(baseDn, SimpleBranch.class);
    }

    public void removeFido2RegistrationEntry(String id) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Remove Fido2RegistrationEntry request for device with id:{}", (Object)Util.escapeLog((Object)id));
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new InvalidAttributeException("Fido2RegistrationEntry id is null!");
        }
        Fido2RegistrationEntry fido2RegistrationEntry = this.getFido2RegistrationEntryById(id);
        this.log.debug("Fido2RegistrationEntry identified by id:{} is:{}", (Object)id, (Object)fido2RegistrationEntry);
        if (fido2RegistrationEntry == null) {
            throw new InvalidAttributeException("No Fido2RegistrationEntry found with id:{" + id + "}");
        }
        this.persistenceEntryManager.removeRecursively(fido2RegistrationEntry.getBaseDn(), Fido2RegistrationEntry.class);
        fido2RegistrationEntry = this.getFido2RegistrationEntryByDeviceId(id);
        if (fido2RegistrationEntry != null) {
            throw new WebApplicationException("Fido2RegistrationEntry device with id:{" + id + "} could not be deleted!");
        }
        this.log.info("Successfully deleted Fido2RegistrationEntry device with id:{}", (Object)id);
    }

    public Fido2RegistrationEntry getFido2RegistrationEntryByDeviceId(String uuid) {
        this.log.info("Get Fido2RegistrationEntry with device uuid:{}", (Object)uuid);
        if (StringUtils.isBlank((CharSequence)uuid)) {
            throw new InvalidAttributeException("Device uuid is null!");
        }
        Fido2RegistrationEntry fido2RegistrationEntry = null;
        try {
            String[] targetArray = new String[]{uuid};
            Filter filter = Filter.createSubstringFilter((String)"jansDeviceData", null, (String[])targetArray, null);
            this.log.debug("Find device filter:{}", (Object)filter);
            List fido2List = this.persistenceEntryManager.findEntries(this.getDnFido2RegistrationEntry(null), Fido2RegistrationEntry.class, filter);
            this.log.debug("Fetched Fido2RegistrationEntry by uuid:{} are fido2List:{}", (Object)uuid, (Object)fido2List);
            if (fido2List != null && !fido2List.isEmpty()) {
                fido2RegistrationEntry = (Fido2RegistrationEntry)fido2List.get(0);
            }
            this.log.info("Fido2RegistrationEntry by uuid:{} are fido2RegistrationEntry:{}", (Object)uuid, fido2RegistrationEntry);
        }
        catch (Exception e) {
            this.log.error("Error while finding Fido2RegistrationEntry with device uuid:{} is {}" + uuid, (Throwable)e);
        }
        return fido2RegistrationEntry;
    }

    public String getDnFido2RegistrationEntry(String inum) {
        String orgDn = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=fido2_register,%s", orgDn);
        }
        return String.format("jansId=%s,ou=fido2_register,%s", inum, orgDn);
    }
}

