/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.fido2.rest;

import io.jans.configapi.core.rest.BaseResource;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.plugin.fido2.service.Fido2Service;
import io.jans.configapi.plugin.fido2.util.Fido2Util;
import io.jans.fido2.model.conf.AppConfiguration;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;

@Path(value="/fido2-config")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class Fido2ConfigResource
extends BaseResource {
    private static final String FIDO2_CONFIGURATION = "fido2Configuration";
    @Inject
    Logger logger;
    @Inject
    Fido2Service fido2Service;
    @Inject
    Fido2Util fido2Util;

    @Operation(summary="Gets Jans Authorization Server Fido2 configuration properties", description="Gets Jans Authorization Server Fido2 configuration properties", operationId="get-properties-fido2", tags={"Fido2 - Configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/fido2.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/fido2.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/fido2.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppConfiguration.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/fido2.readonly"}, groupScopes={"https://jans.io/oauth/config/fido2.write"}, superScopes={"https://jans.io/oauth/config/fido2.admin", "https://jans.io/oauth/config/read-all"})
    public Response getFido2Configuration() {
        AppConfiguration appConfiguration = this.fido2Service.find();
        this.logger.debug("FIDO2 details appConfiguration():{}", (Object)appConfiguration);
        return Response.ok((Object)appConfiguration).build();
    }

    @Operation(summary="Updates Fido2 configuration properties", description="Updates Fido2 configuration properties", operationId="put-properties-fido2", tags={"Fido2 - Configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/fido2.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/fido2.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @RequestBody(description="Fido2Config", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppConfiguration.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Fido2Config", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppConfiguration.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PUT
    @ProtectedApi(scopes={"https://jans.io/oauth/config/fido2.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/fido2.admin", "https://jans.io/oauth/config/write-all"})
    public Response updateFido2Configuration(@NotNull AppConfiguration appConfiguration) {
        this.logger.debug("FIDO2 details to be updated - appConfiguration:{} ", (Object)appConfiguration);
        Fido2ConfigResource.checkResourceNotNull((Object)appConfiguration, (String)FIDO2_CONFIGURATION);
        this.fido2Service.merge(appConfiguration);
        appConfiguration = this.fido2Service.find();
        return Response.ok((Object)appConfiguration).build();
    }
}

