/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.link.rest;

import io.jans.configapi.core.rest.BaseResource;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.plugin.link.service.JansLinkService;
import io.jans.link.model.config.AppConfiguration;
import io.jans.model.ldap.GluuLdapConfiguration;
import io.jans.service.EncryptionService;
import io.jans.util.security.StringEncrypter;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.slf4j.Logger;

@Path(value="/link-config")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class JansLinkConfigResource
extends BaseResource {
    private static final String JANSLINK_CONFIGURATION = "jansLinkConfiguration";
    @Inject
    Logger logger;
    @Inject
    JansLinkService jansLinkService;
    @Inject
    private EncryptionService encryptionService;

    @Operation(summary="Gets Jans Link App configuration.", description="Gets Jans Link App configuration.", operationId="get-jans-link-properties", tags={"Jans Link - Configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jans-link.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppConfiguration.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/jans-link.readonly"}, groupScopes={"https://jans.io/oauth/config/jans-link.write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    public Response getJansLinkConfiguration() {
        AppConfiguration appConfiguration = this.jansLinkService.find();
        this.logger.debug("Jans Link details appConfiguration():{}", (Object)appConfiguration);
        return Response.ok((Object)appConfiguration).build();
    }

    @Operation(summary="Updates Jans Link configuration properties.", description="Updates Jans Link configuration properties.", operationId="put-jans-link-properties", tags={"Jans Link - Configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jans-link.write"})})
    @RequestBody(description="JansLinkConfiguration", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppConfiguration.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="JansLinkConfiguration", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppConfiguration.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PUT
    @ProtectedApi(scopes={"https://jans.io/oauth/config/jans-link.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response updateJansLinkConfiguration(@NotNull AppConfiguration appConfiguration) throws StringEncrypter.EncryptionException {
        this.logger.debug("Jans Link details to be updated - appConfiguration:{} ", (Object)appConfiguration);
        JansLinkConfigResource.checkResourceNotNull((Object)appConfiguration, (String)JANSLINK_CONFIGURATION);
        this.passwordEncryption(appConfiguration);
        this.jansLinkService.merge(appConfiguration);
        appConfiguration = this.jansLinkService.find();
        return Response.ok((Object)appConfiguration).build();
    }

    private AppConfiguration passwordEncryption(AppConfiguration appConfiguration) throws StringEncrypter.EncryptionException {
        this.logger.debug("Password  Encryption - appConfiguration:{} ", (Object)appConfiguration);
        if (appConfiguration == null) {
            return appConfiguration;
        }
        GluuLdapConfiguration config = appConfiguration.getInumConfig();
        this.passwordEncryption(config);
        appConfiguration.setInumConfig(config);
        config = appConfiguration.getTargetConfig();
        this.passwordEncryption(config);
        appConfiguration.setTargetConfig(config);
        List<GluuLdapConfiguration> sourceConfigList = appConfiguration.getSourceConfigs();
        if (sourceConfigList != null && !sourceConfigList.isEmpty()) {
            for (GluuLdapConfiguration ldapConfig : sourceConfigList) {
                this.passwordEncryption(ldapConfig);
                appConfiguration.setSourceConfigs(sourceConfigList);
            }
        }
        return appConfiguration;
    }

    private GluuLdapConfiguration passwordEncryption(GluuLdapConfiguration ldapConfiguration) throws StringEncrypter.EncryptionException {
        this.logger.debug("Password  Encryption - ldapConfiguration:{} ", (Object)ldapConfiguration);
        if (ldapConfiguration == null) {
            return ldapConfiguration;
        }
        String password = ldapConfiguration.getBindPassword();
        if (password != null && !password.isEmpty()) {
            try {
                this.encryptionService.decrypt(password);
            }
            catch (Exception ex) {
                this.logger.error("Exception while decryption of ldapConfiguration password hence will encrypt it!!!");
                ldapConfiguration.setBindPassword(this.encryptionService.encrypt(password));
            }
        }
        return ldapConfiguration;
    }
}

