/*
 * Decompiled with CFR 0.152.
 */
package io.jans.link.model;

import io.jans.model.JansCustomAttribute;
import io.jans.orm.annotation.CustomObjectClass;
import io.jans.orm.model.base.Entry;
import io.jans.util.StringHelper;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public abstract class CustomEntry
extends Entry
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 5079582184398161111L;
    @CustomObjectClass
    private String[] customObjectClasses;

    public abstract List<JansCustomAttribute> getCustomAttributes();

    public abstract void setCustomAttributes(List<JansCustomAttribute> var1);

    public String[] getCustomObjectClasses() {
        return this.customObjectClasses;
    }

    public void setCustomObjectClasses(String[] customObjectClasses) {
        this.customObjectClasses = customObjectClasses;
    }

    public Object[] getAttributes(String attributeName) {
        if (StringHelper.isEmpty((String)attributeName)) {
            return null;
        }
        Object[] values = null;
        for (JansCustomAttribute attribute : this.getCustomAttributes()) {
            if (!StringHelper.equalsIgnoreCase((String)attribute.getName(), (String)attributeName)) continue;
            values = attribute.getValues();
            break;
        }
        return values;
    }

    public Object getAttribute(String attributeName) {
        if (StringHelper.isEmpty((String)attributeName)) {
            return null;
        }
        Object value = null;
        for (JansCustomAttribute attribute : this.getCustomAttributes()) {
            if (!StringHelper.equalsIgnoreCase((String)attribute.getName(), (String)attributeName)) continue;
            value = attribute.getValue();
            break;
        }
        return value;
    }

    public Object getAttribute(String attributeName, Object defaultValue) {
        Object result = this.getAttribute(attributeName);
        if (StringHelper.isEmptyString((Object)result)) {
            result = defaultValue;
        }
        return result;
    }

    public String[] getStringAttributes(String attributeName) {
        if (StringHelper.isEmpty((String)attributeName)) {
            return null;
        }
        String[] values = null;
        for (JansCustomAttribute attribute : this.getCustomAttributes()) {
            if (!StringHelper.equalsIgnoreCase((String)attribute.getName(), (String)attributeName)) continue;
            values = attribute.getStringValues();
            break;
        }
        return values;
    }

    public String getStringAttribute(String attributeName) {
        if (StringHelper.isEmpty((String)attributeName)) {
            return null;
        }
        String value = null;
        for (JansCustomAttribute attribute : this.getCustomAttributes()) {
            if (!StringHelper.equalsIgnoreCase((String)attribute.getName(), (String)attributeName)) continue;
            value = attribute.getStringValue();
            break;
        }
        return value;
    }

    public JansCustomAttribute getCustomAttribute(String attributeName) {
        if (StringHelper.isEmpty((String)attributeName)) {
            return null;
        }
        for (JansCustomAttribute attribute : this.getCustomAttributes()) {
            if (!StringHelper.equalsIgnoreCase((String)attribute.getName(), (String)attributeName)) continue;
            return attribute;
        }
        return null;
    }

    public String[] getAttributeStringValues(String attributeName) {
        JansCustomAttribute customAttribute = this.getCustomAttribute(attributeName);
        if (customAttribute == null) {
            return null;
        }
        return customAttribute.getStringValues();
    }

    public void setAttribute(String attributeName, String attributeValue) {
        this.setAttribute(new JansCustomAttribute(attributeName, (Object)attributeValue));
    }

    public void setAttribute(String attributeName, String[] attributeValue) {
        this.setAttribute(new JansCustomAttribute(attributeName, (Object[])attributeValue));
    }

    public void setAttribute(JansCustomAttribute attribute) {
        List<JansCustomAttribute> customAttributes = this.getCustomAttributes();
        customAttributes.remove(attribute);
        customAttributes.add(attribute);
    }

    public String toString() {
        return String.format("CustomEntry [customAttributes=%s, customObjectClasses=%s, toString()=%s]", this.getCustomAttributes(), Arrays.toString(this.customObjectClasses), super.toString());
    }
}

