/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.link.service;

import io.jans.configapi.configuration.ConfigurationFactory;
import io.jans.link.model.config.AppConfiguration;
import io.jans.link.model.config.Conf;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.exception.BasePersistenceException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.slf4j.Logger;

@ApplicationScoped
public class JansLinkService {
    @Inject
    Logger logger;
    @Inject
    PersistenceEntryManager persistenceManager;
    @Inject
    ConfigurationFactory configurationFactory;

    public Conf findConf() {
        try {
            String configurationDn = this.configurationFactory.getBaseConfiguration().getString("link_ConfigurationEntryDN");
            return (Conf)this.persistenceManager.find(Conf.class, (Object)configurationDn);
        }
        catch (BasePersistenceException var3) {
            this.logger.error("Failed to load jans-link configuration from LDAP");
            return null;
        }
    }

    public AppConfiguration find() {
        Conf conf = this.findConf();
        return conf.getDynamic();
    }

    public void mergeConf(Conf conf) {
        conf.setRevision(conf.getRevision() + 1L);
        this.persistenceManager.merge((Object)conf);
    }

    public void merge(AppConfiguration appConfiguration) {
        Conf conf = this.findConf();
        conf.setDynamic(appConfiguration);
        this.mergeConf(conf);
    }
}

