/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.kc.link.service;

import io.jans.configapi.configuration.ConfigurationFactory;
import io.jans.keycloak.link.model.config.AppConfiguration;
import io.jans.keycloak.link.model.config.Conf;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.util.properties.FileConfiguration;
import io.jans.util.exception.InvalidConfigurationException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class KcLinkConfigService {
    @Inject
    Logger logger;
    @Inject
    @Named(value="persistenceEntryManager")
    PersistenceEntryManager persistenceManager;
    @Inject
    ConfigurationFactory configurationFactory;

    public FileConfiguration getBaseConfiguration() {
        this.logger.info(" configurationFactory.getBaseConfiguration():{}", (Object)this.configurationFactory.getBaseConfiguration());
        return this.configurationFactory.getBaseConfiguration();
    }

    public String getKcLinkDn() {
        String dn = this.getBaseConfiguration().getString("keycloakLink_ConfigurationEntryDN");
        this.logger.info(" kcLinkDn:{}", (Object)dn);
        return dn;
    }

    public Conf findKcLinkConf() {
        String dn = this.getKcLinkDn();
        this.logger.info(" dn:{}", (Object)dn);
        if (StringUtils.isBlank((CharSequence)dn)) {
            throw new InvalidConfigurationException("Kc Link Configuration DN is undefined!");
        }
        Conf kcLinkconf = (Conf)this.persistenceManager.find((Object)dn, Conf.class, null);
        this.logger.info(" kcLinkconf:{}", (Object)kcLinkconf);
        return kcLinkconf;
    }

    public void mergeKcLinkConfig(Conf kcLinkconf) {
        kcLinkconf.setRevision(kcLinkconf.getRevision() + 1L);
        this.persistenceManager.merge((Object)kcLinkconf);
    }

    public AppConfiguration find() {
        return this.findKcLinkConf().getDynamic();
    }
}

